/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.systeminfo;

import java.io.File;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.systeminfo.Architecture;
import si.nevensrok.common.systeminfo.OperatingSystem;

public class SystemInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInfo.class);

    public static OperatingSystem getSystemOS() {
        if (System.getProperty("os.name").contains("Windows")) {
            return OperatingSystem.WINDOWS;
        }
        if (System.getProperty("os.name").contains("Linux")) {
            return OperatingSystem.LINUX;
        }
        if (System.getProperty("os.name").contains("Mac")) {
            return OperatingSystem.MACOSX;
        }
        return null;
    }

    public static Architecture getArchitecture() {
        if (System.getProperty("os.arch").equalsIgnoreCase("x86")) {
            return Architecture.X86;
        }
        if (System.getProperty("os.arch").equalsIgnoreCase("amd64")) {
            return Architecture.AMD64;
        }
        if (System.getProperty("os.arch").equalsIgnoreCase("x86_64")) {
            return Architecture.X86_64;
        }
        return null;
    }

    public static File getUserHomeDir() {
        String homedir = System.getenv("HOME");
        if (homedir == null && (homedir = System.getenv("HOMEPATH")) != null) {
            String homeDrive = System.getenv("HOMEDRIVE");
            homedir = homeDrive + homedir;
        }
        if (homedir != null) {
            File dir = new File(homedir);
            if (dir.isDirectory()) {
                return dir;
            }
            return null;
        }
        return null;
    }

    public static Integer getPid() {
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            int n = processName.indexOf(64);
            Integer pid = Integer.parseInt(processName.substring(0, n));
            return pid;
        }
        catch (Exception e) {
            LOGGER.warn("Error fetching pid", (Throwable)e);
            return null;
        }
    }

    public static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

