/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.NetworkMessageReceiver;
import si.nevensrok.common.network.udp.MessageReceiver;

public abstract class AbstractMessagesReceiver
implements NetworkMessageReceiver,
InitializingBean,
DisposableBean {
    private int bufferSize = 65536;
    private MessageReceiver messageReceiver;
    private NetworkMessageHandler networkMessageHandler;
    protected DatagramSocket socket;
    private Executor executor = null;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public Integer getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    abstract DatagramSocket openSocket() throws IOException;

    protected MessageReceiver generateMessageReceiver(DatagramSocket socket, int bufferSize, Executor executor, NetworkMessageHandler nmh) throws Exception {
        return new MessageReceiver(socket, bufferSize, executor, nmh);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.socket = this.openSocket();
            this.messageReceiver = this.generateMessageReceiver(this.socket, this.bufferSize, this.executor, this.networkMessageHandler);
        }
        catch (Exception e) {
            try {
                this.messageReceiver.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to datagram socket", e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.messageReceiver.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.messageReceiver = null;
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public void setNetworkMessageHandler(NetworkMessageHandler networkMessageHandler) {
        this.networkMessageHandler = networkMessageHandler;
        if (this.messageReceiver != null) {
            this.messageReceiver.setNetworkMessageHandler(networkMessageHandler);
        }
    }
}

