/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.newaza;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class NewazaPointBox
extends JPanel {
    private CompetitorType competitorType;
    private PointType pointType;
    private JLabel pointNameLabel = new JLabel();
    private JLabel pointValueLabel = new JLabel("0");
    private NewazaPoints newazaPoints;
    private MatchData matchData;
    private TablaManager tablaManager;
    private Color backgroundColor;

    public NewazaPointBox(String pointName, CompetitorType competitorType, PointType pointType) {
        this.competitorType = competitorType;
        this.pointType = pointType;
        this.pointNameLabel.setText(pointName);
        this.pointNameLabel.setHorizontalAlignment(0);
        this.pointValueLabel.setHorizontalAlignment(0);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.pointNameLabel);
        this.add(this.pointValueLabel);
        this.pointValueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    NewazaPointBox.this.increasePoint();
                } else {
                    NewazaPointBox.this.decreasePoint();
                }
            }
        });
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    private void increasePoint() {
        if (this.pointType == PointType.POINT2) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getPoint1_2() + 1;
                this.newazaPoints.setPoint1_2(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.newazaPoints.getPoint2_2() + 1;
                this.newazaPoints.setPoint2_2(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.POINT3) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getPoint1_3() + 1;
                this.newazaPoints.setPoint1_3(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.newazaPoints.getPoint2_3() + 1;
                this.newazaPoints.setPoint2_3(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.POINT4) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getPoint1_4() + 1;
                this.newazaPoints.setPoint1_4(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.newazaPoints.getPoint2_4() + 1;
                this.newazaPoints.setPoint2_4(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.POINT100) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getPoint1_100() + 1;
                this.newazaPoints.setPoint1_100(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.newazaPoints.getPoint2_100() + 1;
                this.newazaPoints.setPoint2_100(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.ADVANTAGE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getAdvantage1() + 1;
                this.newazaPoints.setAdvantage1(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.newazaPoints.getAdvantage2() + 1;
                this.newazaPoints.setAdvantage2(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.PENALTY) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.PENALTY, this.newazaPoints.getPenalty1() + 1, CompetitorType.COMPETITOR1));
                AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
                ageCategoryOption.setNewazaPenaltyHansokumake(Integer.valueOf(this.matchData.getNewazaPenaltyHansokumake()));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, points, ageCategoryOption);
                if (!isHansokumake) {
                    int p = this.newazaPoints.getPenalty1() + 1;
                    this.newazaPoints.setPenalty1(p);
                    if (p == 2) {
                        int adv = this.newazaPoints.getAdvantage2() + 1;
                        this.newazaPoints.setAdvantage2(adv);
                    } else if (p >= 3) {
                        int pn = this.newazaPoints.getPoint2_2() + 1;
                        this.newazaPoints.setPoint2_2(pn);
                    }
                } else {
                    this.newazaPoints.setHansokumake1(1);
                    this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.PENALTY, this.newazaPoints.getPenalty2() + 1, CompetitorType.COMPETITOR2));
                AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
                ageCategoryOption.setNewazaPenaltyHansokumake(Integer.valueOf(this.matchData.getNewazaPenaltyHansokumake()));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, points, ageCategoryOption);
                if (!isHansokumake) {
                    int p = this.newazaPoints.getPenalty2() + 1;
                    this.newazaPoints.setPenalty2(p);
                    if (p == 2) {
                        int adv = this.newazaPoints.getAdvantage1() + 1;
                        this.newazaPoints.setAdvantage1(adv);
                    } else if (p >= 3) {
                        int pn = this.newazaPoints.getPoint1_2() + 1;
                        this.newazaPoints.setPoint1_2(pn);
                    }
                } else {
                    this.newazaPoints.setHansokumake2(1);
                    this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.newazaPoints.getHansokumake1() == 0) {
                    this.newazaPoints.setHansokumake1(1);
                    this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && this.newazaPoints.getHansokumake2() == 0) {
                this.newazaPoints.setHansokumake2(1);
                this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    private void decreasePoint() {
        if (this.pointType == PointType.POINT2) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p2 = this.newazaPoints.getPoint1_2() - 1;
                if (p2 >= 0) {
                    this.newazaPoints.setPoint1_2(p2);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.newazaPoints.getPoint2_2() - 1) >= 0) {
                this.newazaPoints.setPoint2_2(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.POINT3) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p3 = this.newazaPoints.getPoint1_3() - 1;
                if (p3 >= 0) {
                    this.newazaPoints.setPoint1_3(p3);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.newazaPoints.getPoint2_3() - 1) >= 0) {
                this.newazaPoints.setPoint2_3(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.POINT4) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p4 = this.newazaPoints.getPoint1_4() - 1;
                if (p4 >= 0) {
                    this.newazaPoints.setPoint1_4(p4);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.newazaPoints.getPoint2_4() - 1) >= 0) {
                this.newazaPoints.setPoint2_4(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.POINT100) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p5 = this.newazaPoints.getPoint1_100() - 1;
                if (p5 >= 0) {
                    this.newazaPoints.setPoint1_100(p5);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.newazaPoints.getPoint2_100() - 1) >= 0) {
                this.newazaPoints.setPoint2_100(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.ADVANTAGE) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p6 = this.newazaPoints.getAdvantage1() - 1;
                if (p6 >= 0) {
                    this.newazaPoints.setAdvantage1(p6);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.newazaPoints.getAdvantage2() - 1) >= 0) {
                this.newazaPoints.setAdvantage2(p);
            }
            this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.PENALTY) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.newazaPoints.getPenalty1() - 1;
                if (p >= 0) {
                    int pn;
                    this.newazaPoints.setPenalty1(p);
                    if (p == 1) {
                        int adv = this.newazaPoints.getAdvantage2() - 1;
                        if (adv >= 0) {
                            this.newazaPoints.setAdvantage2(adv);
                        }
                    } else if (p >= 2 && (pn = this.newazaPoints.getPoint2_2() - 1) >= 0) {
                        this.newazaPoints.setPoint2_2(pn);
                    }
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int pn;
                int p = this.newazaPoints.getPenalty2() - 1;
                if (p >= 0) {
                    this.newazaPoints.setPenalty2(p);
                }
                if (p == 1) {
                    int adv = this.newazaPoints.getAdvantage1() - 1;
                    if (adv >= 0) {
                        this.newazaPoints.setAdvantage1(adv);
                    }
                } else if (p >= 2 && (pn = this.newazaPoints.getPoint1_2() - 1) >= 0) {
                    this.newazaPoints.setPoint1_2(pn);
                }
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.newazaPoints.getHansokumake1() == 1) {
                    this.newazaPoints.setHansokumake1(0);
                    this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.REMOVE));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && this.newazaPoints.getHansokumake2() == 1) {
                this.newazaPoints.setHansokumake2(0);
                this.newazaPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.REMOVE));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    public void redrawElements() {
        if (this.pointType == PointType.POINT2) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint1_2()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint2_2()));
            }
        } else if (this.pointType == PointType.POINT3) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint1_3()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint2_3()));
            }
        } else if (this.pointType == PointType.POINT4) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint1_4()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint2_4()));
            }
        } else if (this.pointType == PointType.POINT100) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint1_100()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPoint2_100()));
            }
        } else if (this.pointType == PointType.ADVANTAGE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getAdvantage1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getAdvantage2()));
            }
        } else if (this.pointType == PointType.PENALTY) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPenalty1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getPenalty2()));
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getHansokumake1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValueLabel.setText(String.valueOf(this.newazaPoints.getHansokumake2()));
            }
        }
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointNameLabel, "P100");
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointValueLabel, "P100");
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.backgroundColor = bg;
        if (this.pointNameLabel != null) {
            this.pointNameLabel.setBackground(bg);
        }
        if (this.pointValueLabel != null) {
            this.pointValueLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointNameLabel != null) {
            this.pointNameLabel.setForeground(fg);
        }
        if (this.pointValueLabel != null) {
            this.pointValueLabel.setForeground(fg);
        }
    }

    private MatchPoint generateMatchPoint(PointType pointType, float points, CompetitorType competitorType) {
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setPointType(pointType);
        matchPoint.setPoints(Float.valueOf(points));
        matchPoint.setCompetitor(competitorType);
        return matchPoint;
    }
}

