/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPresentationPenaltyDocument;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPresentationVarietyDocument;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationJudgePoints;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPresentationPointsPanel
extends JPanel
implements DuoPointsPanel {
    private JPanel pointDetailPanel = new JPanel();
    private MatchData matchData;
    private DuoPresentationJudgePoints[] judgePoints = new DuoPresentationJudgePoints[3];
    private JLabel pointsSum = new JLabel("0");
    private JLabel vrDataSentLabel = new JLabel("");
    private JLabel varietyLabel = new JLabel("Variety");
    private JTextField variety3TextField = new JTextField("0");
    private JTextField variety4TextField = new JTextField("0");
    private JLabel penaltyLabel = new JLabel("Penalty");
    private JTextField penaltyTextField = new JTextField("0");
    private DuoPresentationPoints duoPresentationPoints;
    private TablaManager tablaManager;
    private boolean documentForFieldsSet = false;

    public DuoPresentationPointsPanel() {
        this.setLayout(null);
        this.add(this.pointDetailPanel);
        this.pointDetailPanel.setLayout(new GridLayout(2, 2));
        this.judgePoints[0] = new DuoPresentationJudgePoints(1);
        this.judgePoints[1] = new DuoPresentationJudgePoints(2);
        this.judgePoints[2] = new DuoPresentationJudgePoints(3);
        this.pointDetailPanel.add(this.judgePoints[0]);
        this.pointDetailPanel.add(this.pointsSum);
        this.pointDetailPanel.add(this.judgePoints[1]);
        this.pointDetailPanel.add(this.judgePoints[2]);
        this.vrDataSentLabel.setHorizontalAlignment(0);
        this.varietyLabel.setHorizontalAlignment(4);
        this.penaltyLabel.setHorizontalAlignment(4);
        this.pointsSum.setHorizontalAlignment(0);
        this.variety3TextField.setHorizontalAlignment(0);
        this.variety4TextField.setHorizontalAlignment(0);
        this.penaltyTextField.setHorizontalAlignment(0);
        this.add(this.vrDataSentLabel);
        this.add(this.varietyLabel);
        this.add(this.variety3TextField);
        this.add(this.variety4TextField);
        this.add(this.penaltyLabel);
        this.add(this.penaltyTextField);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setMatchData(matchData);
        }
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setDuoPresentationPoints(duoPresentationPoints);
        }
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setTablaManager(tablaManager);
        }
        this.setDocumentForFields();
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setWindowKeyListener(windowKeyListener);
        }
        this.variety3TextField.addKeyListener(windowKeyListener);
        this.variety4TextField.addKeyListener(windowKeyListener);
        this.penaltyTextField.addKeyListener(windowKeyListener);
    }

    public void setDuoFieldSelector() {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setDuoFieldSelector(this);
        }
    }

    private void setDocumentForFields() {
        if (this.duoPresentationPoints == null || this.tablaManager == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        this.variety3TextField.setDocument(new DuoPresentationVarietyDocument(this.duoPresentationPoints, 3, this.tablaManager));
        this.variety4TextField.setDocument(new DuoPresentationVarietyDocument(this.duoPresentationPoints, 4, this.tablaManager));
        this.penaltyTextField.setDocument(new DuoPresentationPenaltyDocument(this.duoPresentationPoints, this.tablaManager));
    }

    public void redrawElements() {
        final int width = this.getWidth();
        final int height = this.getHeight();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pointDetailHeight = (int)Math.floor((float)height * 0.9f);
                DuoPresentationPointsPanel.this.pointDetailPanel.setLocation(0, 0);
                DuoPresentationPointsPanel.this.pointDetailPanel.setSize(width, pointDetailHeight);
                int vrDataSentLabelWidth = (int)Math.floor((float)width * 0.1f);
                int varietyHeight = height - pointDetailHeight;
                DuoPresentationPointsPanel.this.vrDataSentLabel.setLocation(0, pointDetailHeight);
                DuoPresentationPointsPanel.this.vrDataSentLabel.setSize(vrDataSentLabelWidth, varietyHeight);
                if (DuoPresentationPointsPanel.this.matchData.isVrRefereePoints()) {
                    DuoPresentationPointsPanel.this.vrDataSentLabel.setText("\u2713");
                } else {
                    DuoPresentationPointsPanel.this.vrDataSentLabel.setText("");
                }
                int varietyLabelWidth = (int)Math.floor((float)width * 0.3f);
                DuoPresentationPointsPanel.this.varietyLabel.setLocation(vrDataSentLabelWidth, pointDetailHeight);
                DuoPresentationPointsPanel.this.varietyLabel.setSize(varietyLabelWidth, varietyHeight);
                DuoPresentationPointsPanel.this.varietyLabel.setText(DuoPresentationPointsPanel.this.tablaManager.getLanguageText("text.variety"));
                int varietyTextFieldWidth = (int)Math.floor((float)width * 0.1f);
                DuoPresentationPointsPanel.this.variety3TextField.setLocation(vrDataSentLabelWidth + varietyLabelWidth, pointDetailHeight);
                DuoPresentationPointsPanel.this.variety3TextField.setSize(varietyTextFieldWidth, varietyHeight);
                DuoPresentationPointsPanel.this.variety4TextField.setLocation(varietyTextFieldWidth + vrDataSentLabelWidth + varietyLabelWidth, pointDetailHeight);
                DuoPresentationPointsPanel.this.variety4TextField.setSize(varietyTextFieldWidth, varietyHeight);
                if (DuoPresentationPointsPanel.this.matchData.isVideoReferee()) {
                    DuoPresentationPointsPanel.this.variety3TextField.setEnabled(false);
                    DuoPresentationPointsPanel.this.variety4TextField.setEnabled(false);
                } else {
                    DuoPresentationPointsPanel.this.variety3TextField.setEnabled(true);
                    DuoPresentationPointsPanel.this.variety4TextField.setEnabled(true);
                }
                int penaltyLabelWidth = (int)Math.floor((float)width * 0.3f);
                DuoPresentationPointsPanel.this.penaltyLabel.setLocation(vrDataSentLabelWidth + varietyLabelWidth + varietyTextFieldWidth * 2, pointDetailHeight);
                DuoPresentationPointsPanel.this.penaltyLabel.setSize(penaltyLabelWidth, varietyHeight);
                DuoPresentationPointsPanel.this.penaltyLabel.setText(DuoPresentationPointsPanel.this.tablaManager.getLanguageText("text.penalty"));
                int penaltyTextFieldWidth = width - vrDataSentLabelWidth - varietyLabelWidth - varietyTextFieldWidth * 2 - penaltyLabelWidth;
                DuoPresentationPointsPanel.this.penaltyTextField.setLocation(vrDataSentLabelWidth + varietyLabelWidth + varietyTextFieldWidth * 2 + penaltyLabelWidth, pointDetailHeight);
                DuoPresentationPointsPanel.this.penaltyTextField.setSize(penaltyTextFieldWidth, varietyHeight);
                if (DuoPresentationPointsPanel.this.matchData.isVideoReferee()) {
                    DuoPresentationPointsPanel.this.penaltyTextField.setEnabled(false);
                } else {
                    DuoPresentationPointsPanel.this.penaltyTextField.setEnabled(true);
                }
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.pointsSum);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.vrDataSentLabel);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.varietyLabel);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.variety3TextField);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.variety4TextField);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.penaltyLabel);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.penaltyTextField);
                DuoPresentationPointsPanel.this.repaint();
            }
        });
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.redrawElements();
        }
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPresentationPointsPanel.this.pointsSum.setText(Constants.FIGHT_POINTS_FORMAT.format(points));
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.pointsSum);
            }
        });
    }

    @Override
    public void resetPoints() {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.resetPoints();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DuoPresentationPointsPanel.this.duoPresentationPoints != null) {
                    DuoPresentationPointsPanel.this.variety3TextField.setText(Constants.FIGHT_POINTS_FORMAT.format(DuoPresentationPointsPanel.this.duoPresentationPoints.getVariety3()));
                    DuoPresentationPointsPanel.this.variety4TextField.setText(Constants.FIGHT_POINTS_FORMAT.format(DuoPresentationPointsPanel.this.duoPresentationPoints.getVariety4()));
                    DuoPresentationPointsPanel.this.penaltyTextField.setText(Constants.FIGHT_POINTS_FORMAT.format(DuoPresentationPointsPanel.this.duoPresentationPoints.getPenalty()));
                }
            }
        });
    }

    @Override
    public void selectFirstField() {
        this.selectField(1);
    }

    @Override
    public void selectPrevField() {
        List<DuoPresentationAttack> attacks;
        int selected = this.getSelectedField() - 1;
        if (selected < 1) {
            selected = 90;
        }
        if ((attacks = this.getAttacks()).isEmpty()) {
            return;
        }
        for (int i = 0; i < 90; ++i) {
            if (this.isFieldEnabled(attacks, selected)) {
                this.selectField(selected);
                return;
            }
            if (--selected >= 1) continue;
            selected = 90;
        }
    }

    @Override
    public void selectNextField() {
        List<DuoPresentationAttack> attacks;
        int selected = this.getSelectedField() + 1;
        if (selected > 90) {
            selected = 1;
        }
        if ((attacks = this.getAttacks()).isEmpty()) {
            return;
        }
        for (int i = 0; i < 90; ++i) {
            if (this.isFieldEnabled(attacks, selected)) {
                this.selectField(selected);
                return;
            }
            if (++selected <= 90) continue;
            selected = 1;
        }
    }

    @Override
    public void recalculateRoundPoints() {
    }

    public void selectField(int index) {
        int judge = (index - 1) / 30;
        this.judgePoints[judge].selectField((index - 1) % 30 + 1);
    }

    public int getSelectedField() {
        for (int i = 0; i < this.judgePoints.length; ++i) {
            int n = this.judgePoints[i].getSelectedField();
            if (n <= 0) continue;
            return i * 30 + n;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setBackground(bg);
        }
        if (this.judgePoints != null) {
            for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
                if (duoPresentationJudgePoints == null) continue;
                duoPresentationJudgePoints.setBackground(bg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setBackground(bg);
        }
        if (this.vrDataSentLabel != null) {
            this.vrDataSentLabel.setBackground(bg);
        }
        if (this.varietyLabel != null) {
            this.varietyLabel.setBackground(bg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setForeground(fg);
        }
        if (this.judgePoints != null) {
            for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
                if (duoPresentationJudgePoints == null) continue;
                duoPresentationJudgePoints.setForeground(fg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setForeground(fg);
        }
        if (this.vrDataSentLabel != null) {
            this.vrDataSentLabel.setForeground(fg);
        }
        if (this.varietyLabel != null) {
            this.varietyLabel.setForeground(fg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setForeground(fg);
        }
    }

    private List<DuoPresentationAttack> getAttacks() {
        AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
        ageCategoryOption.setAge(Integer.valueOf(this.matchData.getAge()));
        return new ArrayList<DuoPresentationAttack>(this.tablaManager.getCurrentCompetitionRules().getDuoPresentationAttacks(ageCategoryOption, this.matchData.getRound().ordinal() + 1));
    }

    private boolean isFieldEnabled(List<DuoPresentationAttack> attacks, int field) {
        int row = (field - 1) % 30 / 5;
        int part = (field - 1) % 30 % 5 + 1;
        if (row >= attacks.size()) {
            return false;
        }
        DuoPresentationAttack duoPresentationAttack = attacks.get(row);
        return duoPresentationAttack.getParts().contains(part);
    }
}

