/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duo;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoPointsRow;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPointsPanel
extends JPanel
implements si.nevensrok.jtekma.tabla.gui.DuoPointsPanel {
    private JPanel pointsRowsPanel = new JPanel();
    private DuoPointsRow[] pointRows = new DuoPointsRow[5];
    private JLabel totalPointsLabel = new JLabel("0.0");

    public DuoPointsPanel(CompetitorType competitorType) {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.pointsRowsPanel);
        this.pointsRowsPanel.setLayout(new GridLayout(this.pointRows.length, 1));
        for (int i = 0; i < this.pointRows.length; ++i) {
            this.pointRows[i] = new DuoPointsRow(competitorType, i + 1);
            this.pointsRowsPanel.add(this.pointRows[i]);
        }
        this.add(this.totalPointsLabel);
        this.totalPointsLabel.setHorizontalAlignment(0);
    }

    public void setMatchData(MatchData matchData) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setMatchData(matchData);
        }
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setDuoPoints(duoPoints);
        }
    }

    public void setTablaManager(TablaManager tablaManager) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setTablaManager(tablaManager);
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setWindowKeyListener(windowKeyListener);
        }
    }

    public void setDuoFieldSelector(DuoFieldSelector duoFieldSelector) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setDuoFieldSelector(duoFieldSelector);
        }
    }

    public void redrawElements() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.redrawElements();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsPanel.this.totalPointsLabel);
            }
        });
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPointsPanel.this.totalPointsLabel.setText(Constants.DUO_POINTS_FORMAT.format(points));
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsPanel.this.totalPointsLabel);
            }
        });
    }

    @Override
    public void resetPoints() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.resetPoints();
        }
    }

    @Override
    public void selectFirstField() {
        this.selectField(1);
    }

    @Override
    public void selectPrevField() {
    }

    @Override
    public void selectNextField() {
    }

    @Override
    public void recalculateRoundPoints() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.recalculateRoundPoints();
        }
    }

    public void selectField(int index) {
        int round = (index - 1) / 5;
        this.pointRows[round].selectField((index - 1) % 5 + 1);
    }

    public int getSelectedField() {
        for (int i = 0; i < this.pointRows.length; ++i) {
            int n = this.pointRows[i].getSelectedField();
            if (n <= 0) continue;
            return i * this.pointRows.length + n;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointRows != null) {
            for (DuoPointsRow pointsRow : this.pointRows) {
                if (pointsRow == null) continue;
                pointsRow.setBackground(bg);
            }
        }
        if (this.pointsRowsPanel != null) {
            this.pointsRowsPanel.setBackground(bg);
        }
        if (this.totalPointsLabel != null) {
            this.totalPointsLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointRows != null) {
            for (DuoPointsRow pointsRow : this.pointRows) {
                if (pointsRow == null) continue;
                pointsRow.setForeground(fg);
            }
        }
        if (this.pointsRowsPanel != null) {
            this.pointsRowsPanel.setForeground(fg);
        }
        if (this.totalPointsLabel != null) {
            this.totalPointsLabel.setForeground(fg);
        }
    }
}

