/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.duo;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;

public class DuoPresentationVarietyDocument
extends PlainDocument {
    private DuoPresentationPoints duoPresentationPoints;
    private TablaManager tablaManager;
    private int part;

    public DuoPresentationVarietyDocument(DuoPresentationPoints duoPresentationPoints, int part, TablaManager tablaManager) {
        this.duoPresentationPoints = duoPresentationPoints;
        this.tablaManager = tablaManager;
        this.part = part;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            int newNum;
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.insert(offs, str);
            if (buffer.length() > 1 && buffer.charAt(0) == '0') {
                super.remove(0, 1);
                buffer.deleteCharAt(0);
            }
            if ((newNum = Integer.parseInt(buffer.toString())) >= 0 && newNum <= 9) {
                super.insertString(0, str, a);
                this.updatePoints();
                this.tablaManager.recalculatePoints();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        try {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.delete(offs, offs + len);
            if (buffer.length() == 0) {
                super.remove(offs, len);
                if (this.part == 3) {
                    this.duoPresentationPoints.setVariety3(0);
                } else if (this.part == 4) {
                    this.duoPresentationPoints.setVariety4(0);
                }
                this.tablaManager.recalculatePoints();
            } else {
                int newNum = Integer.parseInt(buffer.toString());
                if (newNum >= 0 && newNum <= 9) {
                    super.remove(offs, len);
                    this.updatePoints();
                    this.tablaManager.recalculatePoints();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePoints() throws NumberFormatException, BadLocationException {
        if (this.part == 3) {
            this.duoPresentationPoints.setVariety3(Integer.parseInt(super.getText(0, super.getLength())));
        } else if (this.part == 4) {
            this.duoPresentationPoints.setVariety4(Integer.parseInt(super.getText(0, super.getLength())));
        }
    }
}

