/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.duo;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.fw.TablaManager;

public class Duo2023VarietyDocument
extends PlainDocument {
    private CompetitorType competitorType;
    private Duo2023Points duo2023Points;
    private TablaManager tablaManager;
    private int part;

    public Duo2023VarietyDocument(CompetitorType competitorType, Duo2023Points duo2023Points, int part, TablaManager tablaManager) {
        this.competitorType = competitorType;
        this.duo2023Points = duo2023Points;
        this.tablaManager = tablaManager;
        this.part = part;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            int newNum;
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.insert(offs, str);
            if (buffer.length() > 1 && buffer.charAt(0) == '0') {
                super.remove(0, 1);
                buffer.deleteCharAt(0);
            }
            if ((newNum = Integer.parseInt(buffer.toString())) >= 0 && newNum <= 9) {
                super.insertString(0, str, a);
                this.updatePoints();
                this.tablaManager.recalculatePoints();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        try {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.delete(offs, offs + len);
            if (buffer.length() == 0) {
                super.remove(offs, len);
                if (this.competitorType == CompetitorType.COMPETITOR1) {
                    if (this.part == 3) {
                        this.duo2023Points.setVariety13(0);
                    } else if (this.part == 4) {
                        this.duo2023Points.setVariety14(0);
                    }
                } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                    if (this.part == 3) {
                        this.duo2023Points.setVariety23(0);
                    } else if (this.part == 4) {
                        this.duo2023Points.setVariety24(0);
                    }
                }
                this.tablaManager.recalculatePoints();
            } else {
                int newNum = Integer.parseInt(buffer.toString());
                if (newNum >= 0 && newNum <= 9) {
                    super.remove(offs, len);
                    this.updatePoints();
                    this.tablaManager.recalculatePoints();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePoints() throws NumberFormatException, BadLocationException {
        if (this.competitorType == CompetitorType.COMPETITOR1) {
            if (this.part == 3) {
                this.duo2023Points.setVariety13(Integer.parseInt(super.getText(0, super.getLength())));
            } else if (this.part == 4) {
                this.duo2023Points.setVariety14(Integer.parseInt(super.getText(0, super.getLength())));
            }
        } else if (this.competitorType == CompetitorType.COMPETITOR2) {
            if (this.part == 3) {
                this.duo2023Points.setVariety23(Integer.parseInt(super.getText(0, super.getLength())));
            } else if (this.part == 4) {
                this.duo2023Points.setVariety24(Integer.parseInt(super.getText(0, super.getLength())));
            }
        }
    }
}

