(function() {
	var weighing = definePackage("weighing");

	//search
    var search = definePackage("weighing.search");

	search.model = Backbone.Model.extend({
		"defaults": {
			"name": "",
			"club": "",
			"displayPerPage": 20
		}
	});
	
	search.view = Backbone.View.extend({
		"template": templates.getTemplate("/weighing/template/search"),
		"initialize": function() {
			this.model.on("change",function() {
				
			}, this);
		},
		"render":function() {
			var obj = this;
			
			var data = this.model.toJSON();
			$(this.el).html(Mustache.render(this.template, data));
			
			$("select[name='displayPerPage']", this.el).val(data.displayPerPage);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$(".chosen-select", this.el).each(function(index) {
				var width = $(this).attr("width");
				var options = {
					"search_contains": true
				};
				if (width) {
					options.width = width;
				}
				$(this).chosen(options);
			});
			
			$("input[name='name'], input[name='club'], select[name='displayPerPage']", this.el).on("change", function() {
				obj.model.set($(this).attr("name"), $(this).val());
			});
			
			$("button", this.el).on("click", function() {
				obj.model.trigger("change");
			});
			
			return this;
		}
	});
	
	//competitors
	var competitor = definePackage("weighing.competitor");

	competitor.model = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": "",
			"surname": "",
			"clubName": "",
			"categories": [],
			"yearOfBirth": 0,
			"weight": 0
		}
	});
	
	competitor.collection = Backbone.Collection.extend({
		"url": function() { return contextPath+"/weighing/competitors"; },
		"model": competitor.model,
		"fetch": function(searchData) {
			var obj = this;
			$.ajax({
				"url": obj.url(),
				"type": "POST",
				"contentType": "application/json; charset=utf-8",
				"data": JSON.stringify(searchData),
				success: function(responseData) {
					obj.reset(responseData);
				}
			});
		}
	});
	
	competitor.rowView = Backbone.View.extend({
		"template": templates.getTemplate("/weighing/template/competitor-row"),
		"initialize": function() {
			this.model.on("change",function() {
				this.reloadData();
			}, this);
		},
		"render": function() {
			var obj = this;
			
			var data = this.model.toJSON();
			
			$(this.el).html(Mustache.render(this.template,data));
			
			$("select[name='categories']", this.el).val(this.model.get("categories"));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$(".chosen-select", this.el).each(function(index) {
				var width = $(this).attr("width");
				var options = {
					"search_contains": true
				};
				if (width) {
					options.width = width;
				}
				$(this).chosen(options);
			});
			
			$("button.save", this.el).on("click", function() {
				var comeptitorData = obj.model.toJSON();
				comeptitorData.weight = Number($("input[name='weight']", obj.el).val());
				comeptitorData.yearOfBirth = Number($("input[name='yearOfBirth']", obj.el).val());
				comeptitorData.categories = [];
				
				var selectedCategories = $("select[name='categories']", obj.el).val();
				if (isNull(selectedCategories)) {
                    selectedCategories = [];
                }
				
				for (var i = 0; i < selectedCategories.length; i++) {
					comeptitorData.categories.push(Number(selectedCategories[i]));
				}
				
				$.ajax({
					"url": contextPath + "/weighing/save-competitor",
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(comeptitorData),
					success: function(responseData) {
						obj.model.set("weight", comeptitorData.weight);
						obj.model.set("yearOfBirth", comeptitorData.yearOfBirth);
						obj.model.set("categories", comeptitorData.categories);
						obj.reloadData();
					}
				});
			});
			
			$("button.reset", this.el).on("click", function() {
				obj.reloadData();
			});
			
			$("input[name='weight'], input[name='yearOfBirth'], select[name='categories']", this.el).on("change", function() {
				obj.markChange();
			});
			
			return this;
		},
		"reloadData": function() {
			$("input[name='weight']", this.el).val(this.model.get("weight"));
			$("input[name='yearOfBirth']", this.el).val(this.model.get("yearOfBirth"));
			
			$("select[name='categories']" ,this.el).val(this.model.get("categories"));
			$("select[name='categories']" ,this.el).trigger("liszt:updated");
			$("select[name='categories']" ,this.el).trigger('chosen:updated');
			
			this.markChange();
		},
		"markChange": function() {
			var hasChanged = false;
			
			hasChanged = hasChanged || $("input[name='weight']", this.el).val() != this.model.get("weight");
			hasChanged = hasChanged || $("input[name='yearOfBirth']", this.el).val() != this.model.get("yearOfBirth");
			
			var currentCategories = this.model.get("categories");
			var selectedCategories = $("select[name='categories']", this.el).val();
            if (isNull(selectedCategories)) {
                selectedCategories = [];
            }

			hasChanged = hasChanged || currentCategories.length != selectedCategories.length;
			for (var i = 0; i < currentCategories.length; i++) {
				hasChanged = hasChanged || selectedCategories.indexOf(currentCategories[i]) >= 0;
			}
			
			if (hasChanged) {
				$(this.el).addClass("hasChanged");
			}
			else {
				$(this.el).removeClass("hasChanged");
			}
		}
	});
	
	competitor.tableView = Backbone.View.extend({
		"template": templates.getTemplate("/weighing/template/competitors"),
		"initialize": function() {
			this.collection.on("reset", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var obj = this;
			
			var data = {};
			
			$(this.el).html(Mustache.render(this.template,data));
			
			this.collection.each(function(element) {
				var row = new competitor.rowView({
					"tagName": "tr",
					"model": element
				});
				$("tbody", obj.el).append(row.render().el);
			});
			
			return this;
		}
	});
	
})();

$(document).ready(function() {
    var search = definePackage("weighing.search");
    var competitor = definePackage("weighing.competitor");

	var searchModel = new search.model();
	var competitorCollection = new competitor.collection();
	
	var searchView = new search.view({
		"el": $("#searchDiv"),
		"model": searchModel
	});
	
	searchView.render();
	
	new competitor.tableView({
		"el": $("#competitorsDiv"),
		"collection": competitorCollection
	});
	
	searchModel.on("change", function() {
		competitorCollection.fetch(searchModel.toJSON());
	});
	
	searchModel.trigger("change");
});
