(function() {
    let view = definePackage("jtekma.view");
    let judge = definePackage("jtekma.judge");

    judge.Tatami = class Tatami extends view.main {

        constructor(tatamiId) {
            super("div");
            this.tatamiId = tatamiId;
            this.competitorNum = 1;

            let titleDiv = new view.div();
            this.addContent(titleDiv);
            this.addContent(new view.hr());

            let tatamiTitle = new view.h1("");
            tatamiTitle.addStyle("display", "inline-block");
            titleDiv.addContent(tatamiTitle);

            this.typeButtonGroup = new view.div();
            this.typeButtonGroup.setClass("btn-group");
            this.typeButtonGroup.addStyle("float", "right");
            this.typeButtonGroup.setAttribute("data-toggle", "buttons");

            let normalRefereeRadio = new view.input("radio");
            normalRefereeRadio.setName("normal-referee");
            let normalRefereeIcon = new view.i();
            normalRefereeIcon.setClass("glyphicon glyphicon-user");
            this.normalRefereeButton = new view.label();
            this.normalRefereeButton.setClass("tablet-button btn btn-default");
            this.normalRefereeButton.addContent(normalRefereeRadio);
            this.normalRefereeButton.addContent(normalRefereeIcon);
            this.normalRefereeButton.onClick(() => {
                this.showNormalRefereeView();
            });
            this.typeButtonGroup.addContent(this.normalRefereeButton);

            let videoRefereeRadio = new view.input("radio");
            videoRefereeRadio.setName("video-referee");
            let videoRefereeIcon = new view.i();
            videoRefereeIcon.setClass("glyphicon glyphicon-facetime-video");
            this.videoRefereeButton = new view.label();
            this.videoRefereeButton.setClass("tablet-button btn btn-default");
            this.videoRefereeButton.addContent(videoRefereeRadio);
            this.videoRefereeButton.addContent(videoRefereeIcon);
            this.videoRefereeButton.onClick(() => {
                this.showVideoRefereeView();
            });
            this.typeButtonGroup.addContent(this.videoRefereeButton);

            titleDiv.addContent(this.typeButtonGroup);

            restClient.get("/app/judge/tatamis/" + String(tatamiId), null, null, (responseData, response) => {
                if (!response.isSuccessful()) {
                    return;
                }
                tatamiTitle.setContent(responseData.name);
                this.draw();
            });

            let competitorDiv = new view.div();
            this.addContent(competitorDiv);

            this.nameLabel = new view.h2("");
            this.nameLabel.addStyle("display", "inline-block");
            competitorDiv.addContent(this.nameLabel);

            this.competitorNumButtonGroup = new view.div();
            this.competitorNumButtonGroup.setClass("btn-group");
            this.competitorNumButtonGroup.addStyle("float", "right");
            this.competitorNumButtonGroup.setAttribute("data-toggle", "buttons");

            let competitor1Radio = new view.input("radio");
            competitor1Radio.setName("competitor1");
            this.competitor1Button = new view.label();
            this.competitor1Button.setClass("tablet-button btn btn-default");
            this.competitor1Button.addContent(competitor1Radio);
            this.competitor1Button.addContent("1");
            this.competitor1Button.onClick(() => {
                this.showCompetitor(1);
            });
            this.competitorNumButtonGroup.addContent(this.competitor1Button);

            let competitor2Radio = new view.input("radio");
            competitor2Radio.setName("competitor1");
            this.competitor2Button = new view.label();
            this.competitor2Button.setClass("tablet-button btn btn-default");
            this.competitor2Button.addContent(competitor2Radio);
            this.competitor2Button.addContent("2");
            this.competitor2Button.onClick(() => {
                this.showCompetitor(2);
            });
            this.competitorNumButtonGroup.addContent(this.competitor2Button);

            competitorDiv.addContent(this.competitorNumButtonGroup);

            this.categoryLabel = new view.h2("");
            this.addContent(this.categoryLabel);

            this.noDataDiv = new view.div(new view.h3(getSpringMessage("app.judges.text.noData")));
            this.addContent(this.noDataDiv);

            this.normalPointsTable1 = new view.table();
            this.normalPointsTable1.setClass("table table-bordered");
            this.normalPointsTable1.addStyle("width", "100%");
            this.addContent(this.normalPointsTable1);

            this.normalPointsTable2 = new view.table();
            this.normalPointsTable2.setClass("table table-bordered");
            this.normalPointsTable2.addStyle("width", "100%");
            this.addContent(this.normalPointsTable2);

            this.videoPointsDiv1 = new view.div();
            this.addContent(this.videoPointsDiv1);

            this.videoPointsDiv2 = new view.div();
            this.addContent(this.videoPointsDiv2);

            this.videoPointsTable1 = new view.table();
            this.videoPointsTable1.setClass("table table-bordered");
            this.videoPointsTable1.addStyle("width", "100%");
            this.videoPointsDiv1.addContent(this.videoPointsTable1);

            this.videoPointsTable2 = new view.table();
            this.videoPointsTable2.setClass("table table-bordered");
            this.videoPointsTable2.addStyle("width", "100%");
            this.videoPointsDiv2.addContent(this.videoPointsTable2);

            let varietyDiv13 = new view.div();
            let varietyLabel13 = new view.label(getSpringMessage("app.judges.variety3") + ":");
            varietyLabel13.setClass("tablet-label");
            varietyLabel13.addStyle("width", "200px");
            varietyLabel13.addStyle("float", "left");
            varietyDiv13.addContent(varietyLabel13);
            this.varietyInput13 = new judge.PointInput(null, null, null, null, 0, 2);
            this.varietyInput13.addStyle("float", "left");
            varietyDiv13.addContent(this.varietyInput13);
            let clearDiv13 = new view.div();
            clearDiv13.addStyle("clear", "both");
            varietyDiv13.addContent(clearDiv13);
            this.videoPointsDiv1.addContent(varietyDiv13);

            let varietyDiv14 = new view.div();
            let varietyLabel14 = new view.label(getSpringMessage("app.judges.variety4") + ":");
            varietyLabel14.setClass("tablet-label");
            varietyLabel14.addStyle("width", "200px");
            varietyLabel14.addStyle("float", "left");
            varietyDiv14.addContent(varietyLabel14);
            this.varietyInput14 = new judge.PointInput(null, null, null, null, 0, 2);
            this.varietyInput14.addStyle("float", "left");
            varietyDiv14.addContent(this.varietyInput14);
            let clearDiv14 = new view.div();
            clearDiv14.addStyle("clear", "both");
            varietyDiv14.addContent(clearDiv14);
            this.videoPointsDiv1.addContent(varietyDiv14);

            let varietyDiv23 = new view.div();
            let varietyLabel23 = new view.label(getSpringMessage("app.judges.variety3") + ":");
            varietyLabel23.setClass("tablet-label");
            varietyLabel23.addStyle("width", "200px");
            varietyLabel23.addStyle("float", "left");
            varietyDiv23.addContent(varietyLabel23);
            this.varietyInput23 = new judge.PointInput(null, null, null, null, 0, 2);
            this.varietyInput23.addStyle("float", "left");
            varietyDiv23.addContent(this.varietyInput23);
            let clearDiv23 = new view.div();
            clearDiv23.addStyle("clear", "both");
            varietyDiv23.addContent(clearDiv23);
            this.videoPointsDiv2.addContent(varietyDiv23);

            let varietyDiv24 = new view.div();
            let varietyLabel24 = new view.label(getSpringMessage("app.judges.variety4") + ":");
            varietyLabel24.setClass("tablet-label");
            varietyLabel24.addStyle("width", "200px");
            varietyLabel24.addStyle("float", "left");
            varietyDiv24.addContent(varietyLabel24);
            this.varietyInput24 = new judge.PointInput(null, null, null, null, 0, 2);
            this.varietyInput24.addStyle("float", "left");
            varietyDiv24.addContent(this.varietyInput24);
            let clearDiv24 = new view.div();
            clearDiv24.addStyle("clear", "both");
            varietyDiv24.addContent(clearDiv24);
            this.videoPointsDiv2.addContent(varietyDiv24);

            let penaltyDiv1 = new view.div();
            let penaltyLabel1 = new view.label(getSpringMessage("app.judges.penalty") + ":");
            penaltyLabel1.setClass("tablet-label");
            penaltyLabel1.addStyle("width", "200px");
            penaltyLabel1.addStyle("float", "left");
            penaltyDiv1.addContent(penaltyLabel1);
            this.penaltyInput1 = new judge.PointInput(null, null, null, null, 0, 4);
            this.penaltyInput1.addStyle("float", "left");
            penaltyDiv1.addContent(this.penaltyInput1);
            let clearDiv1 = new view.div();
            clearDiv1.addStyle("clear", "both");
            penaltyDiv1.addContent(clearDiv1);
            this.videoPointsDiv1.addContent(penaltyDiv1);

            let penaltyDiv2 = new view.div();
            let penaltyLabel2 = new view.label(getSpringMessage("app.judges.penalty") + ":");
            penaltyLabel2.setClass("tablet-label");
            penaltyLabel2.addStyle("width", "200px");
            penaltyLabel2.addStyle("float", "left");
            penaltyDiv2.addContent(penaltyLabel2);
            this.penaltyInput2 = new judge.PointInput(null, null, null, null, 0, 4);
            this.penaltyInput2.addStyle("float", "left");
            penaltyDiv2.addContent(this.penaltyInput2);
            let clearDiv2 = new view.div();
            clearDiv2.addStyle("clear", "both");
            penaltyDiv2.addContent(clearDiv2);
            this.videoPointsDiv2.addContent(penaltyDiv2);

            let buttonsDiv = new view.div();
            buttonsDiv.addStyle("text-align", "center");
            buttonsDiv.addStyle("margin-top", "10px");
            this.addContent(buttonsDiv);

            this.buttonSave = new view.button(getSpringMessage("app.judges.save"));
            this.buttonSave.setClass("tablet-button btn btn-default");
            this.buttonSave.addStyle("margin-right", "20px");
            this.buttonSave.onClick(() => {
                this.savePoints();
            });
            this.buttonSave.setDisabled(true);
            buttonsDiv.addContent(this.buttonSave);

            this.buttonReload = new view.button(getSpringMessage("app.judges.reload"));
            this.buttonReload.setClass("tablet-button btn btn-default");
            this.buttonReload.onClick(() => {
                this.savedItemId = null;
                this.savedType = null;
                this.autoLoad = false;
                this.buttonReload.setDisabled(true);
                this.loadData();
            });
            buttonsDiv.addContent(this.buttonReload);

            this.clearData();
            this.loadData();
        }

        savePoints() {
            if (isNull(this.itemId) || isNull(this.type)) {
                return;
            }

            let duoPresentationPoints = {
                "id": this.itemId,
                "type": this.type
            };

            if (this.type == "PRESENTATION") {
                if ((this.refereeType == "normal") && isArray(judge.data.points1)) {
                    duoPresentationPoints.points1 = [];
                    for (let series in judge.data.points1) {
                        if (!isArray(judge.data.points1[series])) {
                            continue;
                        }
                        for (let attack in judge.data.points1[series]) {
                            if (!isArray(judge.data.points1[series][attack])) {
                                continue;
                            }
                            for (let part in judge.data.points1[series][attack]) {
                                if (isNull(judge.data.points1[series][attack][part])) {
                                    continue;
                                }
                                duoPresentationPoints.points1.push({
                                    "series": series,
                                    "attack": attack,
                                    "part": part,
                                    "point": judge.data.points1[series][attack][part]
                                });
                            }
                        }
                    }
                }
                if ((this.refereeType == "video") && isArray(judge.data.invalidAttacks1)) {
                    duoPresentationPoints.invalidAttacks1 = [];
                    for (let series in judge.data.invalidAttacks1) {
                        if (!isArray(judge.data.invalidAttacks1[series])) {
                            continue;
                        }
                        for (let attack in judge.data.invalidAttacks1[series]) {
                            if (isNull(judge.data.invalidAttacks1[series][attack])) {
                                continue;
                            }
                            if (!judge.data.invalidAttacks1[series][attack]) {
                                duoPresentationPoints.invalidAttacks1.push({
                                    "series": series,
                                    "attack": attack,
                                    "valid": false
                                });
                            }
                        }
                    }
                    duoPresentationPoints.variety1P3 = this.varietyInput13.point;
                    duoPresentationPoints.variety1P4 = this.varietyInput14.point;
                    duoPresentationPoints.penalty1 = this.penaltyInput1.point;
                }
            }
            else if (this.type == "MATCH") {
                if (this.refereeType == "normal") {
                    if (isArray(judge.data.points1)) {
                        duoPresentationPoints.points1 = [];
                        for (let series in judge.data.points1) {
                            if (!isArray(judge.data.points1[series])) {
                                continue;
                            }
                            for (let attack in judge.data.points1[series]) {
                                if (!isArray(judge.data.points1[series][attack])) {
                                    continue;
                                }
                                for (let part in judge.data.points1[series][attack]) {
                                    if (isNull(judge.data.points1[series][attack][part])) {
                                        continue;
                                    }
                                    duoPresentationPoints.points1.push({
                                        "series": series,
                                        "attack": attack,
                                        "part": part,
                                        "point": judge.data.points1[series][attack][part]
                                    });
                                }
                            }
                        }
                    }
                    if (isArray(judge.data.points2)) {
                        duoPresentationPoints.points2 = [];
                        for (let series in judge.data.points2) {
                            if (!isArray(judge.data.points2[series])) {
                                continue;
                            }
                            for (let attack in judge.data.points2[series]) {
                                if (!isArray(judge.data.points2[series][attack])) {
                                    continue;
                                }
                                for (let part in judge.data.points2[series][attack]) {
                                    if (isNull(judge.data.points2[series][attack][part])) {
                                        continue;
                                    }
                                    duoPresentationPoints.points2.push({
                                        "series": series,
                                        "attack": attack,
                                        "part": part,
                                        "point": judge.data.points2[series][attack][part]
                                    });
                                }
                            }
                        }
                    }
                }
                if (this.refereeType == "video") {
                    if (isArray(judge.data.invalidAttacks1)) {
                        duoPresentationPoints.invalidAttacks1 = [];
                        for (let series in judge.data.invalidAttacks1) {
                            if (!isArray(judge.data.invalidAttacks1[series])) {
                                continue;
                            }
                            for (let attack in judge.data.invalidAttacks1[series]) {
                                if (isNull(judge.data.invalidAttacks1[series][attack])) {
                                    continue;
                                }
                                if (!judge.data.invalidAttacks1[series][attack]) {
                                    duoPresentationPoints.invalidAttacks1.push({
                                        "series": series,
                                        "attack": attack,
                                        "valid": false
                                    });
                                }
                            }
                        }
                    }
                    if (isArray(judge.data.invalidAttacks2)) {
                        duoPresentationPoints.invalidAttacks2 = [];
                        for (let series in judge.data.invalidAttacks2) {
                            if (!isArray(judge.data.invalidAttacks2[series])) {
                                continue;
                            }
                            for (let attack in judge.data.invalidAttacks2[series]) {
                                if (isNull(judge.data.invalidAttacks2[series][attack])) {
                                    continue;
                                }
                                if (!judge.data.invalidAttacks2[series][attack]) {
                                    duoPresentationPoints.invalidAttacks2.push({
                                        "series": series,
                                        "attack": attack,
                                        "valid": false
                                    });
                                }
                            }
                        }
                    }
                    duoPresentationPoints.variety1P3 = this.varietyInput13.point;
                    duoPresentationPoints.variety1P4 = this.varietyInput14.point;
                    duoPresentationPoints.variety2P3 = this.varietyInput23.point;
                    duoPresentationPoints.variety2P4 = this.varietyInput24.point;
                    duoPresentationPoints.penalty1 = this.penaltyInput1.point;
                    duoPresentationPoints.penalty2 = this.penaltyInput2.point;
                }
            }

            this.buttonSave.setDisabled(true);

            restClient.postJson("/app/judge/duo-presentation/" + String(this.tatamiId), duoPresentationPoints, null, null, (responseData, response) => {
                this.buttonSave.setDisabled(false);
                if (!response.isSuccessful()) {
                    alert(getSpringMessage("app.judges.error.errorSendingPoints"));
                    return;
                }
                this.clearData();
                this.savedItemId = this.itemId;
                this.savedType = this.type;
                this.itemId = null;
                this.type = null;
                judge.data.points1 = [];
                judge.data.points2 = [];
                judge.data.invalidAttacks1 = [];
                judge.data.invalidAttacks2 = [];
                this.loadData();
            });
        }

        loadData() {
            restClient.get("/app/judge/duo-presentation/" + String(this.tatamiId), null, null, (responseData, response) => {
                this.buttonReload.setDisabled(false);

                if (!response.isSuccessful() || (this.savedItemId == responseData.id && this.savedType == responseData.type)) {
                    this.clearData();
                    this.buttonSave.setDisabled(true);
                    this.autoLoad = true;
                    setTimeout(() => {
                        if (this.autoLoad) {
                            this.loadData();
                        }
                    }, 3000);
                    return;
                }
                if (this.itemId != responseData.id || this.type != responseData.type) {
                    this.competitorNum = 1;
                }

                this.autoLoad = false;
                this.buttonSave.setDisabled(false);
                this.savedItemId = null;
                this.savedType = null;
                this.itemId = responseData.id;
                this.type = responseData.type;
                judge.data.points1 = [];
                judge.data.points2 = [];
                judge.data.invalidAttacks1 = [];
                judge.data.invalidAttacks2 = [];

                this.name1 = responseData.name1;
                this.name2 = responseData.name2;

                this.categoryLabel.setContent(responseData.category);

                if (isArray(responseData.attacks)) {
                    if (responseData.normalReferee) {
                        let headers1 = [];
                        let headers2 = [];
                        let rows1 = [];
                        let rows2 = [];
                        let maxParts = 0;

                        for (let attack of responseData.attacks) {
                            let attackCell1 = new view.td(attack.series + String(attack.attack));
                            attackCell1.setClass("judge-table-cell-label");

                            let attackCell2 = new view.td(attack.series + String(attack.attack));
                            attackCell2.setClass("judge-table-cell-label");

                            let row1 = [ attackCell1 ];
                            let row2 = [ attackCell2 ];

                            if (isArray(attack.parts)) {
                                for (let part of attack.parts) {
                                    let pointInput1 = new judge.PointInput(1, attack.series, attack.attack, part, 0, 3);
                                    let pointInput2 = new judge.PointInput(2, attack.series, attack.attack, part, 0, 3);

                                    let point1 = 0;
                                    if (isArray(responseData.points1)) {
                                        for (let p of responseData.points1) {
                                            if (p.series == attack.series && p.attack == attack.attack && p.part == part) {
                                                point1 = p.point;
                                                break;
                                            }
                                        }
                                    }

                                    let point2 = 0;
                                    if (isArray(responseData.points2)) {
                                        for (let p of responseData.points2) {
                                            if (p.series == attack.series && p.attack == attack.attack && p.part == part) {
                                                point2 = p.point;
                                                break;
                                            }
                                        }
                                    }

                                    if (point1 > 0) {
                                        pointInput1.setPoint(point1);
                                    }
                                    if (point2 > 0) {
                                        pointInput2.setPoint(point2);
                                    }

                                    let td1 = new view.td(pointInput1);
                                    let td2 = new view.td(pointInput2);

                                    row1.push(td1);
                                    row2.push(td2);

                                    maxParts = Math.max(maxParts, part);
                                }
                            }

                            rows1.push(row1);
                            rows2.push(row2);
                        }

                        headers1.push("");
                        headers2.push("");
                        for (let i = 1; i <= maxParts; i++) {
                            let th1 = new view.th(getSpringMessage("app.judges.part") + " " + String(i));
                            th1.setClass("judge-table-cell-label");
                            headers1.push(th1);

                            let th2 = new view.th(getSpringMessage("app.judges.part") + " " + String(i));
                            th2.setClass("judge-table-cell-label");
                            headers2.push(th2);
                        }

                        this.normalPointsTable1.setHeader(headers1);
                        this.normalPointsTable2.setHeader(headers2);
                        this.normalPointsTable1.setData(rows1);
                        this.normalPointsTable2.setData(rows2);
                    }
                    if (responseData.videoReferee) {
                        let rows1 = [];
                        let rows2 = [];

                        for (let attack of responseData.attacks) {
                            let attackCell1 = new view.td(attack.series + String(attack.attack));
                            attackCell1.setClass("judge-table-cell-label");
                            let attackCell2 = new view.td(attack.series + String(attack.attack));
                            attackCell2.setClass("judge-table-cell-label");

                            let stateSwitch1 = new judge.StateSwitch(1, attack.series, attack.attack, true);
                            let stateSwitch2 = new judge.StateSwitch(2, attack.series, attack.attack, true);

                            if (isArray(responseData.invalidAttacks1)) {
                                for (let a of responseData.invalidAttacks1) {
                                    if (a.series == attack.series && a.attack == attack.attack) {
                                        if (isNotNull(a.valid) && !a.valid) {
                                            stateSwitch1.setState(false);
                                            break;
                                        }
                                    }
                                }
                            }
                            if (isArray(responseData.invalidAttacks2)) {
                                for (let a of responseData.invalidAttacks2) {
                                    if (a.series == attack.series && a.attack == attack.attack) {
                                        if (isNotNull(a.valid) && !a.valid) {
                                            stateSwitch2.setState(false);
                                            break;
                                        }
                                    }
                                }
                            }

                            let row1 = [
                                attackCell1,
                                new view.td(stateSwitch1)
                            ];
                            let row2 = [
                                attackCell2,
                                new view.td(stateSwitch2)
                            ];

                            rows1.push(row1);
                            rows2.push(row2);
                        }

                        this.varietyInput13.setPoint(responseData.variety1P3);
                        this.varietyInput14.setPoint(responseData.variety1P4);
                        this.varietyInput23.setPoint(responseData.variety2P3);
                        this.varietyInput24.setPoint(responseData.variety2P4);
                        this.penaltyInput1.setPoint(responseData.penalty1);
                        this.penaltyInput2.setPoint(responseData.penalty2);

                        this.videoPointsTable1.setData(rows1);
                        this.videoPointsTable2.setData(rows2);
                    }
                }

                if (responseData.normalReferee && responseData.videoReferee) {
                    this.typeButtonGroup.show();
                    if (isTextEmpty(this.refereeType)) {
                        this.refereeType = "normal";
                    }
                }
                else {
                    this.typeButtonGroup.hide();
                    if (responseData.normalReferee) {
                        this.refereeType = "normal";
                    }
                    else if (responseData.videoReferee) {
                        this.refereeType = "video";
                    }
                    else {
                        this.refereeType = "";
                        this.normalPointsTable1.hide();
                        this.normalPointsTable2.hide();
                        this.videoPointsDiv1.hide();
                        this.videoPointsDiv2.hide();
                    }
                }

                if (this.type == "PRESENTATION") {
                    this.competitorNumButtonGroup.hide();
                    this.showCompetitor(1);
                }
                else {
                    this.competitorNumButtonGroup.show();
                    this.showCompetitor(this.competitorNum);
                }
            });
        }

        clearData() {
            this.nameLabel.setContent("");
            this.nameLabel.draw();
            this.categoryLabel.setContent("");
            this.categoryLabel.draw();
            this.normalPointsTable1.setHeader([]);
            this.normalPointsTable1.setData([]);
            this.normalPointsTable1.hide();
            this.normalPointsTable2.setHeader([]);
            this.normalPointsTable2.setData([]);
            this.normalPointsTable2.hide();
            this.videoPointsDiv1.hide();
            this.videoPointsDiv2.hide();
            this.noDataDiv.show();
            this.typeButtonGroup.hide();
            this.competitorNumButtonGroup.hide();
        }

        showNormalRefereeView() {
            this.refereeType = "normal";
            this.showCorrectView();
        }

        showVideoRefereeView() {
            this.refereeType = "video";
            this.showCorrectView();
        }

        showCompetitor(competitorNum) {
            this.competitorNum = competitorNum;
            this.showCorrectView();
        }

        showCorrectView() {
            this.noDataDiv.hide();

            if (this.competitorNum == 1) {
                this.nameLabel.setContent(this.name1);
                this.competitor1Button.addClass("active");
                this.competitor2Button.removeClass("active");
                if (this.refereeType == "normal") {
                    this.videoPointsDiv1.hide();
                    this.videoPointsDiv2.hide();
                    this.normalPointsTable2.hide();
                    this.normalPointsTable1.show();
                }
                else if (this.refereeType == "video") {
                    this.normalPointsTable1.hide();
                    this.normalPointsTable2.hide();
                    this.videoPointsDiv2.hide();
                    this.videoPointsDiv1.show();
                }
            }
            else if (this.competitorNum == 2) {
                this.nameLabel.setContent(this.name2);
                this.competitor2Button.addClass("active");
                this.competitor1Button.removeClass("active");
                if (this.refereeType == "normal") {
                    this.videoPointsDiv1.hide();
                    this.videoPointsDiv2.hide();
                    this.normalPointsTable1.hide();
                    this.normalPointsTable2.show();
                }
                else if (this.refereeType == "video") {
                    this.normalPointsTable1.hide();
                    this.normalPointsTable2.hide();
                    this.videoPointsDiv1.hide();
                    this.videoPointsDiv2.show();
                }
            }

            if (this.refereeType == "normal") {
                this.normalRefereeButton.addClass("active");
                this.videoRefereeButton.removeClass("active");
            }
            else if (this.refereeType == "video") {
                this.videoRefereeButton.addClass("active");
                this.normalRefereeButton.removeClass("active");
            }

            this.draw();
        }
    };

})();