(function() {
    let view = definePackage("jtekma.view");
    let judge = definePackage("jtekma.judge");
    let restClient = definePackage("restClient");

    judge.SelectTatami = class SelectTatami extends view.main {

        constructor() {
            super("div");
            this.addContent(new view.h1(getSpringMessage("app.judges.selectTatami")));

            restClient.get("/app/judge/tatamis", null, null, (responseData, response) => {
                if (!response.isSuccessful()) {
                    return;
                }
                if (responseData.length == 0) {
                    this.addContent(new view.p(getSpringMessage("app.judges.text.noTatamis")));
                }
                else {
                    for (let tatami of responseData) {
                        let tatamiDiv = new view.div(tatami.name);
                        tatamiDiv.addClass("well");
                        tatamiDiv.addClass("select-tatami");
                        tatamiDiv.onClick(() => {
                            router.changeLocation(["tatami", tatami.id]);
                        });
                        this.addContent(tatamiDiv);
                    }
                }
                this.draw();
            });
        }

    };

})();