(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");

    /*------------ Constants ------------*/
    var constants = definePackage("jtekma.constants");
    constants.fullIpponPoints = 50;
	constants.newazaFinishingMovePoints = 100;

    /*------------ Messages ------------*/
    var messages = definePackage("jtekma.gui.messages");
	messages.showInfoMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-info\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	messages.showSuccessMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-success\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	messages.showErrorMessage = (text) => {
		$("#message-area").html(Mustache.render(
		  "<div class=\"alert alert-danger\">{{text}}<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&#215;</button></div>",
		  {
		    "text": text
		  }
		));
	}

	/*-------- Display settings------*/
    models.DisplaySettings = Backbone.Model.extend({
        "defaults": {
            "category": null,
            "type": "",
            "tatami": null
        }
    });

    /*----- Competitors ---------*/
    models.CompetitorModel = Backbone.Model.extend({
        "defaults": {
            "id": 0,
            "name": "",
            "shortName": "",
            "clubId": 0,
            "clubName": "",
            "shortClubName": "",
            "type": "",
            "draw": 0,
            "drawGroup": 0
        }
    });

    models.CompetitorCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/competitor";
        },
        "model": models.CompetitorModel
    });

    /*-------- Event -------*/
    models.EventModel = Backbone.Model.extend({
        "url": function() {
          return contextPath + "/competition/data/event";
        },
        "defaults": {
            "id": null,
            "text": "",
            "autoRemove": false
        }
    });

    /*----- Category selector ---------*/
    models.CategoryModel = Backbone.Model.extend({
        "defaults": {
            "id": 0,
            "name": "",
            "type": "",
            "treeType": "",
            "show": true
        }
    });

    models.CategoryCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/category";
        },
        "model": models.CategoryModel
    });

})();