(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    models.FightPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/fight-points";
		},
		"defaults": {
		    "rules": "",
			"competitor1": "",
			"club1": "",
			"wazari1": 0,
			"ippon1_1": 0,
			"ippon1_2": 0,
			"ippon1_3": 0,
			"ippon1_1_3p": 0,
			"ippon1_2_3p": 0,
			"ippon1_3_3p": 0,
			"shido1": 0,
			"chui1": 0,
			"hansokumake1": 0,
			"competitor2": "",
			"club2": "",
			"wazari2": 0,
			"ippon2_1": 0,
			"ippon2_2": 0,
			"ippon2_3": 0,
			"ippon2_1_3p": 0,
            "ippon2_2_3p": 0,
            "ippon2_3_3p": 0,
			"shido2": 0,
			"chui2": 0,
			"hansokumake2": 0,
			"noWinner": false,
			"finished": false,
			"matchTime": null,
			"hosekomiTime": null,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
			"challengesWon2": 0,
			"challengesLost1": 0,
			"challengesLost2": 0
		}
	});

	models.DuoPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/duo-points";
		},
		"defaults": {
			"competitor1": "",
			"club1": "",
			"rounds1": null,
			"competitor2": "",
			"club2": "",
			"rounds2": null,
			"noWinner": false,
			"finished": false,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
            "challengesWon2": 0,
            "challengesLost1": 0,
            "challengesLost2": 0
		}
	});

	models.NewazaPoints = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/newaza-points";
		},
		"defaults": {
			"competitor1": "",
			"club1": "",
			"point1_2": 0,
			"point1_3": 0,
			"point1_4": 0,
			"point1_100": 0,
			"advantage1": 0,
			"penalty1": 0,
			"hansokumake1": 0,
			"competitor2": "",
			"club2": "",
			"point2_2": 0,
			"point2_3": 0,
			"point2_4": 0,
			"point2_100": 0,
			"advantage2": 0,
			"penalty2": 0,
			"hansokumake2": 0,
			"noWinner": false,
			"finished": false,
			"matchTime": null,
			"hosekomiTime": null,
			"injuryTime1": null,
			"injuryTime2": null,
			"challengesWon1": 0,
            "challengesWon2": 0,
            "challengesLost1": 0,
            "challengesLost2": 0
		}
	});

	models.Duo2023Points = Backbone.Model.extend({
    		"url": function() {
    		  return contextPath + "/competition/data/duo-2023-points";
    		},
    		"defaults": {
    			"competitor1": "",
    			"club1": "",
    			"competitor2": "",
                "club2": "",
                "attacks": null,
    			"points1": null,
    			"points2": null,
    			"penalty1": 0,
    			"penalty2": 0,
    			"noWinner": false,
    			"injuryTime1": null,
                "injuryTime2": null,
                "challengesWon1": 0,
                "challengesWon2": 0,
                "challengesLost1": 0,
                "challengesLost2": 0,
    			"finished": false
    		}
    	});

	models.MatchModel = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"number": 0,
			"name": "",
			"shortName": "",
			"competitor1": null,
			"competitor2": null,
			"points1": 0,
			"points2": 0,
			"status": "",
			"type": "",
			"categoryName": "",
			"categoryShortName": "",
			"canRemove": false
		},
		"parse": function(response, options) {
			response.isNotNeeded = response.status == "NOTNEEDED";
			response.isWaiting = response.status == "WAITING";
			response.isInQueue = response.status == "INQUEUE";
			response.isInProgress = response.status == "INPROGRESS";
			response.isFinished = response.status == "FINISHED";
			response.canAdd = response.isWaiting;
			return response;
		}
	});

	models.MatchCollection = Backbone.Collection.extend({
		"url": function() {
		  return contextPath + "/competition/data/match";
		},
		"model": models.MatchModel
	});

	views.MatchView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/match"),
		"className": "match",
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(Mustache.render(this.template, this.model.toJSON()));

			$("[rel='tooltip']", this.el).tooltip();

			var obj = this;

			$(".detailsButton", this.el).on("click",function() {
				var matchDetailsView = new views.MatchDetailsView({
					"model": obj.model
				});
				matchDetailsView.trigger("show");
			});

			$(".editButton", this.el).on("click",function() {
				var editFightModel = {
					"match": obj.model
				};
				if (obj.model.get("type") == "FIGHT") {
					editFightModel.points = new models.FightPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "DUO") {
					editFightModel.points = new models.DuoPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "NEWAZA") {
					editFightModel.points = new models.NewazaPoints();
					editFightModel.points.fetch({
						"data": {
							"matchId": obj.model.get("id")
						},
						"async": false
					});
				}
				else if (obj.model.get("type") == "DUO2023") {
                    editFightModel.points = new models.Duo2023Points();
                    editFightModel.points.fetch({
                        "data": {
                            "matchId": obj.model.get("id")
                        },
                        "async": false
                    });
                }

				var matchEditView = new views.MatchEditView({
					"model": editFightModel
				});
				matchEditView.trigger("show");
			});

			$(".addToTatamiButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/add-fight-to-tatami/" + String(jtekma.displaySettings.get("tatami").get("id")) + "/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			$(".removeButton", this.el).on("click", function() {
				$.ajax({
					url: contextPath + "/competition/data/remove-match/" + String(obj.model.get("id")),
					type: 'GET',
					success: function(responseData){
						jtekma.reloadData();
					}
				});
			});

			return this;
		}
	});

	views.MatchesView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/matches"),
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);

			$("[rel='tooltip']", this.el).tooltip();

			jtekma.displaySettings.get("category").fetch({
				"async": false
			});

			var category = this.collection.category;
			var treeCategoryOptions = category.get("treeCategoryOptions");

			if (treeCategoryOptions && (
			      treeCategoryOptions.treeType == "TABLE3"
			      || treeCategoryOptions.treeType == "TABLE4"
			      )
			    ) {
			    var matchesToShow = [];
                if (treeCategoryOptions.treeType == "TABLE3") {
                    matchesToShow.push(5);
                    matchesToShow.push(4);
                    matchesToShow.push(8);
                }
                else if (treeCategoryOptions.treeType == "TABLE4") {
                    matchesToShow.push(7);
                    matchesToShow.push(8);
                    matchesToShow.push(2);
                    matchesToShow.push(4);
                    matchesToShow.push(9);
                    matchesToShow.push(5);
                }
                for (var i in matchesToShow) {
                    var match = this.collection.where({"number": matchesToShow[i]})[0];
                    if (match.get("status") == "WAITING"
                            || match.get("status") == "INQUEUE"
                            || match.get("status") == "INPROGRESS"
                            || match.get("status") == "FINISHED") {

                        var matchView = new views.MatchView({
                            "model": match
                        });
                        $("#matches-div").append(matchView.render().el);
                    }
                }
			}
			else {
                for (var i = 1; i <= 124; i++) {
                    var match = this.collection.where({"number": i})[0];
                    if (match.get("status") == "WAITING"
                            || match.get("status") == "INQUEUE"
                            || match.get("status") == "INPROGRESS"
                            || match.get("status") == "FINISHED") {

                        var matchView = new views.MatchView({
                            "model": match
                        });
                        $("#matches-div").append(matchView.render().el);
                    }
                }
			}

			return this;
		}
	});

	views.CustomMatchesView = Backbone.View.extend({
		"template" : templates.getTemplate("/competition/template/custom-matches"),
		"initialize": function() {
			this.collection.on("reset",function() {
				this.render();
			}, this);
		},
		"render":function() {
			$(this.el).html(this.template);

			$(".addMatchButton", this.el).on("click", function() {
				var matchAddView = new views.MatchAddView();
				matchAddView.trigger("show");
			});

			$("[rel='tooltip']", this.el).tooltip();

			jtekma.displaySettings.get("category").fetch({
				"async": false
			});

			this.collection.each(function(match, index) {
				if (match.get("status") == "WAITING"
						|| match.get("status") == "INQUEUE"
						|| match.get("status") == "INPROGRESS"
						|| match.get("status") == "FINISHED") {

					var matchView = new views.MatchView({
						"model": match
					});
					$("#matches-div").append(matchView.render().el);
				}

			}, this);

			return this;
		}
	});

})();