(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.DuoTableModel = Backbone.Model.extend({
		"url": function() {
          return contextPath + "/competition/data/duo-table";
        },
        "defaults": {
            "rows": null
        }
	});

    views.DuoTablesView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/duo-tables"),
        "initialize": function() {
            this.model.duoTable.on("change", function() {
                this.renderDuoTable();
            }, this);
            this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
            this.render();
        },
        "render": function() {
            var category = jtekma.displaySettings.get("category");
        	var draw2023Options = category.get("draw2023Options");

            var data = {};
            $(this.el).html(Mustache.render(this.template, data));

            $("#qualification").hide();
            $("#knockout").hide();

            $("#roundButtons label", this.el).on("click", function() {
                $("#qualification").hide();
                $("#knockout").hide();
                jtekma.displaySettings.set("duo2023DisplayTab", $(this).attr("link"));
                $("#" + $(this).attr("link")).show();
            });

            var duo2023DisplayTab = jtekma.displaySettings.get("duo2023DisplayTab");
            if (!isTextEmpty(duo2023DisplayTab)) {
                var button = $("label[link='" + duo2023DisplayTab + "']");
                if (button.length > 0) {
                    button.click();
                }
                else {
                    $("#roundButtons label:first").click();
                }
            }
            else {
                $("#roundButtons label:first").click();
            }

            return this;
        },
        "renderDuoTable": function() {
            var element = $("#qualification .duo-table-div");
            element.html("");
            var duoTableView = new views.DuoTableView({
                "el": element,
                "model": this.model.duoTable
            });
            duoTableView.render();
        },
        "renderMatches": function() {
            var category = jtekma.displaySettings.get("category");
            var draw2023Options = category.get("draw2023Options");

            // world level
            var element = $("#knockoutWl");
            element.html("");

            element.attr("style", "width:770px;height:350px;");
            for (var i = 1; i <= 2; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 1) * 80 + 40) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 3; i <= 3; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:240px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 4; i <= 4; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:80px;"
                    }
                });
                element.append(matchView.render().el);
            }

            // advanced level
            element = $("#knockoutAdv");
            element.html("");

            element.attr("style", "width:770px;height:350px;");
            for (var i = 5; i <= 6; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 5) * 80 + 40) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 7; i <= 7; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:240px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 8; i <= 8; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:80px;"
                    }
                });
                element.append(matchView.render().el);
            }
        }
    });

	views.DuoTableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var duoTableData = this.model.toJSON();
			$(this.el).html(Mustache.render(this.template, duoTableData));
			return this;
		}
	});

})();