(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

	views.DuoPresentationEditView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/edit-duo-presentation"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

            $(this.el).html(Mustache.render(this.template, this.model.points.toJSON()));

            $("input.duoPresentationPointsInput", obj.el).val("0");

            for (var dpp of obj.model.points.get("points")) {
                $("input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
            }

            $("input[name='varietyP3']", obj.el).val(obj.model.points.get("varietyP3"));
            $("input[name='varietyP4']", obj.el).val(obj.model.points.get("varietyP4"));
            $("input[name='penalty']", obj.el).val(obj.model.points.get("penalty"));

            function calculateDuoPresentationPointsSum() {
                var sum = 0;

                var inputs = $("input.duoPresentationPointsInput");

                for (var i = 0; i < inputs.length; i++) {
                    var points = Number($(inputs[i]).val());
                    if (isValidNumber(points)) {
                        sum += points;
                    }
                }

                var variety3 = Number($("input[name='varietyP3']", obj.el).val());
                if (isValidNumber(variety3)) {
                    sum += variety3;
                }

                var variety4 = Number($("input[name='varietyP4']", obj.el).val());
                if (isValidNumber(variety4)) {
                    sum += variety4;
                }

                var penalty = Number($("input[name='penalty']", obj.el).val());
                if (isValidNumber(penalty)) {
                    sum -= penalty;
                }

                $("input.fightPointsSummaryInput", obj.el).val(String(sum));
            }

            $("input.duoPresentationPointsInput", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='varietyP3']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='varietyP4']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            $("input[name='penalty']", this.el).on("change",function() {
                calculateDuoPresentationPointsSum();
            });

            calculateDuoPresentationPointsSum();

			$(".btn-primary", this.el).on("click",function() {
			    var points = [];
			    var inputs = $("input.duoPresentationPointsInput");
                for (var i = 0; i < inputs.length; i++) {
                    var input = $(inputs[i]);
                    var p = Number(input.val());
                    if (isValidNumber(p)) {
                        points.push({
                            "judge": Number(input.attr("judge")),
                            "series": input.attr("series"),
                            "attack": Number(input.attr("attack")),
                            "part": Number(input.attr("part")),
                            "points": p
                        });
                    }
                }
                obj.model.points.set("points", points);

                var variety3 = Number($("input[name='varietyP3']", obj.el).val());
                if (isValidNumber(variety3)) {
                    obj.model.points.set("varietyP3", variety3);
                }
                else {
                    obj.model.points.set("varietyP3", 0);
                }

                var variety4 = Number($("input[name='varietyP4']", obj.el).val());
                if (isValidNumber(variety4)) {
                    obj.model.points.set("varietyP4", variety4);
                }
                else {
                    obj.model.points.set("varietyP4", 0);
                }

                var penalty = Number($("input[name='penalty']", obj.el).val());
                if (isValidNumber(penalty)) {
                    obj.model.points.set("penalty", penalty);
                }
                else {
                    obj.model.points.set("penalty", 0);
                }

				obj.model.points.set("finished", $("input[name='finished']", obj.el).is(":checked"));

				$.ajax({
					"async": false,
					"url": obj.model.points.url() + "?duoPresentationId=" + obj.model.duoPresentation.get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.points.toJSON())
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			return this;
		}
	});

})();