/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.competition.DuoPresentationAttackPoint;
import si.nevensrok.jtekma.server.web.common.competition.DuoPresentationPoints;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.MatchPointsUtil;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataDuoPresentationController
extends CoreController {
    @RequestMapping(value={"/duo-presentation"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.DuoPresentation> getDuoPresentationList(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.DuoPresentation> duoPresentations = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.DuoPresentation>();
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        List duoPresentationList = this.getManagersList().getDuoPresentationManager().getDuoPresentationsForCategory(category);
        duoPresentationList.removeIf(dp -> dp.getGroupNumber() == null);
        HashMap duoPresentatioPoints = new HashMap();
        for (Map.Entry entry : this.getManagersList().getDuoPresentationManager().getDuoPresentationsForDuoPresentations(new HashSet(duoPresentationList)).entrySet()) {
            duoPresentatioPoints.put(((DuoPresentation)entry.getKey()).getDuoPresentationId(), entry.getValue());
        }
        Collections.sort(duoPresentationList, new Comparator<DuoPresentation>(){

            @Override
            public int compare(DuoPresentation o1, DuoPresentation o2) {
                return new ObjectCompare().addValue(o1.getRound().ordinal(), o2.getRound().ordinal()).addValue((Comparable)o1.getGroupNumber(), (Object)o2.getGroupNumber()).addValue((Comparable)o1.getGroupPosition(), (Object)o2.getGroupPosition()).addValue((Comparable)o1.getDuoPresentationId(), (Object)o2.getDuoPresentationId()).calculateCompare();
            }
        });
        for (DuoPresentation duoPresentation : duoPresentationList) {
            duoPresentation.setCategory(category);
            si.nevensrok.jtekma.server.web.common.competition.DuoPresentation dp2 = new si.nevensrok.jtekma.server.web.common.competition.DuoPresentation(duoPresentation);
            dp2.setName(this.getTools().getMatchTool().generateDuoPresentationName(locale, duoPresentation));
            dp2.setShortName(this.getTools().getMatchTool().generateDuoPresentationShortName(locale, duoPresentation));
            dp2.setCanRemove(false);
            Set points = (Set)duoPresentatioPoints.get(duoPresentation.getDuoPresentationId());
            dp2.setPoints(Float.valueOf(competitionRules.sumDuoPresentationPoints(points)));
            duoPresentations.add(dp2);
        }
        return duoPresentations;
    }

    @RequestMapping(value={"/duo-presentation/{duoPresentationId}"}, method={RequestMethod.GET})
    @ResponseBody
    public si.nevensrok.jtekma.server.web.common.competition.DuoPresentation getDuoPresentationById(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            duoPresentation.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            si.nevensrok.jtekma.server.web.common.competition.DuoPresentation dp = new si.nevensrok.jtekma.server.web.common.competition.DuoPresentation(duoPresentation);
            dp.setName(this.getTools().getMatchTool().generateDuoPresentationName(locale, duoPresentation));
            dp.setShortName(this.getTools().getMatchTool().generateDuoPresentationShortName(locale, duoPresentation));
            dp.setCanRemove(false);
            Set points = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
            dp.setPoints(Float.valueOf(competitionRules.sumDuoPresentationPoints(points)));
            return dp;
        }
        return null;
    }

    @RequestMapping(value={"/duo-presentation-points"}, method={RequestMethod.GET})
    @ResponseBody
    public DuoPresentationPoints getDuoPresentationPoints(HttpServletResponse response, @RequestParam(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getByIdWithCompetitor(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            duoPresentation.setCategory(category);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            si.nevensrok.jtekma.server.web.common.competition.DuoPresentation dp = new si.nevensrok.jtekma.server.web.common.competition.DuoPresentation(duoPresentation);
            DuoPresentationPoints duoPresentationPoints = new DuoPresentationPoints();
            duoPresentationPoints.setFinished(duoPresentation.getStatus() == DuoPresentation.Status.FINISHED);
            duoPresentationPoints.setAttacks(new ArrayList<DuoPresentationAttack>(competitionRules.getDuoPresentationAttacks(ageCategoryOption, duoPresentation.getRound().ordinal() + 1)));
            duoPresentationPoints.setPoints(new LinkedList<DuoPresentationAttackPoint>());
            if (dp.getCompetitor() != null) {
                duoPresentationPoints.setCompetitor(dp.getCompetitor().getName());
                duoPresentationPoints.setClub(dp.getCompetitor().getClubName());
            }
            Set points = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
            for (DuoPresentationPoint duoPresentationPoint : points) {
                if (duoPresentationPoint.getType() == DuoPresentationPoint.Type.PENALTY) {
                    duoPresentationPoints.setPenalty(duoPresentationPoint.getPoints().intValue());
                    continue;
                }
                if (duoPresentationPoint.getType() == DuoPresentationPoint.Type.VARIETY_SCORE_POINTS) {
                    if (duoPresentationPoint.getPart() != null && duoPresentationPoint.getPart() == 3) {
                        duoPresentationPoints.setVarietyP3(duoPresentationPoint.getPoints().intValue());
                        continue;
                    }
                    if (duoPresentationPoint.getPart() == null || duoPresentationPoint.getPart() != 4) continue;
                    duoPresentationPoints.setVarietyP4(duoPresentationPoint.getPoints().intValue());
                    continue;
                }
                if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.POINTS) continue;
                duoPresentationPoints.getPoints().add(new DuoPresentationAttackPoint(duoPresentationPoint.getJudge(), duoPresentationPoint.getSeries(), duoPresentationPoint.getAttack(), duoPresentationPoint.getPart(), duoPresentationPoint.getPoints().intValue()));
            }
            return duoPresentationPoints;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/duo-presentation-points"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setDuoPresentationPoints(HttpServletResponse response, @RequestBody DuoPresentationPoints duoPresentationPoints, @RequestParam(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getByIdWithCompetitor(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            Set points = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, 3).setPoints(Float.valueOf(duoPresentationPoints.getVarietyP3().floatValue()));
            MatchPointsUtil.getOrCreateDuoPresentationVarietyPoint(points, 4).setPoints(Float.valueOf(duoPresentationPoints.getVarietyP4().floatValue()));
            MatchPointsUtil.getOrCreateDuoPresentationPenaltyPoint(points).setPoints(Float.valueOf(duoPresentationPoints.getPenalty().floatValue()));
            for (DuoPresentationAttack duoPresentationAttack : competitionRules.getDuoPresentationAttacks(ageCategoryOption, duoPresentation.getRound().ordinal() + 1)) {
                if (CollectionUtil.isEmpty(duoPresentationPoints.getPoints())) continue;
                for (int judge = 1; judge <= 3; ++judge) {
                    for (int part = 1; part <= 5; ++part) {
                        int j = judge;
                        int p = part;
                        DuoPresentationAttackPoint duoPresentationAttackPoint = duoPresentationPoints.getPoints().stream().filter(ap -> ap.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && ap.getAttack().equals(duoPresentationAttack.getAttack()) && ap.getJudge() == j && ap.getPart() == p).findFirst().orElse(null);
                        if (duoPresentationAttackPoint == null) continue;
                        MatchPointsUtil.getOrCreateDuoPresentationPoint(points, judge, Series.valueOf((String)duoPresentationAttack.getSeries().name()), duoPresentationAttackPoint.getAttack(), part).setPoints(Float.valueOf(duoPresentationAttackPoint.getPoints().floatValue()));
                    }
                }
            }
            boolean pointsEmpty = true;
            for (DuoPresentationPoint duoPresentationPoint : points) {
                if (!(duoPresentationPoint.getPoints().floatValue() > 0.0f)) continue;
                pointsEmpty = false;
                break;
            }
            if (pointsEmpty) {
                points.clear();
            }
            this.getManagersList().getDuoPresentationManager().setDuoPresentationPointsForDuoPresentation(duoPresentation, points);
            if (pointsEmpty) {
                this.getManagersList().getDuoPresentationManager().setDuoPresentationGradings(duoPresentation, new LinkedList());
                this.getManagersList().getDuoPresentationManager().setValidAttacksForDuoPresentation(duoPresentation, new HashSet());
            }
            if (duoPresentationPoints.getFinished() != null && duoPresentationPoints.getFinished().booleanValue()) {
                if (duoPresentation.getStatus() == DuoPresentation.Status.WAITING || duoPresentation.getStatus() == DuoPresentation.Status.INPROGRESS || duoPresentation.getStatus() == DuoPresentation.Status.INQUEUE || duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                    this.getManagersList().getDuoPresentationManager().setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.FINISHED);
                }
            } else if (duoPresentation.getStatus() == DuoPresentation.Status.WAITING || duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                this.getManagersList().getDuoPresentationManager().setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.WAITING);
            }
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }
}

