/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.app.judge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationGrading;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.DuoPresentationValidAttack;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchGrading;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.MatchValidAttack;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.server.web.common.exceptions.BadRequestException;
import si.nevensrok.jtekma.server.web.common.exceptions.ForbiddenException;
import si.nevensrok.jtekma.server.web.common.exceptions.NotFoundException;
import si.nevensrok.jtekma.server.web.common.exceptions.UnauthorizedException;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.DuoPresentationData;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.DuoPresentationPoints;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.InvalidAttack;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.Point;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.PointsType;
import si.nevensrok.jtekma.server.web.controllers.app.judge.model.Tatami;
import si.nevensrok.jtekma.server.web.tools.CompetitorNameUtil;

@Controller
@RequestMapping(value={"/app/judge"})
public class IndexController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexController.class);
    private Random random = new Random();

    @RequestMapping
    public String index() {
        return "app/judge/index";
    }

    @RequestMapping(value={"/tatamis"})
    @ResponseBody
    public List<Tatami> getTatamis(HttpServletResponse response) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Judge judge = this.getUserData().getLoginedJudge();
        if (judge == null) {
            throw new UnauthorizedException("Not authenticated as judge");
        }
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForJudge(this.getUserData().getLoginedJudge());
        if (competition == null) {
            throw new ForbiddenException("Active competition for judge not found");
        }
        LinkedList<Tatami> tatamis = new LinkedList<Tatami>();
        for (si.nevensrok.jtekma.common.tatami.Tatami t : this.getManagersList().getTatamiManager().getTatamisForJudge(judge)) {
            tatamis.add(new Tatami(t.getTatamiId(), t.getName()));
        }
        Collections.sort(tatamis, new Comparator<Tatami>(){

            @Override
            public int compare(Tatami o1, Tatami o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tatamis;
    }

    @RequestMapping(value={"/tatamis/{tatamiId}"})
    @ResponseBody
    public Tatami getTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Judge judge = this.getUserData().getLoginedJudge();
        if (judge == null) {
            throw new UnauthorizedException("Not authenticated as judge");
        }
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForJudge(this.getUserData().getLoginedJudge());
        if (competition == null) {
            throw new ForbiddenException("Active competition for judge not found");
        }
        for (si.nevensrok.jtekma.common.tatami.Tatami t : this.getManagersList().getTatamiManager().getTatamisForJudge(judge)) {
            if (!t.getTatamiId().equals(tatamiId)) continue;
            return new Tatami(t.getTatamiId(), t.getName());
        }
        throw new NotFoundException("Tatami not found");
    }

    @RequestMapping(value={"/duo-presentation/{tatamiId}"}, method={RequestMethod.GET})
    @ResponseBody
    public DuoPresentationData getDuoPresentationData(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Judge judge = this.getUserData().getLoginedJudge();
        if (judge == null) {
            throw new UnauthorizedException("Not authenticated as judge");
        }
        judge = this.getManagersList().getJudgeManager().getById(judge.getJudgeId());
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForJudge(this.getUserData().getLoginedJudge());
        if (competition == null) {
            throw new ForbiddenException("Active competition for judge not found");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        si.nevensrok.jtekma.common.tatami.Tatami tatami = null;
        for (si.nevensrok.jtekma.common.tatami.Tatami t : this.getManagersList().getTatamiManager().getTatamisForJudge(judge)) {
            if (!t.getTatamiId().equals(tatamiId)) continue;
            tatami = t;
            break;
        }
        if (tatami == null) {
            throw new NotFoundException("Tatami not found");
        }
        Match match = this.getManagersList().getTatamiFightsManager().getNextMatchForTatami(tatami, false);
        if (match != null) {
            MatchGrading matchGrading;
            if (match.getType() != Match.Type.DUO2023) {
                throw new NotFoundException("No duo presentation found");
            }
            match = this.getManagersList().getMatchManager().getByIdWithCompetitors(match.getMatchId());
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            Round round = Round.ROUND_4;
            String roundText = "";
            if (match.getFightNumber() == 3 || match.getFightNumber() == 4) {
                round = Round.ROUND_5;
                roundText = this.getLanguageText(locale, "competition.round4") + " - ";
            } else if (match.getFightNumber() == 7 || match.getFightNumber() == 8) {
                round = Round.ROUND_5;
                roundText = this.getLanguageText(locale, "competition.round5") + " - ";
            }
            DuoPresentationData duoPresentationData = new DuoPresentationData();
            duoPresentationData.setId(match.getId());
            duoPresentationData.setType(PointsType.MATCH);
            duoPresentationData.setName1(CompetitorNameUtil.getCompetitorFullName(match.getCompetitor1()));
            duoPresentationData.setName2(CompetitorNameUtil.getCompetitorFullName(match.getCompetitor2()));
            duoPresentationData.setCategory(roundText + category.getName());
            duoPresentationData.setNormalReferee((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE));
            duoPresentationData.setVideoReferee((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE));
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            ArrayList<DuoPresentationAttack> duoPresentationAttacks = new ArrayList<DuoPresentationAttack>(competitionRules.getDuoPresentationAttacks(ageCategoryOption, round.ordinal() + 1));
            duoPresentationData.setAttacks(duoPresentationAttacks);
            Set matchPoints = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE)).booleanValue() && (matchGrading = this.getManagersList().getMatchManager().getMatchGrading(match, judge)) != null) {
                LinkedList<Point> points1 = new LinkedList<Point>();
                Iterator<Point> points2 = new LinkedList();
                for (MatchPoint matchPoint : matchPoints) {
                    if (matchPoint.getPointType() != PointType.JUDGE || matchPoint.getJudge() == null || !matchPoint.getJudge().equals(matchGrading.getJudgeNum())) continue;
                    Point point = new Point();
                    point.setSeries(matchPoint.getSeries());
                    point.setAttack(matchPoint.getAttack());
                    point.setPart(matchPoint.getPart());
                    point.setPoint(matchPoint.getPoints().intValue());
                    if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                        points1.add(point);
                        continue;
                    }
                    if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                    points2.add(point);
                }
                duoPresentationData.setPoints1(points1);
                duoPresentationData.setPoints2((List<Point>)((Object)points2));
            }
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                LinkedList<InvalidAttack> invalidAttacks1 = new LinkedList<InvalidAttack>();
                LinkedList<InvalidAttack> invalidAttacks2 = new LinkedList<InvalidAttack>();
                for (MatchValidAttack matchValidAttack : this.getManagersList().getMatchManager().getValidAttacksForMatch(match)) {
                    InvalidAttack invalidAttack = new InvalidAttack();
                    invalidAttack.setSeries(matchValidAttack.getSeries());
                    invalidAttack.setAttack(matchValidAttack.getAttack());
                    invalidAttack.setValid(matchValidAttack.getAttackValid());
                    if (matchValidAttack.getCompetitor().equals(1)) {
                        invalidAttacks1.add(invalidAttack);
                        continue;
                    }
                    if (!matchValidAttack.getCompetitor().equals(2)) continue;
                    invalidAttacks2.add(invalidAttack);
                }
                duoPresentationData.setInvalidAttacks1(invalidAttacks1);
                duoPresentationData.setInvalidAttacks2(invalidAttacks2);
                duoPresentationData.setVariety1P3(0);
                duoPresentationData.setVariety1P4(0);
                duoPresentationData.setPenalty1(0);
                for (MatchPoint matchPoint : matchPoints) {
                    if (matchPoint.getPointType() == PointType.VARIETY_SCORE_POINTS) {
                        if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                            if (matchPoint.getPart() != null && matchPoint.getPart() == 3) {
                                duoPresentationData.setVariety1P3(matchPoint.getPoints().intValue());
                                continue;
                            }
                            if (matchPoint.getPart() == null || matchPoint.getPart() != 4) continue;
                            duoPresentationData.setVariety1P4(matchPoint.getPoints().intValue());
                            continue;
                        }
                        if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                        if (matchPoint.getPart() != null && matchPoint.getPart() == 3) {
                            duoPresentationData.setVariety2P3(matchPoint.getPoints().intValue());
                            continue;
                        }
                        if (matchPoint.getPart() == null || matchPoint.getPart() != 4) continue;
                        duoPresentationData.setVariety2P4(matchPoint.getPoints().intValue());
                        continue;
                    }
                    if (matchPoint.getPointType() != PointType.PENALTY) continue;
                    if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                        duoPresentationData.setPenalty1(matchPoint.getPoints().intValue());
                        continue;
                    }
                    if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                    duoPresentationData.setPenalty2(matchPoint.getPoints().intValue());
                }
            }
            return duoPresentationData;
        }
        DuoPresentation duoPresentation = this.getManagersList().getTatamiFightsManager().getNextDuoPresentationForTatami(tatami, false);
        if (duoPresentation != null) {
            DuoPresentationGrading duoPresentationGrading;
            duoPresentation = this.getManagersList().getDuoPresentationManager().getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            String roundText = "";
            if (duoPresentation.getRound() == Round.ROUND_1) {
                roundText = this.getLanguageText(locale, "competition.round1") + " - ";
            } else if (duoPresentation.getRound() == Round.ROUND_2) {
                roundText = this.getLanguageText(locale, "competition.round2") + " - ";
            } else if (duoPresentation.getRound() == Round.ROUND_3) {
                roundText = this.getLanguageText(locale, "competition.round3") + " - ";
            }
            DuoPresentationData duoPresentationData = new DuoPresentationData();
            duoPresentationData.setId(duoPresentation.getId());
            duoPresentationData.setType(PointsType.PRESENTATION);
            duoPresentationData.setName1(CompetitorNameUtil.getCompetitorFullName(duoPresentation.getCompetitor()));
            duoPresentationData.setCategory(roundText + category.getName());
            duoPresentationData.setNormalReferee((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE));
            duoPresentationData.setVideoReferee((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE));
            AgeCategoryOption ageCategoryOption = null;
            if (category instanceof Duo2023Category) {
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
            }
            ArrayList<DuoPresentationAttack> duoPresentationAttacks = new ArrayList<DuoPresentationAttack>(competitionRules.getDuoPresentationAttacks(ageCategoryOption, duoPresentation.getRound().ordinal() + 1));
            duoPresentationData.setAttacks(duoPresentationAttacks);
            Set duoPresentationPoints = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE)).booleanValue() && (duoPresentationGrading = this.getManagersList().getDuoPresentationManager().getDuoPresentationGrading(duoPresentation, judge)) != null) {
                LinkedList<Point> points = new LinkedList<Point>();
                for (DuoPresentationPoint duoPresentationPoint : duoPresentationPoints) {
                    if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.POINTS || duoPresentationPoint.getJudge() == null || !duoPresentationPoint.getJudge().equals(duoPresentationGrading.getJudgeNum())) continue;
                    Point point = new Point();
                    point.setSeries(duoPresentationPoint.getSeries());
                    point.setAttack(duoPresentationPoint.getAttack());
                    point.setPart(duoPresentationPoint.getPart());
                    point.setPoint(duoPresentationPoint.getPoints().intValue());
                    points.add(point);
                }
                duoPresentationData.setPoints1(points);
            }
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                LinkedList<InvalidAttack> invalidAttacks = new LinkedList<InvalidAttack>();
                for (DuoPresentationValidAttack duoPresentationValidAttack : this.getManagersList().getDuoPresentationManager().getValidAttacksForDuoPresentation(duoPresentation)) {
                    InvalidAttack invalidAttack = new InvalidAttack();
                    invalidAttack.setSeries(duoPresentationValidAttack.getSeries());
                    invalidAttack.setAttack(duoPresentationValidAttack.getAttack());
                    invalidAttack.setValid(duoPresentationValidAttack.getAttackValid());
                    invalidAttacks.add(invalidAttack);
                }
                duoPresentationData.setInvalidAttacks1(invalidAttacks);
                duoPresentationData.setVariety1P3(0);
                duoPresentationData.setVariety1P4(0);
                duoPresentationData.setPenalty1(0);
                for (DuoPresentationPoint duoPresentationPoint : duoPresentationPoints) {
                    if (duoPresentationPoint.getType() == DuoPresentationPoint.Type.VARIETY_SCORE_POINTS) {
                        if (duoPresentationPoint.getPart() != null && duoPresentationPoint.getPart() == 3) {
                            duoPresentationData.setVariety1P3(duoPresentationPoint.getPoints().intValue());
                            continue;
                        }
                        if (duoPresentationPoint.getPart() == null || duoPresentationPoint.getPart() != 4) continue;
                        duoPresentationData.setVariety1P4(duoPresentationPoint.getPoints().intValue());
                        continue;
                    }
                    if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.PENALTY) continue;
                    duoPresentationData.setPenalty1(duoPresentationPoint.getPoints().intValue());
                }
            }
            return duoPresentationData;
        }
        throw new NotFoundException("No duo presentation found");
    }

    @RequestMapping(value={"/duo-presentation/{tatamiId}"}, method={RequestMethod.POST})
    public void savePoints(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @RequestBody DuoPresentationPoints duoPresentationPoints) {
        Category category;
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Judge judge = this.getUserData().getLoginedJudge();
        if (judge == null) {
            throw new UnauthorizedException("Not authenticated as judge");
        }
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForJudge(this.getUserData().getLoginedJudge());
        if (competition == null) {
            throw new ForbiddenException("Active competition for judge not found");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        si.nevensrok.jtekma.common.tatami.Tatami tatami = null;
        for (si.nevensrok.jtekma.common.tatami.Tatami t : this.getManagersList().getTatamiManager().getTatamisForJudge(judge)) {
            if (!t.getTatamiId().equals(tatamiId)) continue;
            tatami = t;
            break;
        }
        if (tatami == null) {
            throw new NotFoundException("Tatami not found");
        }
        if (duoPresentationPoints.getType() == PointsType.PRESENTATION) {
            DuoPresentation duoPresentation = this.getManagersList().getTatamiFightsManager().getNextDuoPresentationForTatami(tatami, false);
            if (duoPresentation == null || !duoPresentation.getDuoPresentationId().equals(duoPresentationPoints.getId())) {
                throw new BadRequestException("Invalid duo presentation");
            }
            if (duoPresentation.getStatus() != DuoPresentation.Status.INPROGRESS) {
                LOGGER.debug("Duo presentation is in invalid status: {}", (Object)duoPresentation.getStatus());
                throw new BadRequestException("Duo presentation is not in progress");
            }
            if (duoPresentationPoints.getPoints1() != null && ((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                DuoPresentationGrading duoPresentationGrading = null;
                for (int i = 0; i < 10; ++i) {
                    try {
                        duoPresentationGrading = this.getManagersList().getDuoPresentationManager().getOrCreateDuoPresentationGrading(duoPresentation, judge);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error creating grading", (Throwable)e);
                        try {
                            Thread.sleep(3 + this.random.nextInt(10));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (duoPresentationGrading == null) {
                    throw new RuntimeException("Error creating duo presentation grading");
                }
                LinkedHashSet<Object> points = new LinkedHashSet<Object>();
                for (Point point : duoPresentationPoints.getPoints1()) {
                    DuoPresentationPoint duoPresentationPoint = new DuoPresentationPoint();
                    duoPresentationPoint.setDuoPresentation(duoPresentation);
                    duoPresentationPoint.setType(DuoPresentationPoint.Type.POINTS);
                    duoPresentationPoint.setPoints(Float.valueOf(point.getPoint().floatValue()));
                    duoPresentationPoint.setJudge(duoPresentationGrading.getJudgeNum());
                    duoPresentationPoint.setSeries(point.getSeries());
                    duoPresentationPoint.setAttack(point.getAttack());
                    duoPresentationPoint.setPart(point.getPart());
                    points.add(duoPresentationPoint);
                }
                this.getManagersList().getDuoPresentationManager().setDuoPresentationPointsForDuoPresentation(duoPresentation, duoPresentationGrading.getJudgeNum().intValue(), points);
            }
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue() && duoPresentationPoints.getVariety1P3() != null && duoPresentationPoints.getVariety1P4() != null && duoPresentationPoints.getPenalty1() != null && duoPresentationPoints.getInvalidAttacks1() != null) {
                category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
                AgeCategoryOption ageCategoryOption = null;
                if (category instanceof Duo2023Category) {
                    ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
                }
                LinkedHashSet<DuoPresentationValidAttack> validAttacks = new LinkedHashSet<DuoPresentationValidAttack>();
                ArrayList duoPresentationAttacks = new ArrayList(competitionRules.getDuoPresentationAttacks(ageCategoryOption, duoPresentation.getRound().ordinal() + 1));
                for (DuoPresentationAttack duoPresentationAttack : duoPresentationAttacks) {
                    boolean attackValid = true;
                    InvalidAttack invalidAttack = duoPresentationPoints.getInvalidAttacks1().stream().filter(a -> duoPresentationAttack.getSeries().name().equals(a.getSeries().name()) && duoPresentationAttack.getAttack().equals(a.getAttack())).findFirst().orElse(null);
                    if (invalidAttack != null) {
                        attackValid = (Boolean)ObjectUtil.ifNull((Object)invalidAttack.getValid(), (Object)Boolean.TRUE);
                    }
                    DuoPresentationValidAttack duoPresentationValidAttack = new DuoPresentationValidAttack();
                    duoPresentationValidAttack.setDuoPresentation(duoPresentation);
                    duoPresentationValidAttack.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    duoPresentationValidAttack.setAttack(duoPresentationAttack.getAttack());
                    duoPresentationValidAttack.setAttackValid(Boolean.valueOf(attackValid));
                    validAttacks.add(duoPresentationValidAttack);
                }
                this.getManagersList().getDuoPresentationManager().setValidAttacksForDuoPresentation(duoPresentation, validAttacks);
                LinkedHashSet<DuoPresentationPoint> points = new LinkedHashSet<DuoPresentationPoint>();
                DuoPresentationPoint varietyPoint3 = new DuoPresentationPoint();
                varietyPoint3.setDuoPresentation(duoPresentation);
                varietyPoint3.setType(DuoPresentationPoint.Type.VARIETY_SCORE_POINTS);
                varietyPoint3.setPart(Integer.valueOf(3));
                varietyPoint3.setPoints(Float.valueOf(duoPresentationPoints.getVariety1P3().floatValue()));
                points.add(varietyPoint3);
                DuoPresentationPoint varietyPoint4 = new DuoPresentationPoint();
                varietyPoint4.setDuoPresentation(duoPresentation);
                varietyPoint4.setType(DuoPresentationPoint.Type.VARIETY_SCORE_POINTS);
                varietyPoint4.setPart(Integer.valueOf(4));
                varietyPoint4.setPoints(Float.valueOf(duoPresentationPoints.getVariety1P4().floatValue()));
                points.add(varietyPoint4);
                DuoPresentationPoint penaltyPoint = new DuoPresentationPoint();
                penaltyPoint.setDuoPresentation(duoPresentation);
                penaltyPoint.setType(DuoPresentationPoint.Type.PENALTY);
                penaltyPoint.setPoints(Float.valueOf(duoPresentationPoints.getPenalty1().floatValue()));
                points.add(penaltyPoint);
                this.getManagersList().getDuoPresentationManager().setVRDuoPresentationPointsForDuoPresentation(duoPresentation, points);
            }
        } else if (duoPresentationPoints.getType() == PointsType.MATCH) {
            Match match = this.getManagersList().getTatamiFightsManager().getNextMatchForTatami(tatami, false);
            if (match == null || !match.getMatchId().equals(duoPresentationPoints.getId())) {
                throw new BadRequestException("Invalid duo presentation");
            }
            if (match.getStatus() != Match.Status.INPROGRESS) {
                LOGGER.debug("Match is in invalid status: {}", (Object)match.getStatus());
                throw new BadRequestException("Match is not in progress");
            }
            if (duoPresentationPoints.getPoints1() != null && ((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE)).booleanValue()) {
                MatchPoint matchPoint;
                MatchGrading matchGrading = null;
                for (int i = 0; i < 10; ++i) {
                    try {
                        matchGrading = this.getManagersList().getMatchManager().getOrCreateMatchGrading(match, judge);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error creating grading", (Throwable)e);
                        try {
                            Thread.sleep(3 + this.random.nextInt(10));
                        }
                        catch (InterruptedException duoPresentationAttacks) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (matchGrading == null) {
                    throw new RuntimeException("Error creating match grading");
                }
                LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
                for (Point point : duoPresentationPoints.getPoints1()) {
                    matchPoint = new MatchPoint();
                    matchPoint.setMatch(match);
                    matchPoint.setCompetitor(CompetitorType.COMPETITOR1);
                    matchPoint.setPointType(PointType.JUDGE);
                    matchPoint.setPoints(Float.valueOf(point.getPoint().floatValue()));
                    matchPoint.setJudge(matchGrading.getJudgeNum());
                    matchPoint.setSeries(point.getSeries());
                    matchPoint.setAttack(point.getAttack());
                    matchPoint.setPart(point.getPart());
                    points.add(matchPoint);
                }
                for (Point point : duoPresentationPoints.getPoints2()) {
                    matchPoint = new MatchPoint();
                    matchPoint.setMatch(match);
                    matchPoint.setCompetitor(CompetitorType.COMPETITOR2);
                    matchPoint.setPointType(PointType.JUDGE);
                    matchPoint.setPoints(Float.valueOf(point.getPoint().floatValue()));
                    matchPoint.setJudge(matchGrading.getJudgeNum());
                    matchPoint.setSeries(point.getSeries());
                    matchPoint.setAttack(point.getAttack());
                    matchPoint.setPart(point.getPart());
                    points.add(matchPoint);
                }
                this.getManagersList().getMatchManager().setMatchPointsForMatch(match, matchGrading.getJudgeNum().intValue(), points);
            }
            if (((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue() && duoPresentationPoints.getVariety1P3() != null && duoPresentationPoints.getVariety1P4() != null && duoPresentationPoints.getPenalty1() != null && duoPresentationPoints.getInvalidAttacks1() != null) {
                category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                AgeCategoryOption ageCategoryOption = null;
                if (category instanceof Duo2023Category) {
                    ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory((Duo2023Category)category);
                }
                Round round = Round.ROUND_4;
                if (match.getFightNumber() == 3 || match.getFightNumber() == 4) {
                    round = Round.ROUND_5;
                } else if (match.getFightNumber() == 7 || match.getFightNumber() == 8) {
                    round = Round.ROUND_5;
                }
                LinkedHashSet<MatchValidAttack> validAttacks = new LinkedHashSet<MatchValidAttack>();
                ArrayList duoPresentationAttacks = new ArrayList(competitionRules.getDuoPresentationAttacks(ageCategoryOption, round.ordinal() + 1));
                for (DuoPresentationAttack duoPresentationAttack : duoPresentationAttacks) {
                    boolean attackValid1 = true;
                    boolean attackValid2 = true;
                    InvalidAttack invalidAttack1 = duoPresentationPoints.getInvalidAttacks1().stream().filter(a -> duoPresentationAttack.getSeries().name().equals(a.getSeries().name()) && duoPresentationAttack.getAttack().equals(a.getAttack())).findFirst().orElse(null);
                    InvalidAttack invalidAttack2 = duoPresentationPoints.getInvalidAttacks2().stream().filter(a -> duoPresentationAttack.getSeries().name().equals(a.getSeries().name()) && duoPresentationAttack.getAttack().equals(a.getAttack())).findFirst().orElse(null);
                    if (invalidAttack1 != null) {
                        attackValid1 = (Boolean)ObjectUtil.ifNull((Object)invalidAttack1.getValid(), (Object)Boolean.TRUE);
                    }
                    if (invalidAttack2 != null) {
                        attackValid2 = (Boolean)ObjectUtil.ifNull((Object)invalidAttack2.getValid(), (Object)Boolean.TRUE);
                    }
                    MatchValidAttack matchValidAttack1 = new MatchValidAttack();
                    matchValidAttack1.setMatch(match);
                    matchValidAttack1.setCompetitor(Integer.valueOf(1));
                    matchValidAttack1.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    matchValidAttack1.setAttack(duoPresentationAttack.getAttack());
                    matchValidAttack1.setAttackValid(Boolean.valueOf(attackValid1));
                    validAttacks.add(matchValidAttack1);
                    MatchValidAttack matchValidAttack2 = new MatchValidAttack();
                    matchValidAttack2.setMatch(match);
                    matchValidAttack2.setCompetitor(Integer.valueOf(2));
                    matchValidAttack2.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    matchValidAttack2.setAttack(duoPresentationAttack.getAttack());
                    matchValidAttack2.setAttackValid(Boolean.valueOf(attackValid2));
                    validAttacks.add(matchValidAttack2);
                }
                this.getManagersList().getMatchManager().setValidAttacksForMatch(match, validAttacks);
                LinkedHashSet<MatchPoint> points = new LinkedHashSet<MatchPoint>();
                MatchPoint varietyPoint13 = new MatchPoint();
                varietyPoint13.setMatch(match);
                varietyPoint13.setCompetitor(CompetitorType.COMPETITOR1);
                varietyPoint13.setPointType(PointType.VARIETY_SCORE_POINTS);
                varietyPoint13.setPart(Integer.valueOf(3));
                varietyPoint13.setPoints(Float.valueOf(duoPresentationPoints.getVariety1P3().floatValue()));
                points.add(varietyPoint13);
                MatchPoint varietyPoint14 = new MatchPoint();
                varietyPoint14.setMatch(match);
                varietyPoint14.setCompetitor(CompetitorType.COMPETITOR1);
                varietyPoint14.setPointType(PointType.VARIETY_SCORE_POINTS);
                varietyPoint14.setPart(Integer.valueOf(4));
                varietyPoint14.setPoints(Float.valueOf(duoPresentationPoints.getVariety1P4().floatValue()));
                points.add(varietyPoint14);
                MatchPoint varietyPoint23 = new MatchPoint();
                varietyPoint23.setMatch(match);
                varietyPoint23.setCompetitor(CompetitorType.COMPETITOR2);
                varietyPoint23.setPointType(PointType.VARIETY_SCORE_POINTS);
                varietyPoint23.setPart(Integer.valueOf(3));
                varietyPoint23.setPoints(Float.valueOf(duoPresentationPoints.getVariety2P3().floatValue()));
                points.add(varietyPoint23);
                MatchPoint varietyPoint24 = new MatchPoint();
                varietyPoint24.setMatch(match);
                varietyPoint24.setCompetitor(CompetitorType.COMPETITOR2);
                varietyPoint24.setPointType(PointType.VARIETY_SCORE_POINTS);
                varietyPoint24.setPart(Integer.valueOf(4));
                varietyPoint24.setPoints(Float.valueOf(duoPresentationPoints.getVariety2P4().floatValue()));
                points.add(varietyPoint24);
                MatchPoint penaltyPoint1 = new MatchPoint();
                penaltyPoint1.setMatch(match);
                penaltyPoint1.setCompetitor(CompetitorType.COMPETITOR1);
                penaltyPoint1.setPointType(PointType.PENALTY);
                penaltyPoint1.setPoints(Float.valueOf(duoPresentationPoints.getPenalty1().floatValue()));
                points.add(penaltyPoint1);
                MatchPoint penaltyPoint2 = new MatchPoint();
                penaltyPoint2.setMatch(match);
                penaltyPoint2.setCompetitor(CompetitorType.COMPETITOR2);
                penaltyPoint2.setPointType(PointType.PENALTY);
                penaltyPoint2.setPoints(Float.valueOf(duoPresentationPoints.getPenalty2().floatValue()));
                points.add(penaltyPoint2);
                this.getManagersList().getMatchManager().setVRMatchPointsForMatch(match, points);
            }
        } else {
            throw new BadRequestException("Unknown type");
        }
    }
}

