/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchValidAttack;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchValidAttackDTO;

public class MatchValidAttackDAO
extends CoreDao {
    protected DatabaseAdapterPool adapterPool;

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    public DatabaseAdapterPool getAdapterPool() {
        return this.adapterPool;
    }

    public void setValidAttacksForMatch(Match match, Set<MatchValidAttack> validAttacks) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from MatchValidAttackDTO where matchValidAttackKey.match.matchId = ");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        MatchDTO matchDTO = new MatchDTO();
        matchDTO.setMatchId(match.getMatchId());
        for (MatchValidAttack matchValidAttack : validAttacks) {
            MatchValidAttackDTO matchValidAttackDTO = new MatchValidAttackDTO(matchDTO, matchValidAttack.getCompetitor(), matchValidAttack.getSeries(), matchValidAttack.getAttack());
            matchValidAttackDTO.setAttackValid(matchValidAttack.getAttackValid());
            matchValidAttackDTO.setSentAt((Calendar)ObjectUtil.ifNull((Object)matchValidAttack.getSentAt(), (Object)Calendar.getInstance()));
            this.getCurrentSession().save((Object)matchValidAttackDTO);
        }
        this.flush();
    }

    public Set<MatchValidAttack> getValidAttacksForMatch(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select mva from MatchValidAttackDTO as mva where mva.matchValidAttackKey.match.matchId = ");
        sql.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedHashSet<MatchValidAttack> matchValidAttacks = new LinkedHashSet<MatchValidAttack>();
        for (MatchValidAttackDTO matchValidAttackDTO : list) {
            MatchValidAttack matchValidAttack = new MatchValidAttack();
            matchValidAttack.setMatch(match);
            matchValidAttack.setCompetitor(matchValidAttackDTO.getMatchValidAttackKey().getCompetitor());
            matchValidAttack.setSeries(matchValidAttackDTO.getMatchValidAttackKey().getSeries());
            matchValidAttack.setAttack(matchValidAttackDTO.getMatchValidAttackKey().getAttack());
            matchValidAttack.setAttackValid(matchValidAttackDTO.getAttackValid());
            matchValidAttack.setSentAt(matchValidAttackDTO.getSentAt());
            matchValidAttacks.add(matchValidAttack);
        }
        this.flush();
        return matchValidAttacks;
    }
}

