/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeDTO;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeOnTatamiDTO;
import si.nevensrok.jtekma.server.dl.dto.tatami.TatamiDTO;

public class JudgeDAO
extends ExtendedDao<Long, JudgeDTO, Judge> {
    public JudgeDAO() {
        super(JudgeDTO.class, Judge.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("judgeId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("password")) {
            return "password";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        if (fieldName.equalsIgnoreCase("normalReferee")) {
            return "normalReferee";
        }
        if (fieldName.equalsIgnoreCase("videoReferee")) {
            return "videoReferee";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void updateJudgePassword(Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update JudgeDTO set password = ");
        sql.append(paramsBinder.addParam(judge.getPassword()));
        sql.append(" where id=");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Judge getActiveJudgeByName(Competition competition, String name) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select judge from JudgeDTO as judge where judge.competition.competitionId = ");
        sql.append(paramsBinder.addParam(competition.getCompetitionId()));
        sql.append(" and UPPER(judge.name) = UPPER(");
        sql.append(paramsBinder.addParam(name));
        sql.append(")");
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.setMaxResults(1);
        JudgeDTO judgeDTO = (JudgeDTO)JudgeDAO.getSingleResult((Query)query);
        Judge judge = null;
        if (judgeDTO != null) {
            judge = (Judge)this.getAdapterPool().create(Judge.class, (Object)judgeDTO);
        }
        this.flush();
        return judge;
    }

    public void setTatamisForJudge(Judge judge, Set<Tatami> tatamis) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from JudgeOnTatamiDTO where judgeOnTatamiKey.judge.id = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        JudgeDTO judgeDTO = new JudgeDTO();
        judgeDTO.setJudgeId(judge.getJudgeId());
        for (Tatami tatami : tatamis) {
            TatamiDTO tatamiDTO = new TatamiDTO();
            tatamiDTO.setTatamiId(tatami.getTatamiId());
            JudgeOnTatamiDTO judgeOnTatamiDTO = new JudgeOnTatamiDTO(judgeDTO, tatamiDTO);
            this.getCurrentSession().save((Object)judgeOnTatamiDTO);
        }
        this.flush();
    }

    public Set<Tatami> getTatamisForJudge(Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select judgeOnTatami.judgeOnTatamiKey.tatami from JudgeOnTatamiDTO as judgeOnTatami where judgeOnTatami.judgeOnTatamiKey.judge.id = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        List list = query.getResultList();
        HashSet<Tatami> tatamis = new HashSet<Tatami>();
        for (Object item : list) {
            Tatami tatami = (Tatami)this.getAdapterPool().create(Tatami.class, item);
            tatamis.add(tatami);
        }
        this.flush();
        return tatamis;
    }

    public boolean isJudgeOnTatami(Judge judge, Tatami tatami) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from JudgeOnTatamiDTO as judgeOnTatami where judgeOnTatami.judgeOnTatamiKey.judge.id = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        sql.append(" and judgeOnTatami.judgeOnTatamiKey.tatami.id = ");
        sql.append(paramsBinder.addParam(tatami.getTatamiId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        Long count = (Long)JudgeDAO.getSingleResult((Query)query);
        this.flush();
        return count > 0L;
    }
}

