/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.updaters.Duo2023Updater;

public class Duo2023PlacingCalculator {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;
    private Duo2023Updater duo2023Updater;
    private MatchManager matchManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setDuo2023Updater(Duo2023Updater duo2023Updater) {
        this.duo2023Updater = duo2023Updater;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public Map<Competitor, Integer> getPlacings(Duo2023Category duo2023Category, Rank rank) {
        DuoTable duoTable = this.duo2023Updater.getDuoTable(duo2023Category);
        return this.calculatePlacings(duo2023Category, duoTable, rank);
    }

    public Map<Competitor, Integer> calculatePlacings(Duo2023Category duo2023Category, DuoTable duoTable, Rank rank) {
        Competitor loser;
        Competitor winner;
        Match match;
        LinkedHashMap<Competitor, Integer> placings = new LinkedHashMap<Competitor, Integer>();
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)duo2023Category);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap matchPoints = new HashMap();
        for (Match match2 : this.matchManager.getMatchesForCategory((Category)duo2023Category)) {
            matches.put(match2.getFightNumber(), match2);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
        }
        int matchOffset = 0;
        if (rank == Rank.ADVANCED) {
            matchOffset = 4;
        }
        if ((match = (Match)matches.get(matchOffset + 4)) != null && !match.getMatchEmpty().booleanValue() && !match.getNoWinner().booleanValue()) {
            if (match.getNotNeeded().booleanValue()) {
                if (match.getCompetitor1() != null) {
                    placings.put(match.getCompetitor1(), 1);
                } else if (match.getCompetitor2() != null) {
                    placings.put(match.getCompetitor2(), 1);
                }
            } else if (match.getStatus() == Match.Status.FINISHED) {
                winner = competitionRules.getMatchWinner(match, (Set)matchPoints.get(match.getFightNumber()));
                if (winner != null) {
                    placings.put(winner, 1);
                }
                if ((loser = competitionRules.getMatchLoser(match, (Set)matchPoints.get(match.getFightNumber()))) != null) {
                    placings.put(loser, 2);
                }
            }
        }
        if (duo2023Category.getDouble3rdPlace().booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                Match match3 = (Match)matches.get(matchOffset + 1 + i);
                if (match3 == null || match3.getMatchEmpty().booleanValue() || match3.getNotNeeded().booleanValue()) continue;
                if (match3.getNoWinner().booleanValue()) {
                    if (match3.getCompetitor1() != null) {
                        placings.put(match3.getCompetitor1(), 3);
                        continue;
                    }
                    if (match3.getCompetitor2() == null) continue;
                    placings.put(match3.getCompetitor2(), 3);
                    continue;
                }
                if (match3.getStatus() != Match.Status.FINISHED || (loser = competitionRules.getMatchLoser(match3, (Set)matchPoints.get(match3.getFightNumber()))) == null) continue;
                placings.put(loser, 3);
            }
        } else {
            Match match4 = (Match)matches.get(matchOffset + 3);
            if (match4 != null && !match4.getMatchEmpty().booleanValue() && !match4.getNoWinner().booleanValue()) {
                if (match4.getNotNeeded().booleanValue()) {
                    if (match4.getCompetitor1() != null) {
                        placings.put(match4.getCompetitor1(), 3);
                    } else if (match4.getCompetitor2() != null) {
                        placings.put(match4.getCompetitor2(), 3);
                    }
                } else if (match4.getStatus() == Match.Status.FINISHED) {
                    winner = competitionRules.getMatchWinner(match4, (Set)matchPoints.get(match4.getFightNumber()));
                    if (winner != null) {
                        placings.put(winner, 3);
                    }
                    if ((loser = competitionRules.getMatchLoser(match4, (Set)matchPoints.get(match4.getFightNumber()))) != null) {
                        placings.put(loser, 4);
                    }
                }
            }
        }
        if (duoTable.isFinished() && duoTable.getRows() != null && rank == Rank.ADVANCED) {
            for (DuoTable.Row row : duoTable.getRows()) {
                if (row.getPlacing() <= 8) continue;
                placings.put(row.getCompetitor(), row.getPlacing() - 4);
            }
        }
        return placings;
    }
}

