/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.dataimport.JudgeWithTatamis;
import si.nevensrok.jtekma.server.management.JudgeManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class JudgeImporter {
    private static final int BUFFER_SIZE = 65536;
    private JudgeManager judgeManager;
    private TatamiManager tatamiManager;

    public void setJudgeManager(JudgeManager judgeManager) {
        this.judgeManager = judgeManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public List<JudgeWithTatamis> parseJudges(FileType fileType, byte[] fileData, Competition competition, Map<String, DataImportException.ErrorType> errors) throws Exception {
        LinkedList<JudgeWithTatamis> judges = new LinkedList<JudgeWithTatamis>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int judgeNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime sodnika", "Ime", "Naziv", "Sodnik", "Judge", "Judge name", "Name"});
        int judgePasswordIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Geslo", "Password", "Judge password"});
        int tatamisIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Tatami", "Tatamiji", "Tatamis"});
        if (judgeNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoJudgeName);
        }
        if (judgePasswordIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoJudgePassword);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = ImportUtil.formatName(fileLine.getData(judgeNameIndex));
            String password = fileLine.getData(judgePasswordIndex);
            String tatamisText = null;
            if (tatamisIndex >= 0) {
                tatamisText = ImportUtil.formatName(fileLine.getData(tatamisIndex));
            }
            if (StringUtil.isEmpty((String)name)) continue;
            HashSet<Tatami> tatamis = new HashSet<Tatami>();
            if (StringUtil.isNotEmpty((String)tatamisText)) {
                for (String tatamiName : tatamisText.split(",")) {
                    if ((tatamiName = tatamiName.trim()).isEmpty()) continue;
                    Tatami tatami = this.tatamiManager.getActiveTatamiByName(competition, tatamiName);
                    if (tatami == null) {
                        errors.put(tatamiName, DataImportException.ErrorType.TatamiNotFound);
                        continue;
                    }
                    tatamis.add(tatami);
                }
            }
            JudgeWithTatamis judge = new JudgeWithTatamis();
            judge.setName(name);
            judge.setPassword(password);
            judge.setTatamis(tatamis);
            judges.add(judge);
        }
        return judges;
    }

    public void importJudges(Competition competition, List<JudgeWithTatamis> judges) throws Exception {
        for (JudgeWithTatamis judge : judges) {
            judge.setCompetition(competition);
            Judge existingJudge = this.judgeManager.getActiveJudgeByName(competition, judge.getName());
            if (existingJudge == null) {
                existingJudge = this.judgeManager.createJudge((Judge)judge);
            }
            if (!CollectionUtil.isNotEmpty(judge.getTatamis())) continue;
            this.judgeManager.setTatamisForJudge(existingJudge, judge.getTatamis());
        }
    }

    public byte[] exportJudges(FileType fileType, List<Judge> judges, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[judges.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (Judge judge : judges) {
            StringBuilder tatamiText = new StringBuilder();
            Set tatamis = this.judgeManager.getTatamisForJudge(judge);
            for (Tatami tatami : tatamis) {
                if (tatamiText.length() > 0) {
                    tatamiText.append(", ");
                }
                tatamiText.append(tatami.getName());
            }
            fileContent[i] = new String[]{judge.getName(), "", tatamiText.toString()};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

