/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.query;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.objects.ObjectEquals;
import si.nevensrok.common.objects.ObjectHash;
import si.nevensrok.common.objects.ObjectToString;

public class Sort
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -127047129476784786L;
    private List<Field> fieldList = new LinkedList<Field>();

    public void addField(Field field) {
        this.fieldList.add(field);
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<Field> fieldList) {
        this.fieldList = fieldList;
    }

    public int hashCode() {
        return new ObjectHash().addValue(this.fieldList).calculateHash();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Sort other = (Sort)obj;
            return new ObjectEquals().addValue(this.fieldList, other.fieldList).calculateEquals();
        }
        return false;
    }

    public String toString() {
        return new ObjectToString(Sort.class).addProperty("fieldList", this.fieldList).generateString();
    }

    public Sort clone() {
        try {
            Sort clone = (Sort)super.clone();
            clone.fieldList = new LinkedList<Field>();
            for (Field field : this.fieldList) {
                clone.fieldList.add(field.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cloning failed", e);
        }
    }

    public static class Field
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -5927744250990539552L;
        private String fieldName;
        private Direction direction;
        private boolean caseSensitive;

        public Field() {
            this.direction = Direction.ASC;
            this.caseSensitive = true;
        }

        public Field(String fieldName) {
            this.fieldName = fieldName;
            this.direction = Direction.ASC;
            this.caseSensitive = true;
        }

        public Field(String fieldName, Direction direction) {
            this.fieldName = fieldName;
            this.direction = direction;
            this.caseSensitive = true;
        }

        public Field(String fieldName, Direction direction, boolean caseSensitive) {
            this.fieldName = fieldName;
            this.direction = direction;
            this.caseSensitive = caseSensitive;
        }

        public void setName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public int hashCode() {
            return new ObjectHash().addValue(this.caseSensitive).addValue((Object)this.direction).addValue((Object)this.fieldName).calculateHash();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Field) {
                Field other = (Field)obj;
                return new ObjectEquals().addValue(this.caseSensitive, other.caseSensitive).addValue((Object)this.direction, (Object)other.direction).addValue((Object)this.fieldName, (Object)other.fieldName).calculateEquals();
            }
            return false;
        }

        public String toString() {
            return new ObjectToString(Field.class).addProperty("fieldName", (Object)this.fieldName).addProperty("direction", (Object)this.direction).addProperty("caseSensitive", this.caseSensitive).generateString();
        }

        public Field clone() {
            try {
                return (Field)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Cloning failed", e);
            }
        }

        public static enum Direction {
            ASC,
            DESC;

        }
    }
}

