/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.CoreMetrics;
import sun.font.EAttribute;
import sun.font.Underline;

public class Decoration {
    private static final int VALUES_MASK = AttributeValues.getMask(EAttribute.EFOREGROUND, EAttribute.EBACKGROUND, EAttribute.ESWAP_COLORS, EAttribute.ESTRIKETHROUGH, EAttribute.EUNDERLINE, EAttribute.EINPUT_METHOD_HIGHLIGHT, EAttribute.EINPUT_METHOD_UNDERLINE);
    private static final Decoration PLAIN = new Decoration();

    private Decoration() {
    }

    public static Decoration getPlainDecoration() {
        return PLAIN;
    }

    public static Decoration getDecoration(AttributeValues attributeValues) {
        if (attributeValues == null || !attributeValues.anyDefined(VALUES_MASK)) {
            return PLAIN;
        }
        attributeValues = attributeValues.applyIMHighlight();
        return new DecorationImpl(attributeValues.getForeground(), attributeValues.getBackground(), attributeValues.getSwapColors(), attributeValues.getStrikethrough(), Underline.getUnderline(attributeValues.getUnderline()), Underline.getUnderline(attributeValues.getInputMethodUnderline()));
    }

    public static Decoration getDecoration(Map map) {
        if (map == null) {
            return PLAIN;
        }
        return Decoration.getDecoration(AttributeValues.fromMap(map));
    }

    public void drawTextAndDecorations(Label label, Graphics2D graphics2D, float f, float f2) {
        label.handleDraw(graphics2D, f, f2);
    }

    public Rectangle2D getVisualBounds(Label label) {
        return label.handleGetVisualBounds();
    }

    public Rectangle2D getCharVisualBounds(Label label, int n) {
        return label.handleGetCharVisualBounds(n);
    }

    Shape getOutline(Label label, float f, float f2) {
        return label.handleGetOutline(f, f2);
    }

    private static final class DecorationImpl
    extends Decoration {
        private Paint fgPaint = null;
        private Paint bgPaint = null;
        private boolean swapColors = false;
        private boolean strikethrough = false;
        private Underline stdUnderline = null;
        private Underline imUnderline = null;

        DecorationImpl(Paint paint, Paint paint2, boolean bl, boolean bl2, Underline underline, Underline underline2) {
            this.fgPaint = paint;
            this.bgPaint = paint2;
            this.swapColors = bl;
            this.strikethrough = bl2;
            this.stdUnderline = underline;
            this.imUnderline = underline2;
        }

        private static boolean areEqual(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            DecorationImpl decorationImpl = null;
            try {
                decorationImpl = (DecorationImpl)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            if (this.swapColors != decorationImpl.swapColors || this.strikethrough != decorationImpl.strikethrough) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.stdUnderline, decorationImpl.stdUnderline)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.fgPaint, decorationImpl.fgPaint)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.bgPaint, decorationImpl.bgPaint)) {
                return false;
            }
            return DecorationImpl.areEqual(this.imUnderline, decorationImpl.imUnderline);
        }

        public int hashCode() {
            int n = 1;
            if (this.strikethrough) {
                n |= 2;
            }
            if (this.swapColors) {
                n |= 4;
            }
            if (this.stdUnderline != null) {
                n += this.stdUnderline.hashCode();
            }
            return n;
        }

        private float getUnderlineMaxY(CoreMetrics coreMetrics) {
            float f;
            float f2 = 0.0f;
            if (this.stdUnderline != null) {
                f = coreMetrics.underlineOffset;
                f2 = Math.max(f2, f += this.stdUnderline.getLowerDrawLimit(coreMetrics.underlineThickness));
            }
            if (this.imUnderline != null) {
                f = coreMetrics.underlineOffset;
                f2 = Math.max(f2, f += this.imUnderline.getLowerDrawLimit(coreMetrics.underlineThickness));
            }
            return f2;
        }

        private void drawTextAndEmbellishments(Label label, Graphics2D graphics2D, float f, float f2) {
            float f3;
            label.handleDraw(graphics2D, f, f2);
            if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
                return;
            }
            float f4 = f;
            float f5 = f4 + (float)label.getLogicalBounds().getWidth();
            CoreMetrics coreMetrics = label.getCoreMetrics();
            if (this.strikethrough) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(coreMetrics.strikethroughThickness, 0, 0));
                f3 = f2 + coreMetrics.strikethroughOffset;
                graphics2D.draw(new Line2D.Float(f4, f3, f5, f3));
                graphics2D.setStroke(stroke);
            }
            float f6 = coreMetrics.underlineOffset;
            f3 = coreMetrics.underlineThickness;
            if (this.stdUnderline != null) {
                this.stdUnderline.drawUnderline(graphics2D, f3, f4, f5, f2 + f6);
            }
            if (this.imUnderline != null) {
                this.imUnderline.drawUnderline(graphics2D, f3, f4, f5, f2 + f6);
            }
        }

        @Override
        public void drawTextAndDecorations(Label label, Graphics2D graphics2D, float f, float f2) {
            if (this.fgPaint == null && this.bgPaint == null && !this.swapColors) {
                this.drawTextAndEmbellishments(label, graphics2D, f, f2);
            } else {
                Paint paint;
                Object object;
                Paint paint2;
                Paint paint3 = graphics2D.getPaint();
                if (this.swapColors) {
                    int n;
                    Paint paint4 = paint2 = this.fgPaint == null ? paint3 : this.fgPaint;
                    paint = this.bgPaint == null ? (paint2 instanceof Color ? ((n = 33 * ((Color)(object = (Color)paint2)).getRed() + 53 * ((Color)object).getGreen() + 14 * ((Color)object).getBlue()) > 18500 ? Color.BLACK : Color.WHITE) : Color.WHITE) : this.bgPaint;
                } else {
                    paint = this.fgPaint == null ? paint3 : this.fgPaint;
                    paint2 = this.bgPaint;
                }
                if (paint2 != null) {
                    object = label.getLogicalBounds();
                    object = new Rectangle2D.Float(f + (float)((RectangularShape)object).getX(), f2 + (float)((RectangularShape)object).getY(), (float)((RectangularShape)object).getWidth(), (float)((RectangularShape)object).getHeight());
                    graphics2D.setPaint(paint2);
                    graphics2D.fill((Shape)object);
                }
                graphics2D.setPaint(paint);
                this.drawTextAndEmbellishments(label, graphics2D, f, f2);
                graphics2D.setPaint(paint3);
            }
        }

        @Override
        public Rectangle2D getVisualBounds(Label label) {
            Rectangle2D rectangle2D = label.handleGetVisualBounds();
            if (this.swapColors || this.bgPaint != null || this.strikethrough || this.stdUnderline != null || this.imUnderline != null) {
                float f = 0.0f;
                Rectangle2D rectangle2D2 = label.getLogicalBounds();
                float f2 = 0.0f;
                float f3 = 0.0f;
                if (this.swapColors || this.bgPaint != null) {
                    f2 = (float)rectangle2D2.getY();
                    f3 = f2 + (float)rectangle2D2.getHeight();
                }
                f3 = Math.max(f3, this.getUnderlineMaxY(label.getCoreMetrics()));
                Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, (float)rectangle2D2.getWidth(), f3 - f2);
                rectangle2D.add(float_);
            }
            return rectangle2D;
        }

        @Override
        Shape getOutline(Label label, float f, float f2) {
            Object object;
            if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
                return label.handleGetOutline(f, f2);
            }
            CoreMetrics coreMetrics = label.getCoreMetrics();
            float f3 = coreMetrics.underlineThickness;
            float f4 = coreMetrics.underlineOffset;
            Rectangle2D rectangle2D = label.getLogicalBounds();
            float f5 = f;
            float f6 = f5 + (float)rectangle2D.getWidth();
            Area area = null;
            if (this.stdUnderline != null) {
                object = this.stdUnderline.getUnderlineShape(f3, f5, f6, f2 + f4);
                area = new Area((Shape)object);
            }
            if (this.strikethrough) {
                object = new BasicStroke(coreMetrics.strikethroughThickness, 0, 0);
                float f7 = f2 + coreMetrics.strikethroughOffset;
                Line2D.Float float_ = new Line2D.Float(f5, f7, f6, f7);
                Area area2 = new Area(object.createStrokedShape(float_));
                if (area == null) {
                    area = area2;
                } else {
                    area.add(area2);
                }
            }
            if (this.imUnderline != null) {
                object = this.imUnderline.getUnderlineShape(f3, f5, f6, f2 + f4);
                Area area3 = new Area((Shape)object);
                if (area == null) {
                    area = area3;
                } else {
                    area.add(area3);
                }
            }
            area.add(new Area(label.handleGetOutline(f, f2)));
            return new GeneralPath(area);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("[");
            if (this.fgPaint != null) {
                stringBuffer.append("fgPaint: " + this.fgPaint);
            }
            if (this.bgPaint != null) {
                stringBuffer.append(" bgPaint: " + this.bgPaint);
            }
            if (this.swapColors) {
                stringBuffer.append(" swapColors: true");
            }
            if (this.strikethrough) {
                stringBuffer.append(" strikethrough: true");
            }
            if (this.stdUnderline != null) {
                stringBuffer.append(" stdUnderline: " + this.stdUnderline);
            }
            if (this.imUnderline != null) {
                stringBuffer.append(" imUnderline: " + this.imUnderline);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static interface Label {
        public CoreMetrics getCoreMetrics();

        public Rectangle2D getLogicalBounds();

        public void handleDraw(Graphics2D var1, float var2, float var3);

        public Rectangle2D handleGetCharVisualBounds(int var1);

        public Rectangle2D handleGetVisualBounds();

        public Shape handleGetOutline(float var1, float var2);
    }
}

