/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.semafor.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;

public class FightDisplay
extends JPanel {
    private static final long serialVersionUID = -788963013363412500L;
    private static final int DEFAULT_FONT_SIZE = 35;
    private Font competitorNameFont;
    private static final Color COMPETITOR_1_COLOR = Color.RED;
    private static final Color COMPETITOR_2_COLOR = Color.BLUE;

    public FightDisplay(FightOrder fightOrder, float fontScale) {
        this.competitorNameFont = new Font("SansSerif", 0, Math.round(35.0f * fontScale));
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(0, 140));
        if (fightOrder.getMatch() != null) {
            this.displayMatch(fightOrder.getMatch());
        } else if (fightOrder.getEvent() != null) {
            this.displayEvent(fightOrder.getEvent());
        } else if (fightOrder.getDuoPresentation() != null) {
            this.displayDuoPresentation(fightOrder.getDuoPresentation());
        }
    }

    private void displayMatch(Match match) {
        Competitor competitor2;
        this.setLayout(new GridLayout(3, 1));
        JLabel categoryLabel = new JLabel(match.getCategory().getShortName());
        this.add(categoryLabel);
        categoryLabel.setFont(this.competitorNameFont);
        String competitor1Text = "";
        String competitor2Text = "";
        Competitor competitor1 = match.getCompetitor1();
        if (competitor1 != null) {
            if (competitor1 instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor1;
                competitor1Text = personCompetitor.getShortName();
            }
            if (competitor1 instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor1;
                competitor1Text = coupleCompetitor.getShortName();
            }
            competitor1Text = competitor1Text + "/" + competitor1.getClub().getShortName();
        }
        if ((competitor2 = match.getCompetitor2()) != null) {
            if (competitor2 instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor2;
                competitor2Text = personCompetitor.getShortName();
            }
            if (competitor2 instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor2;
                competitor2Text = coupleCompetitor.getShortName();
            }
            competitor2Text = competitor2Text + "/" + competitor2.getClub().getShortName();
        }
        JPanel competitor1panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor1panel);
        JPanel colorPanel1 = new JPanel();
        colorPanel1.setBackground(COMPETITOR_1_COLOR);
        colorPanel1.setPreferredSize(new Dimension(10, 0));
        competitor1panel.add((Component)colorPanel1, "West");
        JLabel competitor1label = new JLabel(competitor1Text);
        competitor1panel.add((Component)competitor1label, "Center");
        competitor1label.setBorder(BorderFactory.createLineBorder(COMPETITOR_1_COLOR, 1));
        competitor1label.setBackground(Color.WHITE);
        competitor1label.setOpaque(true);
        competitor1label.setFont(this.competitorNameFont);
        JPanel competitor2panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor2panel);
        JPanel colorPanel2 = new JPanel();
        colorPanel2.setBackground(COMPETITOR_2_COLOR);
        colorPanel2.setPreferredSize(new Dimension(10, 0));
        competitor2panel.add((Component)colorPanel2, "West");
        JLabel competitor2label = new JLabel(competitor2Text);
        competitor2panel.add((Component)competitor2label, "Center");
        competitor2label.setBorder(BorderFactory.createLineBorder(COMPETITOR_2_COLOR, 1));
        competitor2label.setBackground(Color.WHITE);
        competitor2label.setOpaque(true);
        competitor2label.setFont(this.competitorNameFont);
    }

    private void displayEvent(Event event) {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setLayout(new FlowLayout(1, 5, 5));
        for (String word : event.getText().split(" ")) {
            JLabel wordLabel = new JLabel(word);
            wordLabel.setFont(this.competitorNameFont);
            this.add(wordLabel);
        }
    }

    private void displayDuoPresentation(DuoPresentation duoPresentation) {
        this.setLayout(new GridLayout(2, 1));
        JLabel categoryLabel = new JLabel(duoPresentation.getCategory().getShortName());
        this.add(categoryLabel);
        categoryLabel.setFont(this.competitorNameFont);
        String competitor1Text = "";
        Competitor competitor = duoPresentation.getCompetitor();
        if (competitor != null) {
            if (competitor instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
                competitor1Text = personCompetitor.getShortName();
            }
            if (competitor instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
                competitor1Text = coupleCompetitor.getShortName();
            }
            competitor1Text = competitor1Text + "/" + competitor.getClub().getShortName();
        }
        JPanel competitor1panel = new JPanel(new BorderLayout());
        competitor1panel.setBackground(Color.WHITE);
        this.add(competitor1panel);
        JPanel colorPanel1 = new JPanel();
        colorPanel1.setBackground(COMPETITOR_1_COLOR);
        colorPanel1.setPreferredSize(new Dimension(10, 0));
        competitor1panel.add((Component)colorPanel1, "West");
        JLabel competitor1label = new JLabel(competitor1Text);
        competitor1panel.add((Component)competitor1label, "Center");
        competitor1label.setBorder(BorderFactory.createLineBorder(COMPETITOR_1_COLOR, 1));
        competitor1label.setBackground(Color.WHITE);
        competitor1label.setOpaque(true);
        competitor1label.setFont(this.competitorNameFont);
    }
}

