/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public final class StringUtil {
    private StringUtil() {
    }

    public static int computeLevenshteinDistance(String s0, String s1) {
        int len0 = s0.length() + 1;
        int len1 = s1.length() + 1;
        int[] cost = new int[len0];
        int[] newcost = new int[len0];
        for (int i = 0; i < len0; ++i) {
            cost[i] = i;
        }
        for (int j = 1; j < len1; ++j) {
            newcost[0] = j;
            for (int i = 1; i < len0; ++i) {
                int match = s0.charAt(i - 1) == s1.charAt(j - 1) ? 0 : 1;
                int cost_replace = cost[i - 1] + match;
                int cost_insert = cost[i] + 1;
                int cost_delete = newcost[i - 1] + 1;
                newcost[i] = Math.min(Math.min(cost_insert, cost_delete), cost_replace);
            }
            int[] swap = cost;
            cost = newcost;
            newcost = swap;
        }
        return cost[len0 - 1];
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtil.isEmpty(text);
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean isNotBlank(String text) {
        return !StringUtil.isBlank(text);
    }

    public static String addPrefixIfMissing(String prefix, String text) {
        if (StringUtil.isEmpty(prefix)) {
            return text;
        }
        if (text == null) {
            return prefix;
        }
        if (text.startsWith(prefix)) {
            return text;
        }
        return prefix + text;
    }

    public static String removePrefixIfPresent(String prefix, String text) {
        if (StringUtil.isEmpty(prefix)) {
            return text;
        }
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String addSuffixIfMissing(String suffix, String text) {
        if (StringUtil.isEmpty(suffix)) {
            return text;
        }
        if (text == null) {
            return suffix;
        }
        if (text.endsWith(suffix)) {
            return text;
        }
        return text + suffix;
    }

    public static String removeSuffixIfPresent(String suffix, String text) {
        if (StringUtil.isEmpty(suffix)) {
            return text;
        }
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static String crop(String text, int length) {
        if (text == null) {
            return null;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be greater that 0");
        }
        if (text.length() < length) {
            return text;
        }
        return text.substring(0, length);
    }

    public static String cropBytes(String text, Charset charset, int length) {
        if (text == null) {
            return null;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be greater that 0");
        }
        if (charset == null) {
            throw new NullPointerException("Charset is null");
        }
        byte[] bytes = text.getBytes(charset);
        if (bytes.length <= length) {
            return text;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
        try {
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(bytes, 0, length));
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Error decoding text", e);
        }
    }
}

