/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import si.nevensrok.common.utils.PlaceholderUtil;
import si.nevensrok.common.utils.StreamUtil;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;

public class TablaMainHttpHandler
implements HttpHandler,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablaMainHttpHandler.class);
    private String htmlContent;
    private MatchData matchData;
    private FightPoints fightPoints;
    private DuoPoints duoPoints;
    private NewazaPoints newazaPoints;
    private RulesManager rulesManager;

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.htmlContent = new String(StreamUtil.readData((InputStream)new ClassPathResource("/si/nevensrok/jtekma/tabla/httpserver/tabla-info.html").getInputStream()), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Error loading html content", (Throwable)e);
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            Set<MatchPoint> matchPoints;
            httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
            httpExchange.sendResponseHeaders(HttpStatus.OK.value(), 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            if (this.matchData.isFlipHttpPosition()) {
                placeholders.put("name2", this.matchData.getName1() + " / " + this.matchData.getClub1());
                placeholders.put("name1", this.matchData.getName2() + " / " + this.matchData.getClub2());
            } else {
                placeholders.put("name1", this.matchData.getName1() + " / " + this.matchData.getClub1());
                placeholders.put("name2", this.matchData.getName2() + " / " + this.matchData.getClub2());
            }
            long time = this.matchData.getTimeLeft() / 1000L;
            long minutes = time / 60L;
            long seconds = time % 60L;
            placeholders.put("time", String.valueOf(minutes) + ":" + Constants.SECONDS_NUMBER_FORMAT.format(seconds));
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(this.matchData.getRules());
            if (this.matchData.getTableType() == TableType.FIGHT) {
                matchPoints = this.fightPoints.getMatchPoints(competitionRules);
                float points1 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR2, matchPoints);
                if (this.matchData.isFlipHttpPosition()) {
                    placeholders.put("points2", Constants.FIGHT_POINTS_FORMAT.format(points1));
                    placeholders.put("points1", Constants.FIGHT_POINTS_FORMAT.format(points2));
                } else {
                    placeholders.put("points1", Constants.FIGHT_POINTS_FORMAT.format(points1));
                    placeholders.put("points2", Constants.FIGHT_POINTS_FORMAT.format(points2));
                }
            } else if (this.matchData.getTableType() == TableType.DUO) {
                placeholders.put("time", "");
                matchPoints = this.duoPoints.getMatchPoints();
                float points1 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR2, matchPoints);
                if (this.matchData.isFlipHttpPosition()) {
                    placeholders.put("points2", Constants.DUO_POINTS_FORMAT.format(points1));
                    placeholders.put("points1", Constants.DUO_POINTS_FORMAT.format(points2));
                } else {
                    placeholders.put("points1", Constants.DUO_POINTS_FORMAT.format(points1));
                    placeholders.put("points2", Constants.DUO_POINTS_FORMAT.format(points2));
                }
            } else if (this.matchData.getTableType() == TableType.NEWAZA) {
                matchPoints = this.newazaPoints.getMatchPoints();
                float points1 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, matchPoints);
                float points2 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, matchPoints);
                if (this.matchData.isFlipHttpPosition()) {
                    placeholders.put("points2", Constants.FIGHT_POINTS_FORMAT.format(points1));
                    placeholders.put("points1", Constants.FIGHT_POINTS_FORMAT.format(points2));
                } else {
                    placeholders.put("points1", Constants.FIGHT_POINTS_FORMAT.format(points1));
                    placeholders.put("points2", Constants.FIGHT_POINTS_FORMAT.format(points2));
                }
            }
            if (this.matchData.isFlipHttpPosition()) {
                placeholders.put("p1class", "player2");
                placeholders.put("p2class", "player1");
            } else {
                placeholders.put("p1class", "player1");
                placeholders.put("p2class", "player2");
            }
            String responseBody = PlaceholderUtil.replacePlaceHolders((String)this.htmlContent, placeholders, (String)"${", (String)"}");
            outputStream.write(responseBody.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        catch (Throwable e) {
            LOGGER.error("Error processing request", e);
            this.sendError(httpExchange, HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error processing request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(HttpExchange httpExchange, int status, String message) {
        OutputStream outputStream = null;
        try {
            httpExchange.sendResponseHeaders(status, 0L);
            outputStream = httpExchange.getResponseBody();
            outputStream.write(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Error sending error", (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

