(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.TableModel = Backbone.Model.extend({
		"url": function() {
		  return contextPath + "/competition/data/table";
		},
		"defaults": {
			"rows": null
		}
	});

	views.TableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var tableData = this.model.toJSON();
			var treeCategoryOptions = jtekma.displaySettings.get("category").get("treeCategoryOptions");
			tableData.matchesGuide3 = treeCategoryOptions.treeType == "TABLE3";
			tableData.matchesGuide4 = treeCategoryOptions.treeType == "TABLE4";
			tableData.matchesGuide5 = treeCategoryOptions.treeType == "TABLE5";

			$(this.el).html(Mustache.render(this.template, tableData));

			$("[rel='tooltip']", this.el).tooltip();

			return this;
		}
	});

})();