/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ListDataResult;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionDTO;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionSettingDTO;

public class CompetitionDAO
extends ExtendedDao<Long, CompetitionDTO, Competition> {
    private static final Logger log = LoggerFactory.getLogger(CompetitionDAO.class);
    private static final String settingsDateFormatText = "yyyy-MM-dd HH:mm:ss.SSS Z";

    public CompetitionDAO() {
        super(CompetitionDTO.class, Competition.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("competitionId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("competitonDate")) {
            return "competitonDate";
        }
        if (fieldName.equalsIgnoreCase("description")) {
            return "description";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public PageDataResult<Competition> findForUser(User user, DataFilter dataFilter) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("from CompetitionDTO as main,UserCompetitionRoleDTO as userCompetitionRole where userCompetitionRole.userCompetitionRoleKey.competition.id=c.id and userCompetitionRole.userCompetitionRoleKey.user.id=");
        sqlQuery.append(params.addParam(user.getUserId()));
        if (dataFilter.getFilter() != null) {
            StringBuilder filterQuery = new StringBuilder();
            try {
                this.addFilter(filterQuery, params, dataFilter.getFilter(), false);
            }
            catch (Exception e) {
                log.error("Error adding filters", (Throwable)e);
            }
            if (filterQuery.length() > 0) {
                sqlQuery.append(" and");
                sqlQuery.append((CharSequence)filterQuery);
            }
        }
        Query query = this.createQuery("select count(main) " + sqlQuery.toString());
        params.bindParams(query);
        Long totalRowCount = Long.parseLong(CompetitionDAO.getSingleResult((Query)query).toString());
        try {
            this.addSort(sqlQuery, dataFilter.getSort());
        }
        catch (Exception e) {
            log.error("Error adding sort conditions", (Throwable)e);
        }
        query = this.createQuery("select main " + sqlQuery.toString());
        params.bindParams(query);
        if (dataFilter.getStartIndex() != null) {
            query.setFirstResult(dataFilter.getStartIndex().intValue());
        }
        if (dataFilter.getItemLimit() != null) {
            query.setMaxResults(dataFilter.getItemLimit().intValue());
        }
        List result = query.getResultList();
        LinkedList<Competition> list = new LinkedList<Competition>();
        for (Object item : result) {
            CompetitionDTO dto = (CompetitionDTO)item;
            Competition pojo = (Competition)this.getAdapterPool().create(this.getPojoClass(), (Object)dto);
            list.add(pojo);
        }
        ListDataResult dataResult = new ListDataResult();
        dataResult.setData(list);
        dataResult.setTotalCount(totalRowCount);
        dataResult.setDisplayItemsPerPage(dataFilter.getItemLimit());
        this.flush();
        return dataResult;
    }

    public Role getCompetitionRoleForUser(User user, Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select userCompetitionRole.role from UserCompetitionRoleDTO as userCompetitionRole where userCompetitionRole.userCompetitionRoleKey.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and userCompetitionRoleKey.user.id=");
        sqlQuery.append(params.addParam(user.getUserId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        Role role = (Role)CompetitionDAO.getSingleResult((Query)query);
        return role;
    }

    public Map<Competition, Role> getCompetitionRolesForUser(User user) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select userCompetitionRole.userCompetitionRoleKey.competition,userCompetitionRole.role from UserCompetitionRoleDTO as userCompetitionRole where userCompetitionRole.userCompetitionRoleKey.user.id=");
        sqlQuery.append(params.addParam(user.getUserId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        HashMap<Competition, Role> roles = new HashMap<Competition, Role>();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            Competition competition = (Competition)this.getAdapterPool().create(Competition.class, parts[0]);
            Role role = (Role)parts[1];
            roles.put(competition, role);
        }
        return roles;
    }

    public List<Competition> getCompetitionsForUser(User user, int count) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select userCompetitionRole.userCompetitionRoleKey.competition from UserCompetitionRoleDTO as userCompetitionRole where userCompetitionRole.userCompetitionRoleKey.user.id=");
        sqlQuery.append(params.addParam(user.getUserId()));
        sqlQuery.append(" order by userCompetitionRole.userCompetitionRoleKey.competition.competitonDate desc");
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(count);
        List list = query.getResultList();
        LinkedList<Competition> competitions = new LinkedList<Competition>();
        for (Object item : list) {
            Competition competition = (Competition)this.getAdapterPool().create(Competition.class, item);
            competitions.add(competition);
        }
        return competitions;
    }

    public Competition getCompetitionForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select category.competition from CategoryDTO as category where category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForClub(Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select club.competition from ClubDTO as club where club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForCompetitor(Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor.competition from CompetitorDTO as competitor where competitor.id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForTatami(Tatami tatami) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select tatami.competition from TatamiDTO as tatami where tatami.id=");
        sqlQuery.append(params.addParam(tatami.getTatamiId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForSemaphore(Semaphore semaphore) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select semaphore.competition from SemaphoreDTO as semaphore where semaphore.id=");
        sqlQuery.append(params.addParam(semaphore.getSemaphoreId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForNextMatchUpload(NextMatchUpload nextMatchUpload) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select nextMatchUpload.competition from NextMatchUploadDTO as nextMatchUpload where nextMatchUpload.nextMatchUploadId=");
        sqlQuery.append(params.addParam(nextMatchUpload.getNextMatchUploadId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Competition getCompetitionForCategoryGroup(CategoryGroup categoryGroup) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select categoryGroup.competition from CategoryGroupDTO as categoryGroup where categoryGroup.categoryGroupId=");
        sqlQuery.append(params.addParam(categoryGroup.getCategoryGroupId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CompetitionDTO competitionDTO = (CompetitionDTO)CompetitionDAO.getSingleResult((Query)query);
        Competition competition = null;
        if (competitionDTO != null) {
            competition = (Competition)this.getAdapterPool().create(Competition.class, (Object)competitionDTO);
        }
        return competition;
    }

    public Map<String, Object> getCompetitionSettings(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitionSetting from CompetitionSettingDTO as competitionSetting where competitionSetting.competitionSettingKey.competition.competitionId=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        HashMap<String, Object> competitionSettings = new HashMap<String, Object>();
        for (CompetitionSettingDTO competitionSettingDTO : list) {
            Object value = null;
            if (competitionSettingDTO.getSettingsValue() != null) {
                if (competitionSettingDTO.getValueType() == CompetitionSettingDTO.ValueType.STRING) {
                    value = competitionSettingDTO.getSettingsValue();
                } else if (competitionSettingDTO.getValueType() == CompetitionSettingDTO.ValueType.NUMBER) {
                    try {
                        value = Long.parseLong(competitionSettingDTO.getSettingsValue());
                    }
                    catch (Exception e) {
                        log.warn("Error parsing long", (Throwable)e);
                    }
                } else if (competitionSettingDTO.getValueType() == CompetitionSettingDTO.ValueType.DECIMAL) {
                    try {
                        value = Double.parseDouble(competitionSettingDTO.getSettingsValue());
                    }
                    catch (Exception e) {
                        log.warn("Error parsing double", (Throwable)e);
                    }
                } else if (competitionSettingDTO.getValueType() == CompetitionSettingDTO.ValueType.DATE) {
                    try {
                        SimpleDateFormat settingsDateFormat = new SimpleDateFormat(settingsDateFormatText);
                        value = settingsDateFormat.parseObject(competitionSettingDTO.getSettingsValue());
                    }
                    catch (Exception e) {
                        log.warn("Error parsing date", (Throwable)e);
                    }
                } else if (competitionSettingDTO.getValueType() == CompetitionSettingDTO.ValueType.BOOLEAN) {
                    try {
                        value = Boolean.parseBoolean(competitionSettingDTO.getSettingsValue());
                    }
                    catch (Exception e) {
                        log.warn("Error parsing boolean", (Throwable)e);
                    }
                }
            }
            competitionSettings.put(competitionSettingDTO.getCompetitionSettingKey().getSettingKey(), value);
        }
        this.flush();
        return competitionSettings;
    }

    public void setCompetitionSettings(Competition competition, Map<String, Object> settings, boolean removeOther) {
        SimpleDateFormat settingsDateFormat = new SimpleDateFormat(settingsDateFormatText);
        if (removeOther) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("delete from CompetitionSettingDTO where competitionSettingKey.competition.competitionId=");
            sqlQuery.append(params.addParam(competition.getCompetitionId()));
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        CompetitionDTO competitionDTO = new CompetitionDTO();
        competitionDTO.setCompetitionId(competition.getCompetitionId());
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            Comparable<Date> date;
            Number number;
            CompetitionSettingDTO competitionSettingDTO = new CompetitionSettingDTO(competitionDTO, entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.STRING);
                competitionSettingDTO.setSettingsValue(null);
            } else if (value instanceof String) {
                String text = (String)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.STRING);
                competitionSettingDTO.setSettingsValue(text);
            } else if (value instanceof Integer) {
                number = (Integer)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.NUMBER);
                competitionSettingDTO.setSettingsValue(((Integer)number).toString());
            } else if (value instanceof Long) {
                number = (Long)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.NUMBER);
                competitionSettingDTO.setSettingsValue(((Long)number).toString());
            } else if (value instanceof Float) {
                number = (Float)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.DECIMAL);
                competitionSettingDTO.setSettingsValue(((Float)number).toString());
            } else if (value instanceof Double) {
                number = (Double)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.DECIMAL);
                competitionSettingDTO.setSettingsValue(((Double)number).toString());
            } else if (value instanceof Date) {
                date = (Date)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.DATE);
                competitionSettingDTO.setSettingsValue(settingsDateFormat.format((Date)date));
            } else if (value instanceof Calendar) {
                date = (Calendar)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.DATE);
                competitionSettingDTO.setSettingsValue(settingsDateFormat.format(((Calendar)date).getTime()));
            } else if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                competitionSettingDTO.setValueType(CompetitionSettingDTO.ValueType.BOOLEAN);
                competitionSettingDTO.setSettingsValue(bool.toString());
            }
            super.saveInstance((Object)competitionSettingDTO);
        }
        this.flush();
    }
}

