/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;
import si.nevensrok.jtekma.server.management.updaters.TreePlacingsCalculator;

public class TreeUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeUpdater.class);
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private MatchManager matchManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private CategoryManager categoryManager;
    private TreePlacingsCalculator treePlacingsCalculator;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setTreePlacingsCalculator(TreePlacingsCalculator treePlacingsCalculator) {
        this.treePlacingsCalculator = treePlacingsCalculator;
    }

    public void updateTreeCategory(TreeCategory treeCategory) {
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)treeCategory);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap matchPoints = new HashMap();
        for (Match match : this.matchManager.getMatchesForCategory((Category)treeCategory)) {
            matches.put(match.getFightNumber(), match);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
        }
        TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
        Map map = this.categoryManager.getDrawAsNumber((Category)treeCategory);
        if (treeCategory.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
            Match match1 = (Match)matches.get(1);
            match1.setCompetitor1((Competitor)map.get(1));
            match1.setCompetitor2((Competitor)map.get(2));
            match1.setNotNeeded(Boolean.valueOf(false));
            match1.setMatchEmpty(Boolean.valueOf(false));
            Competitor winner1 = competitionRules.getMatchWinner(match1, (Set)matchPoints.get(match1.getFightNumber()));
            Match match2 = (Match)matches.get(2);
            match2.setCompetitor1((Competitor)map.get(2));
            match2.setCompetitor2((Competitor)map.get(1));
            match2.setNotNeeded(Boolean.valueOf(false));
            match2.setMatchEmpty(Boolean.valueOf(false));
            Competitor winner2 = competitionRules.getMatchWinner(match2, (Set)matchPoints.get(match2.getFightNumber()));
            Match match3 = (Match)matches.get(3);
            match3.setCompetitor1((Competitor)map.get(1));
            match3.setCompetitor2((Competitor)map.get(2));
            match3.setMatchEmpty(Boolean.valueOf(false));
            if (winner1 != null && winner2 != null && winner1.equals((Object)winner2)) {
                match3.setNotNeeded(Boolean.valueOf(true));
            } else {
                match3.setNotNeeded(Boolean.valueOf(false));
            }
            for (int i = 4; i <= 124; ++i) {
                Match match = (Match)matches.get(i);
                match.setCompetitor1(null);
                match.setCompetitor2(null);
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(true));
            }
        } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
            Match match;
            int i;
            for (i = 1; i <= 10; ++i) {
                match = (Match)matches.get(i);
                TreeAdvancmentItem treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TABLE);
                TreeAdvancmentItem treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TABLE);
                match.setCompetitor1((Competitor)map.get(treeAdvancmentItem1.getFromMatch()));
                match.setCompetitor2((Competitor)map.get(treeAdvancmentItem2.getFromMatch()));
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 && (treeAdvancmentItem1.getFromMatch() == 1 && treeAdvancmentItem2.getFromMatch() == 2 || treeAdvancmentItem1.getFromMatch() == 2 && treeAdvancmentItem2.getFromMatch() == 1) || match.getCompetitor1() != null && match.getCompetitor2() != null) {
                    match.setNotNeeded(Boolean.valueOf(false));
                    match.setMatchEmpty(Boolean.valueOf(false));
                    continue;
                }
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(false));
            }
            for (i = 11; i <= 124; ++i) {
                match = (Match)matches.get(i);
                match.setCompetitor1(null);
                match.setCompetitor2(null);
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(true));
            }
        } else {
            for (int i = 1; i <= 124; ++i) {
                Match match = (Match)matches.get(i);
                LOGGER.trace("Calculating for match num {}, match={}", (Object)i, (Object)match);
                TreeAdvancmentItem treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                TreeAdvancmentItem treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                Match fromMatch1 = (Match)matches.get(treeAdvancmentItem1.getFromMatch());
                Match fromMatch2 = (Match)matches.get(treeAdvancmentItem2.getFromMatch());
                Competitor competitor1 = null;
                Competitor competitor2 = null;
                if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW) {
                    competitor1 = (Competitor)map.get(treeAdvancmentItem1.getFromMatch());
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                    if (fromMatch1.getNotNeeded().booleanValue()) {
                        if (fromMatch1.getCompetitor1() != null) {
                            competitor1 = fromMatch1.getCompetitor1();
                        } else if (fromMatch1.getCompetitor2() != null) {
                            competitor1 = fromMatch1.getCompetitor2();
                        }
                    } else if (fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                        competitor1 = competitionRules.getMatchWinner(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                    }
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && !fromMatch1.getNotNeeded().booleanValue() && fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                    competitor1 = competitionRules.getMatchLoser(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                }
                if (treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                    competitor2 = (Competitor)map.get(treeAdvancmentItem2.getFromMatch());
                } else if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                    if (fromMatch2.getNotNeeded().booleanValue()) {
                        if (fromMatch2.getCompetitor1() != null) {
                            competitor2 = fromMatch2.getCompetitor1();
                        } else if (fromMatch2.getCompetitor2() != null) {
                            competitor2 = fromMatch2.getCompetitor2();
                        }
                    } else if (fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                        competitor2 = competitionRules.getMatchWinner(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                    }
                } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER && !fromMatch2.getNotNeeded().booleanValue() && fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                    competitor2 = competitionRules.getMatchLoser(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                }
                if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW || treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                    if (competitor1 == null && competitor2 == null) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    } else if (competitor1 == null || competitor2 == null) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    } else {
                        match.setNotNeeded(Boolean.valueOf(false));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    }
                } else if ((fromMatch1.getMatchEmpty().booleanValue() || treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue()) && (fromMatch2.getMatchEmpty().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue())) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(true));
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue()) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(false));
                } else if (fromMatch1.getMatchEmpty().booleanValue() || fromMatch2.getMatchEmpty().booleanValue()) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(false));
                } else {
                    match.setNotNeeded(Boolean.valueOf(false));
                    match.setMatchEmpty(Boolean.valueOf(false));
                }
                if (i >= 49 && i <= 64) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 1) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 65 && i <= 80) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 2) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 89 && i <= 104) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 3) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 109 && i <= 116) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 4) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 119 && i <= 122 && (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 5)) {
                    competitor1 = null;
                    competitor2 = null;
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(true));
                }
                match.setCompetitor1(competitor1);
                match.setCompetitor2(competitor2);
            }
            if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getDouble3rdPlace().booleanValue()) {
                ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(true));
                ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(true));
                ((Match)matches.get(123)).setCompetitor1(null);
                ((Match)matches.get(123)).setCompetitor2(null);
            } else {
                ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(false));
                ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(false));
            }
        }
        this.matchManager.updateMatchTreeAdvancmentData(matches.values());
        Map<Competitor, Integer> placings = this.treePlacingsCalculator.getPlacings(treeCategory);
        this.categoryManager.setPlacings((Category)treeCategory, placings);
    }
}

