/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.List;
import org.jasypt.util.password.PasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.dl.dao.CompetitionRoleDAO;
import si.nevensrok.jtekma.server.dl.dao.UserDAO;
import si.nevensrok.jtekma.server.management.UserManager;

public class UserManagerImpl
implements UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManagerImpl.class);
    private PasswordEncryptor passwordEncryptor;
    private UserDAO userDAO;
    private CompetitionRoleDAO competitionRoleDAO;

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setCompetitionRoleDAO(CompetitionRoleDAO competitionRoleDAO) {
        this.competitionRoleDAO = competitionRoleDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public User createUser(User user) {
        user.setPassword(this.passwordEncryptor.encryptPassword(user.getPassword()));
        if (log.isDebugEnabled()) {
            log.debug("Creating user {}", (Object)user);
        }
        return (User)this.userDAO.create((Pojo)user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public User updateUser(User user) {
        if (log.isDebugEnabled()) {
            log.debug("Updating user {}", (Object)user);
        }
        return (User)this.userDAO.update((Pojo)user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateUsersPassword(User user) {
        user.setPassword(this.passwordEncryptor.encryptPassword(user.getPassword()));
        if (log.isDebugEnabled()) {
            log.debug("Updeating users password {}", (Object)user);
        }
        this.userDAO.updateUsersPassword(user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateUsersPasswordStatusAndSA(User user) {
        this.userDAO.updateUsersPasswordStatusAndSA(user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<User> findUsers(DataFilter dataFilter) {
        return this.userDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public User getUserByUsername(String username) {
        return this.userDAO.getUserByUsername(username);
    }

    @Transactional(value="jtekmaTransactionManager")
    public User getById(Long userId) {
        return (User)this.userDAO.getById((Object)userId);
    }

    public boolean checkPassword(String password, String encryptedPassword) {
        return this.passwordEncryptor.checkPassword(password, encryptedPassword);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<CompetitionRole> getRolesForUser(User user) {
        return this.competitionRoleDAO.getRolesForUser(user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public CompetitionRole getRoleForUser(User user, Competition competition) {
        return this.competitionRoleDAO.getRoleForUser(user, competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setRolesForUser(User user, List<CompetitionRole> competitionRoles) {
        this.competitionRoleDAO.setRolesForUser(user, competitionRoles);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCompetitionRole(CompetitionRole competitionRole) {
        this.competitionRoleDAO.setCompetitionRole(competitionRole);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void removeCompetitionRole(CompetitionRole competitionRole) {
        this.competitionRoleDAO.removeCompetitionRole(competitionRole);
    }
}

