/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.lock.LockService;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.updaters.Duo2023PlacingCalculator;
import si.nevensrok.jtekma.server.management.updaters.Duo2023Updater;
import si.nevensrok.jtekma.server.management.updaters.TableCalculator;
import si.nevensrok.jtekma.server.management.updaters.TreePlacingsCalculator;
import si.nevensrok.jtekma.server.management.updaters.TreeUpdater;

@Transactional(value="jtekmaTransactionManager")
public class CategoryTreeUpdateManagerImpl
implements CategoryTreeUpdateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryTreeUpdateManagerImpl.class);
    private MatchManager matchManager;
    private CategoryManager categoryManager;
    private LockService lockService;
    private TreeUpdater treeUpdater;
    private Duo2023Updater duo2023Updater;
    private TableCalculator tableCalculator;
    private TreePlacingsCalculator treePlacingsCalculator;
    private Duo2023PlacingCalculator duo2023PlacingCalculator;

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setTreeUpdater(TreeUpdater treeUpdater) {
        this.treeUpdater = treeUpdater;
    }

    public void setDuo2023Updater(Duo2023Updater duo2023Updater) {
        this.duo2023Updater = duo2023Updater;
    }

    public void setTableCalculator(TableCalculator tableCalculator) {
        this.tableCalculator = tableCalculator;
    }

    public void setTreePlacingsCalculator(TreePlacingsCalculator treePlacingsCalculator) {
        this.treePlacingsCalculator = treePlacingsCalculator;
    }

    public void setDuo2023PlacingCalculator(Duo2023PlacingCalculator duo2023PlacingCalculator) {
        this.duo2023PlacingCalculator = duo2023PlacingCalculator;
    }

    public void updateCategory(Category category) {
        if (category == null || category.getCategoryId() == null) {
            return;
        }
        this.lockCategory(category);
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Updating category matches and results for {}", (Object)category);
        try {
            if (category instanceof TreeCategory) {
                this.treeUpdater.updateTreeCategory((TreeCategory)category);
            } else if (category instanceof Duo2023Category) {
                this.duo2023Updater.updateDuo2023Category((Duo2023Category)category);
            } else {
                LOGGER.warn("Category can not be updated {}", (Object)category);
            }
            LOGGER.debug("Updating category finished");
        }
        catch (Throwable e) {
            LOGGER.error("Error while updating category " + category.toString(), e);
        }
        finally {
            this.unlockCategory(category);
        }
    }

    public Table getTable(Category category) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Calculating table for category {}", (Object)category);
        try {
            if (category instanceof TreeCategory) {
                return this.tableCalculator.getTable((TreeCategory)category);
            }
            LOGGER.warn("Table can not be calculated {}", (Object)category);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error while calculating table for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    public List<DuoTable> getDuoTables(Category category) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Calculating duo tables for category {}", (Object)category);
        try {
            if (category instanceof Duo2023Category) {
                return this.duo2023Updater.getDuoTables((Duo2023Category)category);
            }
            LOGGER.warn("Duo tables can not be calculated {}", (Object)category);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error while calculating duo tables for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    public Map<Competitor, Integer> getPlacings(Category category) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Calculating placings for category {}", (Object)category);
        try {
            if (category instanceof TreeCategory) {
                return this.treePlacingsCalculator.getPlacings((TreeCategory)category);
            }
            LOGGER.warn("Category placings can not be calculated {}", (Object)category);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error while calculating placings for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    public Map<Competitor, Integer> getPlacings(Category category, Rank rank) {
        if (category == null) {
            return null;
        }
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Calculating placings for category {}", (Object)category);
        try {
            if (category instanceof Duo2023Category) {
                return this.duo2023PlacingCalculator.getPlacings((Duo2023Category)category, rank);
            }
            LOGGER.warn("Category placings can not be calculated {}", (Object)category);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error while calculating placings for category " + category.toString(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match addMatch(Category category, Match match) {
        if (category == null || category.getCategoryId() == null) {
            return null;
        }
        if (match == null) {
            return null;
        }
        this.lockCategory(category);
        category = this.categoryManager.getById(category.getCategoryId());
        LOGGER.debug("Adding match {} to category {}", (Object)match, (Object)category);
        try {
            if (category.getType() != Category.Type.CUSTOM) {
                throw new RuntimeException("Category is not CUSTOM type");
            }
            int fightNumber = 1;
            for (Match m : this.matchManager.getMatchesForCategory(category)) {
                if (fightNumber > m.getFightNumber()) continue;
                fightNumber = m.getFightNumber() + 1;
            }
            match.setCategory(category);
            match.setFightNumber(Integer.valueOf(fightNumber));
            match = this.matchManager.createMatch(match);
        }
        catch (Throwable e) {
            LOGGER.error("Error while adding match to category " + category.toString(), e);
        }
        finally {
            this.unlockCategory(category);
        }
        return match;
    }

    private void lockCategory(Category category) {
        Lock lock = this.lockService.getLockByName("category.update." + category.getCategoryId());
        lock.lock();
    }

    private void unlockCategory(Category category) {
        Lock lock = this.lockService.getLockByName("category.update." + category.getCategoryId());
        lock.unlock();
    }
}

