/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.jtekma.common.system.AutologinToken;
import si.nevensrok.jtekma.server.dl.dao.AutologinTokenDAO;
import si.nevensrok.jtekma.server.management.AutologinTokenManager;

public class AutologinTokenManagerImpl
implements AutologinTokenManager {
    private static final Logger log = LoggerFactory.getLogger(AutologinTokenManagerImpl.class);
    private AutologinTokenDAO autologinTokenDAO;

    public void setAutologinTokenDAO(AutologinTokenDAO autologinTokenDAO) {
        this.autologinTokenDAO = autologinTokenDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public AutologinToken createAutologinToken(AutologinToken autologinToken) {
        if (log.isDebugEnabled()) {
            log.debug("Creating autologin token {}", (Object)autologinToken);
        }
        return (AutologinToken)this.autologinTokenDAO.create((Pojo)autologinToken);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AutologinToken updateAutologinToken(AutologinToken autologinToken) {
        if (log.isDebugEnabled()) {
            log.debug("Updateing autologin token {}", (Object)autologinToken);
        }
        return (AutologinToken)this.autologinTokenDAO.update((Pojo)autologinToken);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AutologinToken getBySeries(String series) {
        return (AutologinToken)this.autologinTokenDAO.getById((Object)series);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void removeUserTokensForUsername(String username) {
        if (log.isDebugEnabled()) {
            log.debug("Removing tokens for username {}", (Object)username);
        }
        this.autologinTokenDAO.removeUserTokensForUsername(username);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void removeOlderTokens(Date date) {
        if (log.isDebugEnabled()) {
            log.debug("Removing tokens older than {}", (Object)date);
        }
        this.autologinTokenDAO.removeOlderTokens(date);
    }
}

