/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;

public class PersonCompetitorImporter {
    private static final Logger log = LoggerFactory.getLogger(PersonCompetitorImporter.class);
    private static final int bufferSize = 65536;
    private CompetitorManager competitorManager;
    private ClubManager clubManager;
    private CategoryManager categoryManager;

    public void setCompetitorManager(CompetitorManager competitorManager) {
        this.competitorManager = competitorManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public List<Competitor> parseCompetitors(FileType fileType, byte[] fileData, Competition competition, Map<String, DataImportException.ErrorType> errors) {
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        HashMap<String, PersonCompetitor> personCompetitors = new HashMap<String, PersonCompetitor>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int competitorFirstNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime", "Ime tekmovalca", "Name", "First name"});
        int competitorLastNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Priimek", "Priimek tekmovalca", "Surname", "Last name", "Prezime"});
        int clubNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Klub", "Ime kluba", "Club", "Club Name"});
        int categoryNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kategorija", "Ime kategorije", "Category", "Category Name"});
        int competitorShortNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kratica", "Competitor Short Name", "Short Name"});
        int yearOfBirthIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Leto rojstva", "Year Of Birth", "Birth year"});
        int weightIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Te\u017ea", "Kilogrami", "Weight", "Competitor Weight"});
        if (competitorFirstNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCompetitorName);
        }
        if (competitorLastNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCompetitorSurname);
        }
        if (clubNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCompetitorClub);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String competitorKey;
            PersonCompetitor personCompetitor;
            String shortName;
            Category c;
            String firstName = ImportUtil.formatName(fileLine.getData(competitorFirstNameIndex));
            String lastName = ImportUtil.formatName(fileLine.getData(competitorLastNameIndex));
            String clubName = ImportUtil.formatName(fileLine.getData(clubNameIndex));
            if (firstName == null || firstName.isEmpty() || lastName == null || lastName.isEmpty() || clubName == null || clubName.isEmpty()) continue;
            Club club = this.clubManager.getActiveClubByName(competition, clubName);
            if (club == null) {
                errors.put(firstName + " " + lastName + " / " + clubName, DataImportException.ErrorType.ClubNotFound);
                continue;
            }
            String categoryName = fileLine.getData(categoryNameIndex);
            Category category = null;
            if (categoryName != null && !categoryName.trim().isEmpty() && (c = this.categoryManager.getActiveCategoryByName(competition, categoryName = categoryName.trim())) != null) {
                if (c instanceof FightingCategory) {
                    category = c;
                } else if (c instanceof NewazaCategory) {
                    category = c;
                } else if (c.getType() == Category.Type.CUSTOM) {
                    category = c;
                }
            }
            if (category == null) {
                errors.put(firstName + " " + lastName + " / " + clubName, DataImportException.ErrorType.CategoryNotFound);
            }
            if ((shortName = fileLine.getData(competitorShortNameIndex)) == null || shortName.trim().isEmpty()) {
                shortName = firstName.charAt(0) + ". " + lastName;
            }
            Integer yearOfBirth = null;
            if (fileLine.getData(yearOfBirthIndex) != null && !fileLine.getData(yearOfBirthIndex).trim().isEmpty()) {
                try {
                    yearOfBirth = Integer.parseInt(fileLine.getData(yearOfBirthIndex).trim());
                }
                catch (Exception e) {
                    log.warn("Error while parsing year of birth for competitor {} {}", (Object)firstName, (Object)lastName);
                }
            }
            Integer weight = null;
            if (fileLine.getData(weightIndex) != null && !fileLine.getData(weightIndex).trim().isEmpty()) {
                try {
                    weight = Integer.parseInt(fileLine.getData(weightIndex).trim());
                }
                catch (Exception e) {
                    log.warn("Error while parsing weight for competitor {} {}", (Object)firstName, (Object)lastName);
                }
            }
            if ((personCompetitor = this.competitorManager.getActivePersonCompetitorByNameAndClub(competition, firstName, lastName, club)) == null) {
                personCompetitor = new PersonCompetitor();
                personCompetitor.setName(firstName);
                personCompetitor.setSurname(lastName);
                personCompetitor.setShortName(shortName);
                personCompetitor.setClub(club);
                personCompetitor.setYearOfBirth(yearOfBirth);
                personCompetitor.setWeight(weight);
                personCompetitor.setStatus(Competitor.Status.ACTIVE);
                personCompetitor.setType(Competitor.Type.COMPETITOR);
                personCompetitor.setCompetition(competition);
            }
            if (!personCompetitors.containsKey(competitorKey = firstName + " " + lastName + "/" + clubName)) {
                personCompetitors.put(competitorKey, personCompetitor);
                competitors.add((Competitor)personCompetitor);
            } else {
                personCompetitor = (PersonCompetitor)personCompetitors.get(competitorKey);
            }
            if (personCompetitor.getCategories() == null) {
                personCompetitor.setCategories(new LinkedList());
            }
            if (category == null) continue;
            personCompetitor.getCategories().add(category);
        }
        return competitors;
    }

    public void importCompetitors(Competition competition, List<Competitor> competitors) throws Exception {
        for (Competitor competitor : competitors) {
            List categories = competitor.getCategories();
            if (competitor.getCompetitorId() == null) {
                competitor = this.competitorManager.createCompetitor(competitor);
            }
            for (Category category : categories) {
                this.competitorManager.addCompetitorToCategory(competitor, category);
            }
        }
    }

    public byte[] exportCompetitors(FileType fileType, List<Competitor> competitors, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        LinkedList<String[]> fileContent = new LinkedList<String[]>();
        fileContent.add(header);
        for (Competitor competitor : competitors) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            List categories = this.categoryManager.getCategoriesForCompetitor(competitor);
            if (categories.isEmpty()) {
                fileContent.add(new String[]{personCompetitor.getName(), personCompetitor.getSurname(), personCompetitor.getClub().getName(), "", personCompetitor.getShortName(), personCompetitor.getYearOfBirth() != null ? personCompetitor.getYearOfBirth().toString() : "", personCompetitor.getWeight() != null ? personCompetitor.getWeight().toString() : ""});
                continue;
            }
            for (Category category : categories) {
                fileContent.add(new String[]{personCompetitor.getName(), personCompetitor.getSurname(), personCompetitor.getClub().getName(), category.getName(), personCompetitor.getShortName(), personCompetitor.getYearOfBirth() != null ? personCompetitor.getYearOfBirth().toString() : "", personCompetitor.getWeight() != null ? personCompetitor.getWeight().toString() : ""});
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, (String[][])fileContent.toArray((T[])new String[0][0]));
        return buffer.toByteArray();
    }
}

