/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.common.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;

public class DuoTable
implements Serializable {
    private static final long serialVersionUID = -1799073353592862626L;
    private Round round;
    private Rank rank;
    private Integer groupNumber;
    private boolean notNeeded = false;
    private List<Row> rows;
    private List<Competitor> winners;
    private List<Competitor> losers;
    private boolean finished = false;

    public DuoTable() {
    }

    public DuoTable(Round round, Rank rank, Integer groupNumber) {
        this.round = round;
        this.rank = rank;
        this.groupNumber = groupNumber;
    }

    public Round getRound() {
        return this.round;
    }

    public void setRound(Round round) {
        this.round = round;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(Integer groupNumber) {
        this.groupNumber = groupNumber;
    }

    public boolean isNotNeeded() {
        return this.notNeeded;
    }

    public void setNotNeeded(boolean notNeeded) {
        this.notNeeded = notNeeded;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void addCompetitor(Competitor competitor) {
        if (competitor == null) {
            return;
        }
        Row row = new Row();
        row.setCompetitor(competitor);
        if (this.rows == null) {
            this.rows = new LinkedList<Row>();
        }
        this.rows.add(row);
    }

    public void addCompetitors(Collection<Competitor> competitors) {
        if (CollectionUtil.isEmpty(competitors)) {
            return;
        }
        for (Competitor competitor : competitors) {
            this.addCompetitor(competitor);
        }
    }

    public List<Competitor> getWinners() {
        return this.winners;
    }

    public void setWinners(List<Competitor> winners) {
        this.winners = winners;
    }

    public Competitor getWinner(int n) {
        if (this.winners == null) {
            return null;
        }
        if (n >= this.winners.size()) {
            return null;
        }
        return this.winners.get(n);
    }

    public List<Competitor> getWinners(int n) {
        if (this.winners == null) {
            return new ArrayList<Competitor>(0);
        }
        if (n >= this.winners.size()) {
            return new ArrayList<Competitor>(0);
        }
        LinkedList<Competitor> list = new LinkedList<Competitor>();
        for (int i = n; i < this.winners.size(); ++i) {
            list.add(this.winners.get(i));
        }
        return list;
    }

    public List<Competitor> getLosers() {
        return this.losers;
    }

    public void setLosers(List<Competitor> losers) {
        this.losers = losers;
    }

    public Competitor getLoser(int n) {
        if (this.losers == null) {
            return null;
        }
        if (n >= this.losers.size()) {
            return null;
        }
        return this.losers.get(n);
    }

    public List<Competitor> getLosers(int n) {
        if (this.losers == null) {
            return new ArrayList<Competitor>(0);
        }
        if (n >= this.losers.size()) {
            return new ArrayList<Competitor>(0);
        }
        LinkedList<Competitor> list = new LinkedList<Competitor>();
        for (int i = n; i < this.losers.size(); ++i) {
            list.add(this.losers.get(i));
        }
        return list;
    }

    public String toString() {
        return new ObjectToString(DuoTable.class).addProperty("round", (Object)this.round).addProperty("rank", (Object)this.rank).addProperty("groupNumber", (Object)this.groupNumber).addProperty("notNeeded", this.notNeeded).addProperty("rows", this.rows).addProperty("winners", this.winners).addProperty("losers", this.losers).addProperty("finished", this.finished).generateString();
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = -7641984004030531912L;
        private Competitor competitor;
        private DuoPresentation duoPresentation;
        private float points = 0.0f;
        private Integer placing = null;

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(Competitor competitor) {
            this.competitor = competitor;
        }

        public DuoPresentation getDuoPresentation() {
            return this.duoPresentation;
        }

        public void setDuoPresentation(DuoPresentation duoPresentation) {
            this.duoPresentation = duoPresentation;
        }

        public float getPoints() {
            return this.points;
        }

        public void setPoints(float points) {
            this.points = points;
        }

        public Integer getPlacing() {
            return this.placing;
        }

        public void setPlacing(Integer placing) {
            this.placing = placing;
        }

        public String toString() {
            return new ObjectToString(Row.class).addProperty("competitor", (Object)this.competitor).addProperty("duoPresentation", (Object)this.duoPresentation).addProperty("points", this.points).addProperty("placing", (Object)this.placing).generateString();
        }
    }
}

