/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.server.web.security.AutologinTokenRepository;

public class ExpiredTokensRemoverJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(ExpiredTokensRemoverJob.class);

    public void execute(JobExecutionContext executionContext) throws JobExecutionException {
        try {
            ApplicationContext applicationContext;
            if (log.isDebugEnabled()) {
                log.debug("Expired autologin tokens remover job started");
            }
            if ((applicationContext = (ApplicationContext)executionContext.getScheduler().getContext().get((Object)"applicationContext")) == null) {
                throw new Exception("No application context available");
            }
            AutologinTokenRepository autologinTokenRepository = (AutologinTokenRepository)applicationContext.getBean("jtekmaAutologinTokenRepository");
            if (autologinTokenRepository == null) {
                throw new Exception("AutologinTokenRepository bean not found");
            }
            autologinTokenRepository.removeExpiredTokens();
            if (log.isDebugEnabled()) {
                log.debug("Expired tokens remover job finished");
            }
        }
        catch (Exception e) {
            log.error("Error while removeing expired autologin tokens");
        }
    }
}

