/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.reports.TreeReportModel;

@Controller
@RequestMapping(value={"/reports/medals-for-clubs"})
public class MedalsForClubsReportController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, @ModelAttribute(value="medalsForClubs") TreeReportModel medalsForClubs) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("medalsForClubsActive", (Object)true);
        LinkedHashMap<String, String> documentTypes = new LinkedHashMap<String, String>();
        documentTypes.put(DocumentType.PDF.name(), this.getLanguageText(locale, "report.documentType.PDF"));
        documentTypes.put(DocumentType.ODT.name(), this.getLanguageText(locale, "report.documentType.ODT"));
        model.addAttribute("documentTypes", documentTypes);
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        locales.put("en", this.getLanguageText(locale, "locale.english"));
        locales.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        model.addAttribute("locales", locales);
        medalsForClubs.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage());
        return "reports/medals-for-clubs";
    }

    @RequestMapping(method={RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="medalsForClubs") TreeReportModel medalsForClubs) throws IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getManagersList().getCompetitionManager().getById(this.getUserData().getCompetition().getCompetitionId());
        if (competition == null) {
            return;
        }
        String fileName = this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "report.filename.medalsForClubs");
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        fileName = fileName.replace(' ', '_');
        if (medalsForClubs.getDocumentType() == DocumentType.PDF) {
            response.setContentType("application/pdf");
            fileName = fileName + ".pdf";
        } else if (medalsForClubs.getDocumentType() == DocumentType.ODT) {
            response.setContentType("application/vnd.oasis.opendocument.text");
            fileName = fileName + ".odt";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (medalsForClubs.getLocale() != null) {
            locale = new Locale(medalsForClubs.getLocale());
        }
        ServletOutputStream outputStream = response.getOutputStream();
        this.getManagersList().getReportGenerator().generateMedalsForClubs(medalsForClubs.getDocumentType(), locale, (OutputStream)outputStream, competition);
        outputStream.close();
    }
}

