/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.text.Normalizer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.TatamiModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/tatamis"})
@SessionAttributes(value={"tatamiListFilter"})
public class TatamisController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TatamisController.class);

    @ModelAttribute(value="tatamisActive")
    public Boolean getTatamisActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="tatamiListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.TATAMIEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="tatamiListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Tatami example = new Tatami();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getTatamiManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("tatamis", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "tatamis.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "tatamis.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "tatamis.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "tatamis.text.categoriesSet"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "tatamis.text.imported"));
        }
        return "data/tatami-list";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="tatami") TatamiModel tatamiModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        return "data/tatami-edit";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="tatami") @Valid TatamiModel tatamiModel, BindingResult bindingResult) {
        if (tatamiModel.getPassword() == null || tatamiModel.getPassword().isEmpty()) {
            bindingResult.rejectValue("password", "common.error.dataNotEntered");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, tatamiModel, bindingResult);
        }
        Tatami tatami = new Tatami();
        ObjectUtil.copyNotNullProperties((Object)tatamiModel, (Object)tatami);
        tatami.setCompetition(this.getUserData().getCompetition());
        if (tatami.getDisplayText() == null || tatami.getDisplayText().isEmpty()) {
            tatami.setDisplayText(tatami.getName());
        }
        tatami = this.getManagersList().getTatamiManager().createTatami(tatami);
        return "redirect:/data/tatamis?messageCode=1";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/edit/{tatamiId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="tatamiId") Long tatamiId, @ModelAttribute(value="tatami") TatamiModel tatamiModel, BindingResult bindingResult) {
        Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)tatami, (Object)tatamiModel);
        tatamiModel.setPassword("");
        return "data/tatami-edit";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/edit/{tatamiId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="tatamiId") Long tatamiId, @ModelAttribute(value="tatami") @Valid TatamiModel tatamiModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, tatamiId, tatamiModel, bindingResult);
        }
        Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)tatamiModel, (Object)tatami);
        if (tatami.getDisplayText() == null || tatami.getDisplayText().isEmpty()) {
            tatami.setDisplayText(tatami.getName());
        }
        tatami = this.getManagersList().getTatamiManager().updateTatami(tatami);
        if (tatamiModel.getPassword() != null && !tatamiModel.getPassword().isEmpty()) {
            tatami.setPassword(tatamiModel.getPassword());
            this.getManagersList().getTatamiManager().updateTatamiPassword(tatami);
        }
        return "redirect:/data/tatamis?messageCode=2";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/delete/{tatamiId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="tatamiId") Long tatamiId) {
        Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getTatamiManager().deleteTatami(tatami);
        return "redirect:/data/tatamis?messageCode=3";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/categories/{tatamiId}"}, method={RequestMethod.GET})
    public String categories(HttpServletRequest request, Model model, @PathVariable(value="tatamiId") Long tatamiId) {
        Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        model.addAttribute("tatami", (Object)tatami);
        HashSet<Long> currentCategories = new HashSet<Long>();
        for (Category category : this.getManagersList().getTatamiManager().getCategoriesForTatami(tatami)) {
            currentCategories.add(category.getCategoryId());
        }
        model.addAttribute("currentCategories", currentCategories);
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("categories", (Object)dataResult.getData());
        return "data/tatami-categories";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/categories/{tatamiId}"}, method={RequestMethod.POST})
    public String categoriesPost(HttpServletRequest request, Model model, @PathVariable(value="tatamiId") Long tatamiId) {
        Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        HashSet<Category> categories = new HashSet<Category>();
        Map parameters = request.getParameterMap();
        for (String key : parameters.keySet()) {
            if (!key.startsWith("category_")) continue;
            Long categoryId = Long.parseLong(key.split("_")[1]);
            Category category = new Category();
            category.setCategoryId(categoryId);
            categories.add(category);
        }
        this.getManagersList().getTatamiManager().setCategoriesForTatami(tatami, categories);
        return "redirect:/data/tatamis?messageCode=4";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/tatami-import";
    }

    @MethodRight(value={Right.TATAMIEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            List tatamis = this.getManagersList().getTatamiImporter().parseTatamis(importDataModel.getFileType(), importDataModel.getFile().getBytes());
            this.getManagersList().getTatamiImporter().importTatamis(this.getUserData().getCompetition(), tatamis);
            return "redirect:/data/tatamis?messageCode=5";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoTatamiName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "tatamis.error.noTatamiName"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoTatamiPassword) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "tatamis.error.noTatamiPassword"));
                return this.importData(request, model, importDataModel);
            }
            LOGGER.error("Error while reading tatami data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "tatamis.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading tatami data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "tatamis.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "tatamis.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        List tatamis = this.getManagersList().getTatamiManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        String[] header = new String[]{this.getLanguageText(locale, "tatamis.export.tatami"), this.getLanguageText(locale, "tatamis.export.password"), this.getLanguageText(locale, "tatamis.export.displayAs")};
        try {
            byte[] data = this.getManagersList().getTatamiImporter().exportTatamis(fileType, tatamis, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writeing to output stream", (Throwable)e);
        }
    }
}

