/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import si.nevensrok.common.web.BaseController;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.ManagersList;
import si.nevensrok.jtekma.server.web.common.UserData;
import si.nevensrok.jtekma.server.web.tools.Tools;

public abstract class CoreController
extends BaseController {
    private ManagersList managersList;
    private UserData userData;
    private Tools tools;

    public void setManagersList(ManagersList managersList) {
        this.managersList = managersList;
    }

    public ManagersList getManagersList() {
        return this.managersList;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setTools(Tools tools) {
        this.tools = tools;
    }

    public Tools getTools() {
        return this.tools;
    }

    public Role getCompetitionRole() {
        User user = this.userData.getLoginedUser();
        Competition competition = this.userData.getCompetition();
        if (user == null) {
            return null;
        }
        if (competition == null) {
            return null;
        }
        CompetitionRole competitionRole = this.getManagersList().getUserManager().getRoleForUser(user, competition);
        if (competitionRole == null) {
            return null;
        }
        return competitionRole.getRole();
    }

    public boolean hasRights(Right right) {
        User user = this.userData.getLoginedUser();
        if (user == null) {
            return false;
        }
        if (user.getIsSuperAdmin() != null && user.getIsSuperAdmin().booleanValue()) {
            return true;
        }
        return this.getManagersList().getRightManager().hasRights(this.getCompetitionRole(), right);
    }
}

