/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.common.competition;

import java.io.Serializable;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.web.common.competition.Competitor;

public class Duo2023Table
implements Serializable {
    private static final long serialVersionUID = 6921742249820040910L;
    private Round round;
    private Rank rank;
    private Integer groupNumber;
    private Boolean notNeeded;
    private Row[] rows;

    public Duo2023Table() {
    }

    public Duo2023Table(DuoTable duoTable) {
        this.round = duoTable.getRound();
        this.rank = duoTable.getRank();
        this.groupNumber = duoTable.getGroupNumber();
        this.notNeeded = false;
        if (duoTable.getRows() == null) {
            this.rows = new Row[0];
        } else {
            this.rows = new Row[duoTable.getRows().size()];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                if (((DuoTable.Row)duoTable.getRows().get(i)).getCompetitor() != null) {
                    this.rows[i].setCompetitor(new Competitor(((DuoTable.Row)duoTable.getRows().get(i)).getCompetitor()));
                }
                this.rows[i].setPoints(Float.valueOf(((DuoTable.Row)duoTable.getRows().get(i)).getPoints()));
                this.rows[i].setPlacing(((DuoTable.Row)duoTable.getRows().get(i)).getPlacing());
            }
        }
    }

    public Round getRound() {
        return this.round;
    }

    public void setRound(Round round) {
        this.round = round;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(Integer groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Boolean getNotNeeded() {
        return this.notNeeded;
    }

    public void setNotNeeded(Boolean notNeeded) {
        this.notNeeded = notNeeded;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public void setRows(Row[] rows) {
        this.rows = rows;
    }

    public String toString() {
        return new ObjectToString(Duo2023Table.class).addProperty("round", (Object)this.round).addProperty("rank", (Object)this.rank).addProperty("groupNumber", (Object)this.groupNumber).addProperty("notNeeded", (Object)this.notNeeded).addProperty("rows", (Object[])this.rows).generateString();
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = 2924737813084078174L;
        private Competitor competitor;
        private Float points;
        private Integer placing;

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(Competitor competitor) {
            this.competitor = competitor;
        }

        public Float getPoints() {
            return this.points;
        }

        public void setPoints(Float points) {
            this.points = points;
        }

        public Integer getPlacing() {
            return this.placing;
        }

        public void setPlacing(Integer placing) {
            this.placing = placing;
        }

        public String toString() {
            return new ObjectToString(Row.class).addProperty("competitor", (Object)this.competitor).addProperty("points", (Object)this.points).addProperty("placing", (Object)this.placing).generateString();
        }
    }
}

