/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.ContainerTabOrder;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class TraversalEngine {
    static final Algorithm DEFAULT_ALGORITHM = PlatformImpl.isContextual2DNavigation() ? new Hueristic2D() : new ContainerTabOrder();
    private final TraversalContext context = new EngineContext();
    private final TempEngineContext tempEngineContext = new TempEngineContext();
    protected final Algorithm algorithm;
    private final Bounds initialBounds = new BoundingBox(0.0, 0.0, 1.0, 1.0);
    private final ArrayList<TraverseListener> listeners = new ArrayList();

    protected TraversalEngine(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    protected TraversalEngine() {
        this.algorithm = null;
    }

    public final void addTraverseListener(TraverseListener listener) {
        this.listeners.add(listener);
    }

    final void notifyTraversedTo(Node newNode) {
        for (TraverseListener l : this.listeners) {
            l.onTraverse(newNode, this.getLayoutBounds(newNode, this.getRoot()));
        }
    }

    public final Node select(Node from, Direction dir) {
        return this.algorithm.select(from, dir, this.context);
    }

    public final Node selectFirst() {
        return this.algorithm.selectFirst(this.context);
    }

    public final Node selectLast() {
        return this.algorithm.selectLast(this.context);
    }

    protected abstract Parent getRoot();

    public final boolean canTraverse() {
        return this.algorithm != null;
    }

    private Bounds getLayoutBounds(Node n, Parent forParent) {
        Bounds bounds = n != null ? (forParent == null ? n.localToScene(n.getLayoutBounds()) : forParent.sceneToLocal(n.localToScene(n.getLayoutBounds()))) : this.initialBounds;
        return bounds;
    }

    private abstract class BaseEngineContext
    implements TraversalContext {
        private BaseEngineContext() {
        }

        @Override
        public List<Node> getAllTargetNodes() {
            ArrayList<Node> targetNodes = new ArrayList<Node>();
            this.addFocusableChildrenToList(targetNodes, this.getRoot());
            return targetNodes;
        }

        @Override
        public Bounds getSceneLayoutBounds(Node n) {
            return TraversalEngine.this.getLayoutBounds(n, null);
        }

        private void addFocusableChildrenToList(List<Node> list, Parent parent) {
            ObservableList<Node> parentsNodes = parent.getChildrenUnmodifiable();
            for (Node n : parentsNodes) {
                if (n.isFocusTraversable() && !n.isFocused() && n.impl_isTreeVisible() && !n.isDisabled()) {
                    list.add(n);
                }
                if (!(n instanceof Parent)) continue;
                this.addFocusableChildrenToList(list, (Parent)n);
            }
        }

        @Override
        public Node selectFirstInParent(Parent parent) {
            TraversalEngine.this.tempEngineContext.setRoot(parent);
            return DEFAULT_ALGORITHM.selectFirst(TraversalEngine.this.tempEngineContext);
        }

        @Override
        public Node selectLastInParent(Parent parent) {
            TraversalEngine.this.tempEngineContext.setRoot(parent);
            return DEFAULT_ALGORITHM.selectLast(TraversalEngine.this.tempEngineContext);
        }

        @Override
        public Node selectInSubtree(Parent subTreeRoot, Node from, Direction dir) {
            TraversalEngine.this.tempEngineContext.setRoot(subTreeRoot);
            return DEFAULT_ALGORITHM.select(from, dir, TraversalEngine.this.tempEngineContext);
        }
    }

    private final class TempEngineContext
    extends BaseEngineContext {
        private Parent root;

        private TempEngineContext() {
        }

        @Override
        public Parent getRoot() {
            return this.root;
        }

        public void setRoot(Parent root) {
            this.root = root;
        }
    }

    private final class EngineContext
    extends BaseEngineContext {
        private EngineContext() {
        }

        @Override
        public Parent getRoot() {
            return TraversalEngine.this.getRoot();
        }
    }
}

