/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.buffer;

public class ReadByteBuffer {
    private byte[] buffer;
    private int position = 0;

    public ReadByteBuffer(byte[] bytes) {
        this.buffer = bytes;
    }

    public synchronized byte get() {
        if (this.position >= this.buffer.length) {
            throw new IllegalStateException("Buffer is empty");
        }
        return this.buffer[this.position++];
    }

    public synchronized byte[] get(int length) {
        if (this.position >= this.buffer.length) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.position + length > this.buffer.length) {
            throw new IllegalStateException("Not enough space available in buffer");
        }
        byte[] data = new byte[length];
        System.arraycopy(this.buffer, this.position, data, 0, length);
        this.position += length;
        return data;
    }

    public synchronized void get(byte[] data) {
        this.get(data, 0, data.length);
    }

    public synchronized void get(byte[] data, int offset, int length) {
        if (this.position >= this.buffer.length) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.position + length > this.buffer.length) {
            throw new IllegalStateException("Not enough space available in buffer");
        }
        System.arraycopy(this.buffer, this.position, data, offset, length);
        this.position += length;
    }

    public boolean isBufferEmpty() {
        return this.position >= this.buffer.length;
    }

    public int getDataAvailable() {
        return this.buffer.length - this.position;
    }
}

