/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPresentationPenaltyDocument;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationJudgePoints;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPresentationPointsPanel
extends JPanel
implements DuoPointsPanel {
    private JPanel pointDetailPanel = new JPanel();
    private MatchData matchData;
    private DuoPresentationJudgePoints[] judgePoints = new DuoPresentationJudgePoints[3];
    private JLabel pointsSum = new JLabel("0");
    private JLabel penaltyLabel = new JLabel("Penalty");
    private JTextField penaltyTextField = new JTextField("0");
    private DuoPresentationPoints duoPresentationPoints;
    private TablaManager tablaManager;
    private boolean documentForFieldsSet = false;

    public DuoPresentationPointsPanel() {
        this.setLayout(null);
        this.add(this.pointDetailPanel);
        this.pointDetailPanel.setLayout(new GridLayout(2, 2));
        this.judgePoints[0] = new DuoPresentationJudgePoints(1);
        this.judgePoints[1] = new DuoPresentationJudgePoints(2);
        this.judgePoints[2] = new DuoPresentationJudgePoints(3);
        this.pointDetailPanel.add(this.judgePoints[0]);
        this.pointDetailPanel.add(this.pointsSum);
        this.pointDetailPanel.add(this.judgePoints[1]);
        this.pointDetailPanel.add(this.judgePoints[2]);
        this.pointsSum.setHorizontalAlignment(0);
        this.penaltyTextField.setHorizontalAlignment(0);
        this.add(this.penaltyLabel);
        this.add(this.penaltyTextField);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setDuoPresentationPoints(duoPresentationPoints);
        }
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setTablaManager(tablaManager);
        }
        this.setDocumentForFields();
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setWindowKeyListener(windowKeyListener);
        }
        this.penaltyTextField.addKeyListener(windowKeyListener);
    }

    public void setDuoFieldSelector() {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.setDuoFieldSelector(this);
        }
    }

    private void setDocumentForFields() {
        if (this.duoPresentationPoints == null || this.tablaManager == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        this.penaltyTextField.setDocument(new DuoPresentationPenaltyDocument(this.duoPresentationPoints, this.tablaManager));
    }

    public void redrawElements() {
        final int width = this.getWidth();
        final int height = this.getHeight();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pointDetailHeight = (int)Math.floor((float)height * 0.9f);
                DuoPresentationPointsPanel.this.pointDetailPanel.setLocation(0, 0);
                DuoPresentationPointsPanel.this.pointDetailPanel.setSize(width, pointDetailHeight);
                int penaltyLabelWidth = (int)Math.floor((float)height * 0.4f);
                int penaltyHeight = height - pointDetailHeight;
                DuoPresentationPointsPanel.this.penaltyLabel.setLocation(0, pointDetailHeight);
                DuoPresentationPointsPanel.this.penaltyLabel.setSize(penaltyLabelWidth, penaltyHeight);
                DuoPresentationPointsPanel.this.penaltyTextField.setLocation(penaltyLabelWidth, pointDetailHeight);
                DuoPresentationPointsPanel.this.penaltyTextField.setSize(width - penaltyLabelWidth, penaltyHeight);
                DuoPresentationPointsPanel.this.penaltyLabel.setText(DuoPresentationPointsPanel.this.tablaManager.getLanguageText("text.penalty"));
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.pointsSum);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.penaltyLabel);
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.penaltyTextField);
                DuoPresentationPointsPanel.this.repaint();
            }
        });
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.redrawElements();
        }
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPresentationPointsPanel.this.pointsSum.setText(Constants.FIGHT_POINTS_FORMAT.format(points));
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPresentationPointsPanel.this.pointsSum);
            }
        });
    }

    @Override
    public void resetPoints() {
        for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
            duoPresentationJudgePoints.resetPoints();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DuoPresentationPointsPanel.this.duoPresentationPoints != null) {
                    DuoPresentationPointsPanel.this.penaltyTextField.setText(Constants.FIGHT_POINTS_FORMAT.format(DuoPresentationPointsPanel.this.duoPresentationPoints.getPenalty()));
                }
            }
        });
    }

    @Override
    public void selectFirstField() {
        this.selectField(1);
    }

    @Override
    public void selectPrevField() {
        int selected = this.getSelectedField() - 1;
        if (selected < 1) {
            selected = 72;
        }
        if (this.matchData.getRound() == Round.ROUND_1 || this.matchData.getRound() == Round.ROUND_2 || this.matchData.getRound() == Round.ROUND_3) {
            if (selected >= 17 && selected <= 24) {
                selected = 16;
            } else if (selected >= 41 && selected <= 48) {
                selected = 40;
            } else if (selected >= 65 && selected <= 72) {
                selected = 64;
            }
        }
        this.selectField(selected);
    }

    @Override
    public void selectNextField() {
        int selected = this.getSelectedField() + 1;
        if (selected > 72) {
            selected = 1;
        }
        if (this.matchData.getRound() == Round.ROUND_1 || this.matchData.getRound() == Round.ROUND_2 || this.matchData.getRound() == Round.ROUND_3) {
            if (selected >= 17 && selected <= 24) {
                selected = 25;
            } else if (selected >= 41 && selected <= 48) {
                selected = 49;
            } else if (selected >= 65 && selected <= 72) {
                selected = 1;
            }
        }
        this.selectField(selected);
    }

    @Override
    public void recalculateRoundPoints() {
    }

    public void selectField(int index) {
        int judge = (index - 1) / 24;
        this.judgePoints[judge].selectField((index - 1) % 24 + 1);
    }

    public int getSelectedField() {
        for (int i = 0; i < this.judgePoints.length; ++i) {
            int n = this.judgePoints[i].getSelectedField();
            if (n <= 0) continue;
            return i * 24 + n;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setBackground(bg);
        }
        if (this.judgePoints != null) {
            for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
                if (duoPresentationJudgePoints == null) continue;
                duoPresentationJudgePoints.setBackground(bg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setBackground(bg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setForeground(fg);
        }
        if (this.judgePoints != null) {
            for (DuoPresentationJudgePoints duoPresentationJudgePoints : this.judgePoints) {
                if (duoPresentationJudgePoints == null) continue;
                duoPresentationJudgePoints.setForeground(fg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setForeground(fg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setForeground(fg);
        }
    }
}

