/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duo2023;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.Duo2023PenaltyDocument;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023FieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023JudgePoints;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class Duo2023PointsPanel
extends JPanel
implements DuoPointsPanel {
    private JPanel pointDetailPanel = new JPanel();
    private MatchData matchData;
    private Duo2023JudgePoints[] judgePoints = new Duo2023JudgePoints[3];
    private JLabel pointsSum = new JLabel("0");
    private JLabel penaltyLabel = new JLabel("Penalty");
    private JTextField penaltyTextField = new JTextField("0");
    private CompetitorType competitorType;
    private Duo2023Points duo2023Points;
    private TablaManager tablaManager;
    private boolean documentForFieldsSet = false;

    public Duo2023PointsPanel(CompetitorType competitorType) {
        this.competitorType = competitorType;
        this.setLayout(null);
        this.add(this.pointDetailPanel);
        this.pointDetailPanel.setLayout(new GridLayout(2, 2));
        this.judgePoints[0] = new Duo2023JudgePoints(competitorType, 1);
        this.judgePoints[1] = new Duo2023JudgePoints(competitorType, 2);
        this.judgePoints[2] = new Duo2023JudgePoints(competitorType, 3);
        this.pointDetailPanel.add(this.judgePoints[0]);
        this.pointDetailPanel.add(this.pointsSum);
        this.pointDetailPanel.add(this.judgePoints[1]);
        this.pointDetailPanel.add(this.judgePoints[2]);
        this.pointsSum.setHorizontalAlignment(0);
        this.penaltyTextField.setHorizontalAlignment(0);
        this.add(this.penaltyLabel);
        this.add(this.penaltyTextField);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023Points = duo2023Points;
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.setDuo2023Points(duo2023Points);
        }
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.setTablaManager(tablaManager);
        }
        this.setDocumentForFields();
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.setWindowKeyListener(windowKeyListener);
        }
        this.penaltyTextField.addKeyListener(windowKeyListener);
    }

    public void setDuoFieldSelector(Duo2023FieldSelector duo2023FieldSelector) {
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.setDuoFieldSelector(duo2023FieldSelector);
        }
    }

    private void setDocumentForFields() {
        if (this.duo2023Points == null || this.tablaManager == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        this.penaltyTextField.setDocument(new Duo2023PenaltyDocument(this.competitorType, this.duo2023Points, this.tablaManager));
    }

    public void redrawElements() {
        final int width = this.getWidth();
        final int height = this.getHeight();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int pointDetailHeight = (int)Math.floor((float)height * 0.92f);
                Duo2023PointsPanel.this.pointDetailPanel.setLocation(0, 0);
                Duo2023PointsPanel.this.pointDetailPanel.setSize(width, pointDetailHeight);
                int penaltyLabelWidth = (int)Math.floor((float)height * 0.4f);
                int penaltyHeight = height - pointDetailHeight;
                Duo2023PointsPanel.this.penaltyLabel.setLocation(0, pointDetailHeight);
                Duo2023PointsPanel.this.penaltyLabel.setSize(penaltyLabelWidth, penaltyHeight);
                Duo2023PointsPanel.this.penaltyTextField.setLocation(penaltyLabelWidth, pointDetailHeight);
                Duo2023PointsPanel.this.penaltyTextField.setSize(width - penaltyLabelWidth, penaltyHeight);
                Duo2023PointsPanel.this.penaltyLabel.setText(Duo2023PointsPanel.this.tablaManager.getLanguageText("text.penalty"));
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsPanel.this.pointsSum);
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsPanel.this.penaltyLabel);
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsPanel.this.penaltyTextField);
                Duo2023PointsPanel.this.repaint();
            }
        });
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.redrawElements();
        }
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Duo2023PointsPanel.this.pointsSum.setText(Constants.FIGHT_POINTS_FORMAT.format(points));
                FontSizeUtil.refitFontSize(Constants.FONT, Duo2023PointsPanel.this.pointsSum);
            }
        });
    }

    @Override
    public void resetPoints() {
        for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
            duo2023JudgePoints.resetPoints();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Duo2023PointsPanel.this.competitorType == CompetitorType.COMPETITOR1) {
                    Duo2023PointsPanel.this.penaltyTextField.setText(Constants.FIGHT_POINTS_FORMAT.format(Duo2023PointsPanel.this.duo2023Points.getPenalty1()));
                } else if (Duo2023PointsPanel.this.competitorType == CompetitorType.COMPETITOR2) {
                    Duo2023PointsPanel.this.penaltyTextField.setText(Constants.FIGHT_POINTS_FORMAT.format(Duo2023PointsPanel.this.duo2023Points.getPenalty2()));
                }
            }
        });
    }

    @Override
    public void selectFirstField() {
        this.selectField(1);
    }

    @Override
    public void selectPrevField() {
    }

    @Override
    public void selectNextField() {
    }

    @Override
    public void recalculateRoundPoints() {
    }

    public void selectField(int index) {
        int judge = (index - 1) / 24;
        this.judgePoints[judge].selectField((index - 1) % 24 + 1);
    }

    public int getSelectedField() {
        for (int i = 0; i < this.judgePoints.length; ++i) {
            int n = this.judgePoints[i].getSelectedField();
            if (n <= 0) continue;
            return i * 24 + n;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setBackground(bg);
        }
        if (this.judgePoints != null) {
            for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
                if (duo2023JudgePoints == null) continue;
                duo2023JudgePoints.setBackground(bg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setBackground(bg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointDetailPanel != null) {
            this.pointDetailPanel.setForeground(fg);
        }
        if (this.judgePoints != null) {
            for (Duo2023JudgePoints duo2023JudgePoints : this.judgePoints) {
                if (duo2023JudgePoints == null) continue;
                duo2023JudgePoints.setForeground(fg);
            }
        }
        if (this.pointsSum != null) {
            this.pointsSum.setForeground(fg);
        }
        if (this.penaltyLabel != null) {
            this.penaltyLabel.setForeground(fg);
        }
    }
}

