/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;

public class DuoPresentationPoints
implements Serializable {
    private static final long serialVersionUID = -2472505575589345038L;
    private int[][][] points = new int[3][6][4];
    private int penalty = 0;
    private List<DuoPresentationAttack> attacks = new ArrayList<DuoPresentationAttack>();

    public List<DuoPresentationAttack> getAttacks() {
        return this.attacks;
    }

    public int getPoints(int judge, int row, int part) {
        return this.points[judge - 1][row - 1][part - 1];
    }

    public void setPoints(int judge, int row, int part, int p) {
        this.points[judge - 1][row - 1][part - 1] = p;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int p) {
        this.penalty = p;
    }

    public int getSum() {
        int sum = 0;
        for (int judge = 1; judge <= 3; ++judge) {
            for (int attack = 1; attack <= 6; ++attack) {
                for (int part = 1; part <= 4; ++part) {
                    sum += this.points[judge - 1][attack - 1][part - 1];
                }
            }
        }
        if ((sum -= this.penalty) < 0) {
            sum = 0;
        }
        return sum;
    }

    public Set<DuoPresentationPoint> getMatchPoints(List<DuoPresentationAttack> attacks) {
        HashSet<DuoPresentationPoint> duoPresentationPoints = new HashSet<DuoPresentationPoint>();
        for (int judge = 1; judge <= 3; ++judge) {
            for (int row = 0; row < attacks.size(); ++row) {
                DuoPresentationAttack duoPresentationAttack = attacks.get(row);
                for (int part = 1; part <= 4; ++part) {
                    DuoPresentationPoint duoPresentationPoint = new DuoPresentationPoint();
                    duoPresentationPoint.setType(DuoPresentationPoint.Type.POINTS);
                    duoPresentationPoint.setJudge(Integer.valueOf(judge));
                    duoPresentationPoint.setSeries(Series.valueOf((String)duoPresentationAttack.getSeries().name()));
                    duoPresentationPoint.setAttack(duoPresentationAttack.getAttack());
                    duoPresentationPoint.setPart(Integer.valueOf(part));
                    duoPresentationPoint.setPoints(Float.valueOf(this.points[judge - 1][row][part - 1]));
                    duoPresentationPoints.add(duoPresentationPoint);
                }
            }
        }
        DuoPresentationPoint penaltyPoint = new DuoPresentationPoint();
        penaltyPoint.setType(DuoPresentationPoint.Type.PENALTY);
        penaltyPoint.setPoints(Float.valueOf(this.penalty));
        duoPresentationPoints.add(penaltyPoint);
        return duoPresentationPoints;
    }

    public void setAttacks(Collection<DuoPresentationAttack> attacks) {
        this.attacks = new ArrayList<DuoPresentationAttack>(attacks);
    }

    public void setMatchPoints(Set<DuoPresentationPoint> duoPresentationPoints, Collection<DuoPresentationAttack> attacks) {
        int judge;
        this.attacks = new ArrayList<DuoPresentationAttack>(attacks);
        for (judge = 1; judge <= 3; ++judge) {
            for (int row = 0; row < 6; ++row) {
                for (int part = 1; part <= 4; ++part) {
                    this.points[judge - 1][row][part - 1] = 0;
                }
            }
        }
        for (judge = 1; judge <= 3; ++judge) {
            int j = judge;
            for (int row = 0; row < attacks.size(); ++row) {
                DuoPresentationAttack duoPresentationAttack = this.attacks.get(row);
                for (int part = 1; part <= 4; ++part) {
                    int p = part;
                    DuoPresentationPoint duoPresentationPoint = duoPresentationPoints.stream().filter(dp -> dp.getType() == DuoPresentationPoint.Type.POINTS && dp.getJudge() == j && dp.getSeries().name().equals(duoPresentationAttack.getSeries().name()) && dp.getAttack().intValue() == duoPresentationAttack.getAttack().intValue() && dp.getPart() == p).findFirst().orElse(null);
                    if (duoPresentationPoint == null) continue;
                    this.points[judge - 1][row][part - 1] = duoPresentationPoint.getPoints().intValue();
                }
            }
        }
        DuoPresentationPoint penaltyPoint = duoPresentationPoints.stream().filter(dp -> dp.getType() == DuoPresentationPoint.Type.PENALTY).findFirst().orElse(null);
        this.penalty = penaltyPoint != null ? penaltyPoint.getPoints().intValue() : 0;
    }

    public String toString() {
        return new ObjectToString(DuoPresentationPoints.class).addProperty("points", (Object[])this.points).addProperty("penalty", this.penalty).addProperty("attacks", this.attacks).generateString();
    }
}

