(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	models.DuoTableModel = Backbone.Model.extend({
		"defaults": {
			"rows": null
		}
	});

	models.DuoTableCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/duo-tables";
        },
        "model": models.DuoTableModel
    });

    views.DuoTablesView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/duo-tables"),
        "initialize": function() {
            this.model.duoTables.on("reset", function() {
                this.renderDuoTables();
            }, this);
            this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
            this.render();
        },
        "render": function() {
            var category = jtekma.displaySettings.get("category");
        	var draw2023Options = category.get("draw2023Options");

            var data = {
                "knockout": draw2023Options.knockoutStage
            };
            $(this.el).html(Mustache.render(this.template, data));

            $("#round1").hide();
            $("#round2").hide();
            $("#round3").hide();
            $("#round4").hide();
            $("#round5").hide();
            $("#knockout").hide();

            $("#roundButtons label", this.el).on("click", function() {
                $("#round1").hide();
                $("#round2").hide();
                $("#round3").hide();
                $("#round4").hide();
                $("#round5").hide();
                $("#knockout").hide();
                jtekma.displaySettings.set("duo2023DisplayTab", $(this).attr("link"));
                $("#" + $(this).attr("link")).show();
            });

            var duo2023DisplayTab = jtekma.displaySettings.get("duo2023DisplayTab");
            if (!isTextEmpty(duo2023DisplayTab)) {
                var button = $("label[link='" + duo2023DisplayTab + "']");
                if (button.length > 0) {
                    button.click();
                }
                else {
                    $("#roundButtons label:first").click();
                }
            }
            else {
                $("#roundButtons label:first").click();
            }

            return this;
        },
        "renderDuoTables": function() {
            $(".duo-table-div").html("");
            this.model.duoTables.each(function(duoTable, index) {
                if (duoTable.get("notNeeded")) {
                    return;
                }
                var renderElement = null;
                if (duoTable.get("round") == "ROUND_1") {
                    if (duoTable.get("rank") == "WORLD_LEVEL") {
                        renderElement = $("#round1ws" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "ADVANCED") {
                        renderElement = $("#round1adv" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "NOVICE") {
                        renderElement = $("#round1nov" + String(duoTable.get("groupNumber")));
                    }
                }
                else if (duoTable.get("round") == "ROUND_2") {
                    if (duoTable.get("rank") == "WORLD_LEVEL") {
                        renderElement = $("#round2ws" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "ADVANCED") {
                        renderElement = $("#round2adv" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "NOVICE") {
                        renderElement = $("#round2nov" + String(duoTable.get("groupNumber")));
                    }
                }
                else if (duoTable.get("round") == "ROUND_3") {
                    if (duoTable.get("rank") == "WORLD_LEVEL") {
                        renderElement = $("#round3ws" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "ADVANCED") {
                        renderElement = $("#round3adv" + String(duoTable.get("groupNumber")));
                    }
                    else if (duoTable.get("rank") == "NOVICE") {
                        renderElement = $("#round3nov" + String(duoTable.get("groupNumber")));
                    }
                }
                else if (duoTable.get("round") == "ROUND_4") {
                    if (duoTable.get("rank") == "WORLD_LEVEL") {
                        renderElement = $("#round4ws");
                    }
                    else if (duoTable.get("rank") == "ADVANCED") {
                        renderElement = $("#round4adv");
                    }
                    else if (duoTable.get("rank") == "NOVICE") {
                        renderElement = $("#round4nov");
                    }
                }
                else if (duoTable.get("round") == "ROUND_5") {
                    if (duoTable.get("rank") == "WORLD_LEVEL") {
                        renderElement = $("#round5ws");
                    }
                    else if (duoTable.get("rank") == "ADVANCED") {
                        renderElement = $("#round5adv");
                    }
                    else if (duoTable.get("rank") == "NOVICE") {
                        renderElement = $("#round5nov");
                    }
                }
                if (isNull(renderElement)) {
                    return;
                }
                var duoTableView = new views.DuoTableView({
                    "el": renderElement,
                    "model": duoTable
                });
                duoTableView.render();
            });
        },
        "renderMatches": function() {
            $("#knockout").html("");

            var category = jtekma.displaySettings.get("category");
            var draw2023Options = category.get("draw2023Options");

            $("#knockout").attr("style", "width:770px;height:560px;");
            for (var i = 1; i <= 4; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 1) * 80 + 40) + "px;"
                    }
                });
                $("#knockout").append(matchView.render().el);
            }
            for (var i = 5; i <= 6; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:" + String((i - 5) * 160 + 80)+"px;"
                    }
                });
                $("#knockout").append(matchView.render().el);
            }
            for (var i = 8; i <= 8; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:500px;top:" + String((i - 8) * 80 + 160) + "px;"
                    }
                });
                $("#knockout").append(matchView.render().el);
            }
            if (!draw2023Options.double3rdPlace) {
                for (var i = 7; i <= 7; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:500px;top:" + String((i - 7) * 80 + 430) + "px;"
                        }
                    });
                    $("#knockout").append(matchView.render().el);
                }
            }
        }
    });

	views.DuoTableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/duo-table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var duoTableData = this.model.toJSON();
			$(this.el).html(Mustache.render(this.template, duoTableData));
			return this;
		}
	});

})();