/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import si.nevensrok.common.comparators.IntegerComparator;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.BorderMargin;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Heading;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.PageSize;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.VerticalAlignment;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.MapUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.CompetitorRanking;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.CompetitorPlacingData;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.MatchTreeImageGenerator;
import si.nevensrok.jtekma.server.reports.impl.MedalsCount;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;

public class DocumentGenerator {
    private static final DecimalFormat COMPETITOR_RANKING_POINTS_FORMAT;
    private MessageLoader messageLoader;
    private MatchTreeImageGenerator matchTreeImageGenerator;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setMatchTreeImageGenerator(MatchTreeImageGenerator matchTreeImageGenerator) {
        this.matchTreeImageGenerator = matchTreeImageGenerator;
    }

    public Document generateClubPlacingsDocument(Locale locale, List<PlacingData> placings) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "clubPlacing.title"), Heading.HeadingType.H1));
        for (PlacingData placingData : placings) {
            StringBuilder line = new StringBuilder();
            line.append(placingData.getPlacing());
            line.append(". ");
            line.append(placingData.getName());
            line.append(", ");
            line.append(placingData.getPoints());
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "clubPlacing.points"));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateCompetitorPlacingsDocument(Locale locale, List<CategoryPlacingData> categoryPlacingDataList, boolean oneCategoryPerPage) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryPlacingData categoryPlacingData : categoryPlacingDataList) {
            if (firstCategory) {
                firstCategory = false;
            } else if (oneCategoryPerPage) {
                document.addContent((Content)new PageBreak());
            }
            document.addContent((Content)new Heading(categoryPlacingData.getCategoryName(), Heading.HeadingType.H1));
            if (CollectionUtil.isNotEmpty(categoryPlacingData.getPlacingDatas())) {
                for (PlacingData placingData : categoryPlacingData.getPlacingDatas()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryPlacingData.getPlacingsForRanks())) continue;
            for (Map.Entry entry : categoryPlacingData.getPlacingsForRanks().entrySet()) {
                Rank rank = (Rank)entry.getKey();
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : (List)entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    public Document generateTreeReport(Locale locale, List<CategoryData> categoryDatas, boolean empty) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryData categoryData : categoryDatas) {
            if (firstCategory) {
                firstCategory = false;
            } else if (categoryData.getMatchDatas().size() == 28) {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            } else {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            }
            document.addContent((Content)new Heading(categoryData.getCategoryName(), Heading.HeadingType.H1));
            String[][] tableContent = categoryData.getTableContent();
            if (tableContent != null && (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5)) {
                void var14_55;
                Table table = new Table();
                document.addContent((Content)table);
                float fontSize = 8.0f;
                TableRow tableRow = new TableRow();
                table.addTableRow(tableRow);
                TableCell tableCell = new TableCell();
                tableCell.setWidth(7.0f);
                Paragraph competitorParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph.setFontSize(Float.valueOf(fontSize));
                competitorParagraph.setBold(Boolean.TRUE);
                tableCell.addContent(competitorParagraph);
                tableRow.addTableCell(tableCell);
                boolean bl = true;
                while (var14_55 <= 5) {
                    TableCell matchTableCell = new TableCell();
                    matchTableCell.setWidth(3.0f);
                    matchTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph matchParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.match") + " " + (int)var14_55);
                    matchParagraph.setFontSize(Float.valueOf(fontSize));
                    matchParagraph.setBold(Boolean.TRUE);
                    matchParagraph.setAlignment(Alignment.CENTER);
                    matchTableCell.addContent(matchParagraph);
                    tableRow.addTableCell(matchTableCell);
                    ++var14_55;
                }
                TableCell tableCell2 = new TableCell();
                tableCell2.setWidth(3.0f);
                tableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph winsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.wins"));
                winsParagraph.setFontSize(Float.valueOf(fontSize));
                winsParagraph.setBold(Boolean.TRUE);
                winsParagraph.setAlignment(Alignment.CENTER);
                tableCell2.addContent(winsParagraph);
                tableRow.addTableCell(tableCell2);
                TableCell fiWinsTableCell = new TableCell();
                fiWinsTableCell.setWidth(3.0f);
                fiWinsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph fiWinsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.fiWins"));
                fiWinsParagraph.setFontSize(Float.valueOf(fontSize));
                fiWinsParagraph.setBold(Boolean.TRUE);
                fiWinsParagraph.setAlignment(Alignment.CENTER);
                fiWinsTableCell.addContent(fiWinsParagraph);
                tableRow.addTableCell(fiWinsTableCell);
                TableCell pointsTableCell = new TableCell();
                pointsTableCell.setWidth(3.0f);
                pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph.setFontSize(Float.valueOf(fontSize));
                pointsParagraph.setBold(Boolean.TRUE);
                pointsParagraph.setAlignment(Alignment.CENTER);
                pointsTableCell.addContent(pointsParagraph);
                tableRow.addTableCell(pointsTableCell);
                for (String[] stringArray : tableContent) {
                    TableRow tableRow2 = new TableRow();
                    table.addTableRow(tableRow2);
                    TableCell competitorTableCell2 = new TableCell();
                    competitorTableCell2.setWidth(7.0f);
                    Paragraph competitorParagraph2 = new Paragraph((String)stringArray[0]);
                    competitorParagraph2.setFontSize(Float.valueOf(fontSize));
                    competitorTableCell2.addContent(competitorParagraph2);
                    tableRow2.addTableCell(competitorTableCell2);
                    for (int i = 1; i <= 5; ++i) {
                        TableCell matchTableCell = new TableCell();
                        matchTableCell.setWidth(3.0f);
                        Paragraph matchParagraph = new Paragraph((String)stringArray[i]);
                        matchParagraph.setFontSize(Float.valueOf(fontSize));
                        matchParagraph.setAlignment(Alignment.CENTER);
                        matchTableCell.addContent(matchParagraph);
                        tableRow2.addTableCell(matchTableCell);
                    }
                    TableCell winsTableCell2 = new TableCell();
                    winsTableCell2.setWidth(3.0f);
                    Paragraph winsParagraph2 = new Paragraph((String)stringArray[6]);
                    winsParagraph2.setFontSize(Float.valueOf(fontSize));
                    winsParagraph2.setAlignment(Alignment.CENTER);
                    winsTableCell2.addContent(winsParagraph2);
                    tableRow2.addTableCell(winsTableCell2);
                    TableCell fiWinsTableCell2 = new TableCell();
                    fiWinsTableCell2.setWidth(3.0f);
                    Paragraph fiWinsParagraph2 = new Paragraph((String)stringArray[7]);
                    fiWinsParagraph2.setFontSize(Float.valueOf(fontSize));
                    fiWinsParagraph2.setAlignment(Alignment.CENTER);
                    fiWinsTableCell2.addContent(fiWinsParagraph2);
                    tableRow2.addTableCell(fiWinsTableCell2);
                    TableCell pointsTableCell2 = new TableCell();
                    pointsTableCell2.setWidth(3.0f);
                    Paragraph pointsParagraph2 = new Paragraph((String)stringArray[8]);
                    pointsParagraph2.setFontSize(Float.valueOf(fontSize));
                    pointsParagraph2.setAlignment(Alignment.CENTER);
                    pointsTableCell2.addContent(pointsParagraph2);
                    tableRow2.addTableCell(pointsTableCell2);
                }
            }
            boolean duoTablesAdded = false;
            Map<Round, Map<Rank, Map<Integer, String[][]>>> duoTable = categoryData.getDuoTableContent();
            if (MapUtil.isNotEmpty(duoTable)) {
                for (Map.Entry entry : duoTable.entrySet()) {
                    if (MapUtil.isEmpty((Map)((Map)entry.getValue()))) continue;
                    duoTablesAdded = true;
                    Round round = (Round)entry.getKey();
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.round") + " " + String.valueOf(round.ordinal() + 1), Heading.HeadingType.H2));
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        Rank rank = (Rank)entry2.getKey();
                        if (rank == Rank.WORLD_LEVEL) {
                            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                        } else if (rank == Rank.ADVANCED) {
                            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                        } else if (rank == Rank.NOVICE) {
                            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                        }
                        for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                            Integer groupNumber = (Integer)entry3.getKey();
                            String[][] tableData = (String[][])entry3.getValue();
                            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.group") + " " + Character.toString((char)(64 + groupNumber)), Heading.HeadingType.H4));
                            Table table = new Table();
                            document.addContent((Content)table);
                            float fontSize = 8.0f;
                            TableRow tableRow = new TableRow();
                            table.addTableRow(tableRow);
                            TableCell competitorTableCell = new TableCell();
                            competitorTableCell.setWidth(7.0f);
                            Paragraph competitorParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                            competitorParagraph.setFontSize(Float.valueOf(fontSize));
                            competitorParagraph.setBold(Boolean.TRUE);
                            competitorTableCell.addContent(competitorParagraph);
                            tableRow.addTableCell(competitorTableCell);
                            TableCell pointsTableCell = new TableCell();
                            pointsTableCell.setWidth(3.0f);
                            pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                            Paragraph pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                            pointsParagraph.setFontSize(Float.valueOf(fontSize));
                            pointsParagraph.setBold(Boolean.TRUE);
                            pointsParagraph.setAlignment(Alignment.CENTER);
                            pointsTableCell.addContent(pointsParagraph);
                            tableRow.addTableCell(pointsTableCell);
                            for (String[] row2 : tableData) {
                                TableRow tableRow3 = new TableRow();
                                table.addTableRow(tableRow3);
                                TableCell competitorTableCell3 = new TableCell();
                                competitorTableCell3.setWidth(7.0f);
                                Paragraph competitorParagraph3 = new Paragraph(row2[0]);
                                competitorParagraph3.setFontSize(Float.valueOf(fontSize));
                                competitorTableCell3.addContent(competitorParagraph3);
                                tableRow3.addTableCell(competitorTableCell3);
                                TableCell pointsTableCell3 = new TableCell();
                                pointsTableCell3.setWidth(3.0f);
                                Paragraph pointsParagraph3 = new Paragraph(row2[1]);
                                pointsParagraph3.setFontSize(Float.valueOf(fontSize));
                                pointsParagraph3.setAlignment(Alignment.CENTER);
                                pointsTableCell3.addContent(pointsParagraph3);
                                tableRow3.addTableCell(pointsTableCell3);
                            }
                        }
                    }
                }
            }
            if (MapUtil.isNotEmpty(categoryData.getMatchDataForRank())) {
                if (duoTablesAdded) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "competitors.knockout"), Heading.HeadingType.H2));
                for (Map.Entry entry : categoryData.getMatchDataForRank().entrySet()) {
                    void var14_61;
                    if (entry.getKey() == Rank.WORLD_LEVEL) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.ADVANCED) {
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.NOVICE) {
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                    }
                    boolean displayQuarterFinals = false;
                    boolean bl = false;
                    while (var14_61 < 4) {
                        MatchData matchData = (MatchData)((List)entry.getValue()).get((int)var14_61);
                        if (StringUtil.isNotEmpty((String)matchData.getCompetitor1()) && StringUtil.isNotEmpty((String)matchData.getCompetitor2())) {
                            displayQuarterFinals = true;
                            break;
                        }
                        ++var14_61;
                    }
                    BufferedImage bufferedImage = this.matchTreeImageGenerator.generateDuoKnockoutMatches((List)entry.getValue(), displayQuarterFinals, categoryData.isDisplay3rdPlaceMatch());
                    Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                    imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                    document.addContent((Content)imageContent);
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getMatchDatas())) {
                if (!categoryData.isCustom()) {
                    BufferedImage image;
                    if (categoryData.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        image = this.matchTreeImageGenerator.generateBestOf3Fights(categoryData.getMatchDatas());
                        Image image2 = new Image(image, Alignment.CENTER);
                        image2.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)image2);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        image = this.matchTreeImageGenerator.generateTableFights(categoryData.getMatchDatas());
                        Image image3 = new Image(image, Alignment.CENTER);
                        image3.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)image3);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE4) {
                        boolean display3rdplace = categoryData.isDisplay3rdPlaceMatch();
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.NONE) {
                            display3rdplace = false;
                        }
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree4Fights(categoryData.getMatchDatas(), display3rdplace);
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE8) {
                        boolean displayRepassage = categoryData.getRepassageType() != TreeCategory.RepassageType.NONE;
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree8Fights(categoryData.getMatchDatas(), displayRepassage, categoryData.isDisplay3rdPlaceMatch());
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE16) {
                        image = this.matchTreeImageGenerator.generateTree16Fights(categoryData.getMatchDatas());
                        Image image4 = new Image(image, Alignment.CENTER);
                        image4.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image4);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage")));
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree16RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            Image image5 = new Image(imageRepasague, Alignment.CENTER);
                            image5.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)image5);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE32) {
                        image = this.matchTreeImageGenerator.generateTree32Fights(categoryData.getMatchDatas());
                        Image image6 = new Image(image, Alignment.CENTER);
                        image6.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image6);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree32RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            Image image7 = new Image(bufferedImage, Alignment.CENTER);
                            document.addContent((Content)image7);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE64) {
                        Paragraph firstPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.firstPart"));
                        firstPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)firstPartParagraph);
                        BufferedImage bufferedImage = this.matchTreeImageGenerator.generateTree64_1Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(bufferedImage, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        Paragraph paragraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.secondPart"));
                        paragraph.setBold(Boolean.TRUE);
                        document.addContent((Content)paragraph);
                        BufferedImage bufferedImage2 = this.matchTreeImageGenerator.generateTree64_2Fights(categoryData.getMatchDatas());
                        imageContent = new Image(bufferedImage2, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageFirstPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree64_1RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageSecondPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            imageRepasague = this.matchTreeImageGenerator.generateTree64_2RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                        }
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            Paragraph forThirdParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.forThirdPlace"));
                            forThirdParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)forThirdParagraph);
                            BufferedImage bufferedImage3 = this.matchTreeImageGenerator.generateTree64ForThirdFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(bufferedImage3, Alignment.LEFT);
                            imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                            document.addContent((Content)imageContent);
                        }
                        Paragraph finalsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.finals"));
                        finalsParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)finalsParagraph);
                        BufferedImage bufferedImage4 = this.matchTreeImageGenerator.generateTree64FinalsFights(categoryData.getMatchDatas());
                        imageContent = new Image(bufferedImage4, Alignment.LEFT);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                } else {
                    LinkedList<MatchData> matchesLeft = new LinkedList<MatchData>(categoryData.getMatchDatas());
                    LinkedList<MatchData> linkedList = new LinkedList<MatchData>();
                    while (!matchesLeft.isEmpty()) {
                        linkedList.add(matchesLeft.poll());
                        if (linkedList.size() != 3) continue;
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(linkedList);
                        Image image8 = new Image(image, Alignment.CENTER);
                        image8.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image8);
                        linkedList.clear();
                    }
                    if (!linkedList.isEmpty()) {
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(linkedList);
                        Image image9 = new Image(image, Alignment.CENTER);
                        image9.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)image9);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getPlacingDatas())) {
                if (categoryData.getPlacingDatas().size() > 16 && categoryData.getPlacingDatas().size() < 33) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
                placingParagraph.setBold(Boolean.TRUE);
                document.addContent((Content)placingParagraph);
                for (PlacingData placingData : categoryData.getPlacingDatas()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(placingData.getPlacing());
                    stringBuilder.append(". ");
                    stringBuilder.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(stringBuilder.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryData.getPlacingsForRanks())) continue;
            Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
            placingParagraph.setBold(Boolean.TRUE);
            document.addContent((Content)placingParagraph);
            for (Map.Entry<Rank, List<PlacingData>> entry : categoryData.getPlacingsForRanks().entrySet()) {
                Rank rank = entry.getKey();
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    public Document generateCompetitorRankingDocument(Locale locale, List<CompetitorRanking> competitorRankings, List<CompetitorRanking> coupleRankings) {
        Paragraph paragraph;
        StringBuilder line;
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "competitorRanking.title"), Heading.HeadingType.H1));
        for (CompetitorRanking competitorRanking : competitorRankings) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitorRanking.getCompetitor();
            line = new StringBuilder();
            line.append(competitorRanking.getPlace());
            line.append(". ");
            line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
            line.append(", ");
            line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
            paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "coupleRanking.title"), Heading.HeadingType.H1));
        for (CompetitorRanking competitorRanking : coupleRankings) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorRanking.getCompetitor();
            line = new StringBuilder();
            line.append(competitorRanking.getPlace());
            line.append(". ");
            line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
            line.append(", ");
            line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
            paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateResultsForClubDocument(Locale locale, List<CompetitorPlacingData> competitorPlacingDataList, Map<Integer, Integer> placingCount) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.title"), Heading.HeadingType.H1));
        for (CompetitorPlacingData competitorPlacingData : competitorPlacingDataList) {
            StringBuilder line = new StringBuilder();
            line.append(competitorPlacingData.getCategory().getName());
            line.append(" - ");
            if (competitorPlacingData.getRank() != null) {
                if (competitorPlacingData.getRank() == Rank.WORLD_LEVEL) {
                    line.append(this.messageLoader.getMessage(locale, "table.worldLevel"));
                } else if (competitorPlacingData.getRank() == Rank.ADVANCED) {
                    line.append(this.messageLoader.getMessage(locale, "table.advancedLevel"));
                } else if (competitorPlacingData.getRank() == Rank.NOVICE) {
                    line.append(this.messageLoader.getMessage(locale, "table.noviceLevel"));
                }
                line.append(" ");
            }
            line.append(competitorPlacingData.getPlacing());
            line.append(". ");
            if (competitorPlacingData.getCompetitor() instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitorPlacingData.getCompetitor();
                line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
            } else if (competitorPlacingData.getCompetitor() instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorPlacingData.getCompetitor();
                line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
            }
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.placingsCount"), Heading.HeadingType.H1));
        ArrayList<Integer> placingList = new ArrayList<Integer>(placingCount.keySet());
        Collections.sort(placingList, new IntegerComparator());
        for (Integer placing : placingList) {
            StringBuilder line = new StringBuilder();
            line.append(placing);
            line.append(". ");
            line.append(this.messageLoader.getMessage(locale, "resultsForClub.placing"));
            line.append(" - ");
            line.append(placingCount.get(placing));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateMedalsForClubsDocument(Locale locale, List<MedalsCount> medalsCountList) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "medalsForClubs.title"), Heading.HeadingType.H1));
        Table table = new Table();
        TableRow header = new TableRow();
        header.addTableCell(DocumentGenerator.geenrateTableCell("", Alignment.CENTER, 3.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.club"), Alignment.LEFT, 10.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.firstPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.secondPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.thirdPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.total"), Alignment.CENTER, 7.0f));
        table.addTableRow(header);
        for (MedalsCount medalsCount : medalsCountList) {
            TableRow tableRow = new TableRow();
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getPlacing()), Alignment.CENTER, 3.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(medalsCount.getClub().getName(), Alignment.LEFT, 10.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getFirstPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getSecondPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getThirdPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getTotal()), Alignment.CENTER, 7.0f));
            table.addTableRow(tableRow);
        }
        document.addContent((Content)table);
        return document;
    }

    private static TableCell geenrateTableCell(String text, Alignment alignment, float width) {
        TableCell tableCell = new TableCell(text, alignment);
        tableCell.setWidth(width);
        return tableCell;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        COMPETITOR_RANKING_POINTS_FORMAT = new DecimalFormat("0.00#");
    }
}

