/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.utils.NumberUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.updaters.Duo2023PlacingCalculator;

public class Duo2023Updater {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;
    private MatchManager matchManager;
    private Duo2023PlacingCalculator duo2023PlacingCalculator;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setDuo2023PlacingCalculator(Duo2023PlacingCalculator duo2023PlacingCalculator) {
        this.duo2023PlacingCalculator = duo2023PlacingCalculator;
    }

    public void updateDuo2023Category(Duo2023Category duo2023Category) {
        this.calculateDuoTables(duo2023Category, true);
    }

    public List<DuoTable> getDuoTables(Duo2023Category duo2023Category) {
        return this.calculateDuoTables(duo2023Category, false);
    }

    private List<DuoTable> calculateDuoTables(Duo2023Category duo2023Category, boolean update) {
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)duo2023Category);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        Map draw = this.categoryManager.getGroupDraw((Category)duo2023Category);
        LinkedList<DuoTable> duoTables = new LinkedList<DuoTable>();
        List duoPresentations = this.duoPresentationManager.getDuoPresentationsForCategory((Category)duo2023Category);
        for (DuoPresentation duoPresentation : duoPresentations) {
            duoPresentation.setGroupNumber(null);
            duoPresentation.setGroupPosition(Integer.valueOf(0));
        }
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap<Integer, Set<MatchPoint>> matchPoints = new HashMap<Integer, Set<MatchPoint>>();
        for (Match match : this.matchManager.getMatchesForCategory((Category)duo2023Category)) {
            matches.put(match.getFightNumber(), match);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), (Set<MatchPoint>)entry.getValue());
        }
        DuoTable round1ws1 = new DuoTable(Round.ROUND_1, Rank.WORLD_LEVEL, Integer.valueOf(1));
        DuoTable duoTable = new DuoTable(Round.ROUND_1, Rank.WORLD_LEVEL, Integer.valueOf(2));
        DuoTable round1ws3 = new DuoTable(Round.ROUND_1, Rank.WORLD_LEVEL, Integer.valueOf(3));
        DuoTable round1ws4 = new DuoTable(Round.ROUND_1, Rank.WORLD_LEVEL, Integer.valueOf(4));
        DuoTable[] round1ws = new DuoTable[]{round1ws1, duoTable, round1ws3, round1ws4};
        for (Map.Entry entry : draw.entrySet()) {
            Competitor competitor = (Competitor)entry.getKey();
            round1ws[((GroupDraw)entry.getValue()).getDrawGroup() - 1].addCompetitor(competitor);
        }
        for (DuoTable duoTable2 : round1ws) {
            duoTables.add(duoTable2);
            if (duoTable2.getRows() == null) {
                duoTable2.setRows(new LinkedList());
            }
            this.processDuoTable(competitionRules, duo2023Category, duoTable2, duoPresentations, 4, update);
        }
        DuoTable round1adv1 = new DuoTable(Round.ROUND_1, Rank.ADVANCED, Integer.valueOf(1));
        DuoTable round1adv2 = new DuoTable(Round.ROUND_1, Rank.ADVANCED, Integer.valueOf(2));
        DuoTable round1adv3 = new DuoTable(Round.ROUND_1, Rank.ADVANCED, Integer.valueOf(3));
        DuoTable round1adv4 = new DuoTable(Round.ROUND_1, Rank.ADVANCED, Integer.valueOf(4));
        DuoTable[] round1adv = new DuoTable[]{round1adv1, round1adv2, round1adv3, round1adv4};
        if (duo2023Category.getAdvancedLevel().booleanValue()) {
            for (int i = 0; i < round1adv.length; ++i) {
                DuoTable duoTableAdv = round1adv[i];
                duoTables.add(duoTableAdv);
                if (round1ws1.isFinished() && duoTable.isFinished() && round1ws3.isFinished() && round1ws4.isFinished()) {
                    for (int j = 0; j < 100; j += 4) {
                        int n = (i + j * 4) % 4;
                        duoTableAdv.addCompetitor(round1ws[n].getLoser(j));
                        n = (i + 1 + j * 4) % 4;
                        duoTableAdv.addCompetitor(round1ws[n].getLoser(j + 1));
                        n = (i + 2 + j * 4) % 4;
                        duoTableAdv.addCompetitor(round1ws[n].getLoser(j + 2));
                        n = (i + 3 + j * 4) % 4;
                        duoTableAdv.addCompetitor(round1ws[n].getLoser(j + 3));
                    }
                    this.processDuoTable(competitionRules, duo2023Category, duoTableAdv, duoPresentations, 2, update);
                }
                if (!round1ws1.isNotNeeded() || !duoTable.isNotNeeded() || !round1ws3.isNotNeeded() || !round1ws4.isNotNeeded()) continue;
                duoTableAdv.setNotNeeded(true);
            }
        }
        DuoTable round1nov1 = new DuoTable(Round.ROUND_1, Rank.NOVICE, Integer.valueOf(1));
        DuoTable round1nov2 = new DuoTable(Round.ROUND_1, Rank.NOVICE, Integer.valueOf(2));
        DuoTable[] round1nov = new DuoTable[]{round1nov1, round1nov2};
        if (duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue()) {
            for (int i = 0; i < round1nov.length; ++i) {
                DuoTable duoTableNov = round1nov[i];
                duoTables.add(duoTableNov);
                if (round1adv1.isFinished() && round1adv2.isFinished() && round1adv3.isFinished() && round1adv4.isFinished()) {
                    for (int j = 0; j < 100; j += 2) {
                        int n = i;
                        duoTableNov.addCompetitor(round1adv[n].getLoser(j));
                        n = i + 2;
                        duoTableNov.addCompetitor(round1adv[n].getLoser(j));
                        n = 1 - i;
                        duoTableNov.addCompetitor(round1adv[n].getLoser(j + 1));
                        n = 3 - i;
                        duoTableNov.addCompetitor(round1adv[n].getLoser(j + 1));
                    }
                    this.processDuoTable(competitionRules, duo2023Category, duoTableNov, duoPresentations, 4, update);
                }
                if (!round1adv1.isNotNeeded() || !round1adv2.isNotNeeded() || !round1adv3.isNotNeeded() || !round1adv4.isNotNeeded()) continue;
                duoTableNov.setNotNeeded(true);
            }
        }
        DuoTable round2ws1 = new DuoTable(Round.ROUND_2, Rank.WORLD_LEVEL, Integer.valueOf(1));
        DuoTable round2ws2 = new DuoTable(Round.ROUND_2, Rank.WORLD_LEVEL, Integer.valueOf(2));
        DuoTable round2ws3 = new DuoTable(Round.ROUND_2, Rank.WORLD_LEVEL, Integer.valueOf(3));
        DuoTable round2ws4 = new DuoTable(Round.ROUND_2, Rank.WORLD_LEVEL, Integer.valueOf(4));
        DuoTable[] round2ws = new DuoTable[]{round2ws1, round2ws2, round2ws3, round2ws4};
        for (int i = 0; i < round2ws.length; ++i) {
            DuoTable duoTable2Ws = round2ws[i];
            duoTables.add(duoTable2Ws);
            if (!round1ws1.isFinished() || !duoTable.isFinished() || !round1ws3.isFinished() || !round1ws4.isFinished()) continue;
            int n = i;
            duoTable2Ws.addCompetitor(round1ws[n].getWinner(0));
            n = (i + 1) % 4;
            duoTable2Ws.addCompetitor(round1ws[n].getWinner(1));
            n = (i + 2) % 4;
            duoTable2Ws.addCompetitor(round1ws[n].getWinner(2));
            n = (i + 3) % 4;
            duoTable2Ws.addCompetitors((Collection)round1ws[n].getWinners(3));
            if (duoTable2Ws.getRows() == null) {
                duoTable2Ws.setRows(new LinkedList());
            }
            this.processDuoTable(competitionRules, duo2023Category, duoTable2Ws, duoPresentations, 2, update);
        }
        DuoTable round2adv1 = new DuoTable(Round.ROUND_2, Rank.ADVANCED, Integer.valueOf(1));
        DuoTable round2adv2 = new DuoTable(Round.ROUND_2, Rank.ADVANCED, Integer.valueOf(2));
        DuoTable round2adv3 = new DuoTable(Round.ROUND_2, Rank.ADVANCED, Integer.valueOf(3));
        DuoTable round2adv4 = new DuoTable(Round.ROUND_2, Rank.ADVANCED, Integer.valueOf(4));
        DuoTable[] round2adv = new DuoTable[]{round2adv1, round2adv2, round2adv3, round2adv4};
        if (duo2023Category.getAdvancedLevel().booleanValue()) {
            for (int i = 0; i < round2adv.length; ++i) {
                DuoTable duoTable2Adv = round2adv[i];
                duoTables.add(duoTable2Adv);
                if (round1adv1.isFinished() && round1adv2.isFinished() && round1adv3.isFinished() && round1adv4.isFinished() && round2ws1.isFinished() && round2ws2.isFinished() && round2ws3.isFinished() && round2ws4.isFinished()) {
                    int n = i;
                    duoTable2Adv.addCompetitor(round1adv[n].getWinner(0));
                    n = (i + 2) % 4;
                    duoTable2Adv.addCompetitor(round1adv[n].getWinner(1));
                    n = i < 2 ? (i + 1) % 2 : (i + 1) % 2 + 2;
                    duoTable2Adv.addCompetitor(round2ws[n].getLoser(0));
                    n = i < 2 ? (i + 1) % 2 + 2 : (i + 1) % 2;
                    duoTable2Adv.addCompetitors((Collection)round2ws[n].getLosers(1));
                    this.processDuoTable(competitionRules, duo2023Category, duoTable2Adv, duoPresentations, 2, update);
                }
                if (!round2ws1.isNotNeeded() || !round2ws2.isNotNeeded() || !round2ws3.isNotNeeded() || !round2ws4.isNotNeeded()) continue;
                duoTable2Adv.setNotNeeded(true);
            }
        }
        DuoTable round2nov1 = new DuoTable(Round.ROUND_2, Rank.NOVICE, Integer.valueOf(1));
        DuoTable round2nov2 = new DuoTable(Round.ROUND_2, Rank.NOVICE, Integer.valueOf(2));
        if (duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue()) {
            duoTables.add(round2nov1);
            duoTables.add(round2nov2);
            if (round1nov1.isFinished() && round1nov2.isFinished() && round2adv1.isFinished() && round2adv2.isFinished() && round2adv3.isFinished() && round2adv4.isFinished()) {
                round2nov1.addCompetitor(round1nov1.getWinner(0));
                round2nov1.addCompetitor(round1nov2.getWinner(1));
                round2nov1.addCompetitor(round1nov1.getWinner(2));
                round2nov1.addCompetitors((Collection)round1nov2.getWinners(3));
                round2nov1.addCompetitor(round2adv4.getLoser(0));
                round2nov1.addCompetitor(round2adv2.getLoser(0));
                round2nov1.addCompetitors((Collection)round2adv3.getLosers(1));
                round2nov1.addCompetitors((Collection)round2adv1.getLosers(1));
                round2nov2.addCompetitor(round1nov2.getWinner(0));
                round2nov2.addCompetitor(round1nov1.getWinner(1));
                round2nov2.addCompetitor(round1nov2.getWinner(2));
                round2nov2.addCompetitors((Collection)round1nov1.getWinners(3));
                round2nov2.addCompetitor(round2adv3.getLoser(0));
                round2nov2.addCompetitor(round2adv1.getLoser(0));
                round2nov2.addCompetitors((Collection)round2adv4.getLosers(1));
                round2nov2.addCompetitors((Collection)round2adv2.getLosers(1));
                this.processDuoTable(competitionRules, duo2023Category, round2nov1, duoPresentations, 4, update);
                this.processDuoTable(competitionRules, duo2023Category, round2nov2, duoPresentations, 4, update);
            }
            if (round2adv1.isNotNeeded() && round2adv2.isNotNeeded() && round2adv3.isNotNeeded() && round2adv4.isNotNeeded()) {
                round2nov1.setNotNeeded(true);
                round2nov2.setNotNeeded(true);
            }
        }
        DuoTable round3ws1 = new DuoTable(Round.ROUND_3, Rank.WORLD_LEVEL, Integer.valueOf(1));
        DuoTable round3ws2 = new DuoTable(Round.ROUND_3, Rank.WORLD_LEVEL, Integer.valueOf(2));
        duoTables.add(round3ws1);
        duoTables.add(round3ws2);
        if (round2ws1.isFinished() && round2ws2.isFinished() && round2ws3.isFinished() && round2ws4.isFinished()) {
            round3ws1.addCompetitor(round2ws1.getWinner(0));
            round3ws1.addCompetitor(round2ws3.getWinner(0));
            round3ws1.addCompetitors((Collection)round2ws2.getWinners(1));
            round3ws1.addCompetitors((Collection)round2ws4.getWinners(1));
            round3ws2.addCompetitor(round2ws2.getWinner(0));
            round3ws2.addCompetitor(round2ws4.getWinner(0));
            round3ws2.addCompetitors((Collection)round2ws3.getWinners(1));
            round3ws2.addCompetitors((Collection)round2ws1.getWinners(1));
            if (round3ws1.getRows() == null) {
                round3ws1.setRows(new LinkedList());
            }
            if (round3ws2.getRows() == null) {
                round3ws2.setRows(new LinkedList());
            }
            this.processDuoTable(competitionRules, duo2023Category, round3ws1, duoPresentations, 2, update);
            this.processDuoTable(competitionRules, duo2023Category, round3ws2, duoPresentations, 2, update);
        }
        DuoTable round3adv1 = new DuoTable(Round.ROUND_3, Rank.ADVANCED, Integer.valueOf(1));
        DuoTable round3adv2 = new DuoTable(Round.ROUND_3, Rank.ADVANCED, Integer.valueOf(2));
        if (duo2023Category.getAdvancedLevel().booleanValue()) {
            duoTables.add(round3adv1);
            duoTables.add(round3adv2);
            if (round2adv1.isFinished() && round2adv2.isFinished() && round2adv3.isFinished() && round2adv4.isFinished() && round3ws1.isFinished() && round3ws2.isFinished()) {
                round3adv1.addCompetitor(round2adv1.getWinner(0));
                round3adv1.addCompetitor(round2adv3.getWinner(0));
                round3adv1.addCompetitors((Collection)round2adv2.getWinners(1));
                round3adv1.addCompetitors((Collection)round2adv4.getWinners(1));
                round3adv1.addCompetitor(round3ws1.getLoser(0));
                round3adv1.addCompetitors((Collection)round3ws2.getLosers(1));
                round3adv2.addCompetitor(round2adv2.getWinner(0));
                round3adv2.addCompetitor(round2adv4.getWinner(0));
                round3adv2.addCompetitors((Collection)round2adv3.getWinners(1));
                round3adv2.addCompetitors((Collection)round2adv1.getWinners(1));
                round3adv2.addCompetitor(round3ws2.getLoser(0));
                round3adv2.addCompetitors((Collection)round3ws1.getLosers(1));
                this.processDuoTable(competitionRules, duo2023Category, round3adv1, duoPresentations, 2, update);
                this.processDuoTable(competitionRules, duo2023Category, round3adv2, duoPresentations, 2, update);
            }
            if (round3ws1.isNotNeeded() && round3ws2.isNotNeeded()) {
                round3adv1.setNotNeeded(true);
                round3adv2.setNotNeeded(true);
            }
        }
        DuoTable round3nov1 = new DuoTable(Round.ROUND_3, Rank.NOVICE, Integer.valueOf(1));
        DuoTable round3nov2 = new DuoTable(Round.ROUND_3, Rank.NOVICE, Integer.valueOf(2));
        if (duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue()) {
            duoTables.add(round3nov1);
            duoTables.add(round3nov2);
            if (round2nov1.isFinished() && round2nov2.isFinished() && round3adv1.isFinished() && round3adv2.isFinished()) {
                round3nov1.addCompetitor(round2nov2.getWinner(0));
                round3nov1.addCompetitor(round2nov1.getWinner(1));
                round3nov1.addCompetitor(round2nov2.getWinner(2));
                round3nov1.addCompetitors((Collection)round2nov1.getWinners(3));
                round3nov1.addCompetitor(round3adv2.getLoser(0));
                round3nov1.addCompetitor(round3adv1.getLoser(1));
                round3nov1.addCompetitor(round3adv2.getLoser(2));
                round3nov1.addCompetitors((Collection)round3adv1.getLosers(3));
                round3nov2.addCompetitor(round2nov1.getWinner(0));
                round3nov2.addCompetitor(round2nov2.getWinner(1));
                round3nov2.addCompetitor(round2nov1.getWinner(2));
                round3nov2.addCompetitors((Collection)round2nov2.getWinners(3));
                round3nov2.addCompetitor(round3adv1.getLoser(0));
                round3nov2.addCompetitor(round3adv2.getLoser(1));
                round3nov2.addCompetitor(round3adv1.getLoser(2));
                round3nov2.addCompetitors((Collection)round3adv2.getLosers(3));
                this.processDuoTable(competitionRules, duo2023Category, round3nov1, duoPresentations, 2, update);
                this.processDuoTable(competitionRules, duo2023Category, round3nov2, duoPresentations, 2, update);
            }
            if (round3adv1.isNotNeeded() && round3adv2.isNotNeeded()) {
                round3nov1.setNotNeeded(true);
                round3nov2.setNotNeeded(true);
            }
        }
        if (duo2023Category.getKnockoutStage().booleanValue()) {
            this.processKnockoutStage(update, competitionRules, matches, matchPoints, duo2023Category, 0, round3ws1, round3ws2);
            if (duo2023Category.getAdvancedLevel().booleanValue()) {
                this.processKnockoutStage(update, competitionRules, matches, matchPoints, duo2023Category, 8, round3adv1, round3adv2);
                if (duo2023Category.getNoviceLevel().booleanValue()) {
                    this.processKnockoutStage(update, competitionRules, matches, matchPoints, duo2023Category, 16, round3nov1, round3nov2);
                }
            }
        } else {
            DuoTable round4ws = new DuoTable(Round.ROUND_4, Rank.WORLD_LEVEL, Integer.valueOf(1));
            duoTables.add(round4ws);
            if (round3ws1.isFinished() && round3ws2.isFinished()) {
                round4ws.addCompetitor(round3ws1.getWinner(0));
                round4ws.addCompetitor(round3ws2.getWinner(0));
                round4ws.addCompetitors((Collection)round3ws1.getWinners(1));
                round4ws.addCompetitors((Collection)round3ws2.getWinners(1));
                if (round4ws.getRows() == null) {
                    round4ws.setRows(new LinkedList());
                }
                this.processDuoTable(competitionRules, duo2023Category, round4ws, duoPresentations, 2, update);
            }
            DuoTable round4adv = new DuoTable(Round.ROUND_4, Rank.ADVANCED, Integer.valueOf(1));
            if (duo2023Category.getAdvancedLevel().booleanValue()) {
                duoTables.add(round4adv);
                if (round3adv1.isFinished() && round3adv2.isFinished()) {
                    round4adv.addCompetitor(round3adv1.getWinner(0));
                    round4adv.addCompetitor(round3adv2.getWinner(0));
                    round4adv.addCompetitors((Collection)round3adv1.getWinners(1));
                    round4adv.addCompetitors((Collection)round3adv2.getWinners(1));
                    this.processDuoTable(competitionRules, duo2023Category, round4adv, duoPresentations, 2, update);
                }
                if (round4ws.isNotNeeded()) {
                    round4adv.setNotNeeded(true);
                }
            }
            DuoTable round4nov = new DuoTable(Round.ROUND_4, Rank.NOVICE, Integer.valueOf(1));
            if (duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue()) {
                duoTables.add(round4nov);
                if (round3nov1.isFinished() && round3nov2.isFinished()) {
                    round4nov.addCompetitor(round3nov1.getWinner(0));
                    round4nov.addCompetitor(round3nov2.getWinner(0));
                    round4nov.addCompetitors((Collection)round3nov1.getWinners(1));
                    round4nov.addCompetitors((Collection)round3nov2.getWinners(1));
                    this.processDuoTable(competitionRules, duo2023Category, round4nov, duoPresentations, 2, update);
                }
                if (round4adv.isNotNeeded()) {
                    round4nov.setNotNeeded(true);
                }
            }
            DuoTable round5ws = new DuoTable(Round.ROUND_5, Rank.WORLD_LEVEL, Integer.valueOf(1));
            duoTables.add(round5ws);
            if (round4ws.isFinished()) {
                round5ws.addCompetitor(round4ws.getWinner(0));
                round5ws.addCompetitors((Collection)round4ws.getWinners(1));
                this.processDuoTable(competitionRules, duo2023Category, round5ws, duoPresentations, 1, update);
            }
            DuoTable round5adv = new DuoTable(Round.ROUND_5, Rank.ADVANCED, Integer.valueOf(1));
            if (duo2023Category.getAdvancedLevel().booleanValue()) {
                duoTables.add(round5adv);
                if (round4adv.isFinished()) {
                    round5adv.addCompetitor(round4adv.getWinner(0));
                    round5adv.addCompetitors((Collection)round4adv.getWinners(1));
                    this.processDuoTable(competitionRules, duo2023Category, round5adv, duoPresentations, 1, update);
                }
            }
            DuoTable round5nov = new DuoTable(Round.ROUND_5, Rank.NOVICE, Integer.valueOf(1));
            if (duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue()) {
                duoTables.add(round5nov);
                if (round4nov.isFinished()) {
                    round5nov.addCompetitor(round4nov.getWinner(0));
                    round5nov.addCompetitors((Collection)round4nov.getWinners(1));
                    this.processDuoTable(competitionRules, duo2023Category, round5nov, duoPresentations, 1, update);
                }
            }
        }
        if (update) {
            this.duoPresentationManager.updateDuoPresentationAdvancementData((Collection)duoPresentations);
            this.matchManager.updateMatchTreeAdvancmentData(matches.values());
        }
        if (update) {
            Map<Competitor, Integer> worldLevelPlacings = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTables, Rank.WORLD_LEVEL);
            this.categoryManager.setPlacings((Category)duo2023Category, worldLevelPlacings, Rank.WORLD_LEVEL);
            Map<Competitor, Integer> advancedPlacings = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTables, Rank.ADVANCED);
            this.categoryManager.setPlacings((Category)duo2023Category, advancedPlacings, Rank.ADVANCED);
            Map<Competitor, Integer> novicePlacings = this.duo2023PlacingCalculator.calculatePlacings(duo2023Category, duoTables, Rank.NOVICE);
            this.categoryManager.setPlacings((Category)duo2023Category, novicePlacings, Rank.NOVICE);
        }
        return duoTables;
    }

    private DuoPresentation getOrCreateDuoPresentation(List<DuoPresentation> duoPresentations, Competitor competitor, DuoTable duoTable, Duo2023Category duo2023Category, int groupPosition) {
        DuoPresentation duoPresentation = duoPresentations.stream().filter(dp -> competitor.equals((Object)dp.getCompetitor()) && dp.getRound() == duoTable.getRound() && dp.getRank() == duoTable.getRank()).findFirst().orElse(null);
        if (duoPresentation == null) {
            duoPresentation = new DuoPresentation();
            duoPresentation.setCompetitor(competitor);
            duoPresentation.setCategory((Category)duo2023Category);
            duoPresentation.setStatus(DuoPresentation.Status.WAITING);
            duoPresentation.setRound(duoTable.getRound());
            duoPresentation.setRank(duoTable.getRank());
            duoPresentation.setGroupNumber(duoTable.getGroupNumber());
            duoPresentation.setGroupPosition(Integer.valueOf(groupPosition));
            duoPresentation.setNotNeeded(Boolean.FALSE);
            duoPresentation = this.duoPresentationManager.createDuoPresentation(duoPresentation);
            duoPresentations.add(duoPresentation);
        } else {
            duoPresentation.setGroupNumber(duoTable.getGroupNumber());
            duoPresentation.setGroupPosition(Integer.valueOf(groupPosition));
        }
        return duoPresentation;
    }

    private DuoPresentation getDuoPresentation(List<DuoPresentation> duoPresentations, Competitor competitor, DuoTable duoTable) {
        return duoPresentations.stream().filter(dp -> competitor.equals((Object)dp.getCompetitor()) && dp.getRound() == duoTable.getRound() && dp.getRank() == duoTable.getRank()).findFirst().orElse(null);
    }

    private Match getOrCreateMatch(Map<Integer, Match> matches, Duo2023Category duo2023Category, int fightNumber) {
        Match match = matches.get(fightNumber);
        if (match == null) {
            match = new Match();
            match.setCategory((Category)duo2023Category);
            match.setStatus(Match.Status.WAITING);
            match.setType(Match.Type.DUO2023);
            match.setFightNumber(Integer.valueOf(fightNumber));
            match.setNotNeeded(Boolean.FALSE);
            match.setMatchEmpty(Boolean.TRUE);
            match.setNoWinner(Boolean.FALSE);
            match = this.matchManager.createMatch(match);
            matches.put(fightNumber, match);
        }
        return match;
    }

    private Match getMatch(Map<Integer, Match> matches, int fightNumber) {
        return matches.get(fightNumber);
    }

    private void processDuoTable(CompetitionRules competitionRules, Duo2023Category duo2023Category, DuoTable duoTable, List<DuoPresentation> duoPresentations, int advances, boolean update) {
        if (duoTable.getRows() == null) {
            duoTable.setFinished(true);
            return;
        }
        for (int rowNum = 0; rowNum < duoTable.getRows().size(); ++rowNum) {
            DuoTable.Row row = (DuoTable.Row)duoTable.getRows().get(rowNum);
            DuoPresentation duoPresentation = update ? this.getOrCreateDuoPresentation(duoPresentations, row.getCompetitor(), duoTable, duo2023Category, rowNum + 1) : this.getDuoPresentation(duoPresentations, row.getCompetitor(), duoTable);
            if (duoPresentation == null) continue;
            Set duoPresentationPoints = this.duoPresentationManager.getDuoPresentationPointsForDuoPresentation(duoPresentation);
            float points = competitionRules.sumDuoPresentationPoints(duoPresentationPoints);
            row.setDuoPresentation(duoPresentation);
            row.setPoints(points);
        }
        Collections.sort(duoTable.getRows(), new Comparator<DuoTable.Row>(){

            @Override
            public int compare(DuoTable.Row o1, DuoTable.Row o2) {
                return -Float.compare(o1.getPoints(), o2.getPoints());
            }
        });
        boolean finished = false;
        if (duoTable.getRows().size() <= advances) {
            finished = true;
            duoTable.setNotNeeded(true);
            for (DuoTable.Row row : duoTable.getRows()) {
                row.getDuoPresentation().setNotNeeded(Boolean.valueOf(true));
            }
        } else {
            finished = true;
            for (DuoTable.Row row : duoTable.getRows()) {
                row.getDuoPresentation().setNotNeeded(Boolean.valueOf(false));
                if (row.getDuoPresentation().getStatus() == DuoPresentation.Status.FINISHED) continue;
                finished = false;
            }
        }
        duoTable.setFinished(finished);
        if (finished) {
            duoTable.setWinners(this.getWinners(duoTable, advances));
            duoTable.setLosers(this.getLosers(duoTable, advances));
        }
    }

    private List<Competitor> getWinners(DuoTable duoTable, int num) {
        LinkedList<Competitor> winners = new LinkedList<Competitor>();
        int pos = 0;
        float fourthPlacePoints = 0.0f;
        if (duoTable.getRows() == null) {
            return winners;
        }
        for (DuoTable.Row row : duoTable.getRows()) {
            if (++pos < num) {
                winners.add(row.getCompetitor());
                continue;
            }
            if (pos == num) {
                winners.add(row.getCompetitor());
                fourthPlacePoints = row.getPoints();
                continue;
            }
            if (pos <= num || !NumberUtil.areFloatsEqual((float)row.getPoints(), (float)fourthPlacePoints, (float)0.001f)) break;
            winners.add(row.getCompetitor());
        }
        return winners;
    }

    private List<Competitor> getLosers(DuoTable duoTable, int num) {
        LinkedList<Competitor> losers = new LinkedList<Competitor>();
        int pos = 0;
        float fourthPlacePoints = 0.0f;
        if (duoTable.getRows() == null) {
            return losers;
        }
        for (DuoTable.Row row : duoTable.getRows()) {
            if (++pos < num) continue;
            if (pos == num) {
                fourthPlacePoints = row.getPoints();
                continue;
            }
            if (pos > num && NumberUtil.areFloatsEqual((float)row.getPoints(), (float)fourthPlacePoints, (float)0.001f)) continue;
            losers.add(row.getCompetitor());
        }
        return losers;
    }

    private void processKnockoutStage(boolean update, CompetitionRules competitionRules, Map<Integer, Match> matches, Map<Integer, Set<MatchPoint>> matchPoints, Duo2023Category duo2023Category, int offset, DuoTable table1, DuoTable table2) {
        for (int i = 1; i <= 8; ++i) {
            Match m2;
            Match m1;
            Match match = update ? this.getOrCreateMatch(matches, duo2023Category, offset + i) : this.getMatch(matches, offset + i);
            if (match == null) continue;
            if (i == 1) {
                if (table1.isFinished()) {
                    match.setCompetitor1(table1.getWinner(0));
                } else {
                    match.setCompetitor1(null);
                }
                if (table2.isFinished()) {
                    match.setCompetitor2(table2.getWinner(3));
                } else {
                    match.setCompetitor2(null);
                }
                this.setMatchFlags(match, table1, table2);
                continue;
            }
            if (i == 2) {
                if (table2.isFinished()) {
                    match.setCompetitor1(table2.getWinner(1));
                } else {
                    match.setCompetitor1(null);
                }
                if (table1.isFinished()) {
                    match.setCompetitor2(table1.getWinner(2));
                } else {
                    match.setCompetitor2(null);
                }
                this.setMatchFlags(match, table1, table2);
                continue;
            }
            if (i == 3) {
                if (table2.isFinished()) {
                    match.setCompetitor1(table2.getWinner(0));
                } else {
                    match.setCompetitor1(null);
                }
                if (table1.isFinished()) {
                    match.setCompetitor2(table1.getWinner(3));
                } else {
                    match.setCompetitor2(null);
                }
                this.setMatchFlags(match, table1, table2);
                continue;
            }
            if (i == 4) {
                if (table1.isFinished()) {
                    match.setCompetitor1(table1.getWinner(1));
                } else {
                    match.setCompetitor1(null);
                }
                if (table2.isFinished()) {
                    match.setCompetitor2(table2.getWinner(2));
                } else {
                    match.setCompetitor2(null);
                }
                this.setMatchFlags(match, table1, table2);
                continue;
            }
            if (i == 5) {
                if (update) {
                    m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 1);
                    m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 2);
                } else {
                    m1 = this.getMatch(matches, offset + 1);
                    m2 = this.getMatch(matches, offset + 2);
                }
                this.setMatchProcessWinners(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
                continue;
            }
            if (i == 6) {
                if (update) {
                    m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 3);
                    m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 4);
                } else {
                    m1 = this.getMatch(matches, offset + 1);
                    m2 = this.getMatch(matches, offset + 2);
                }
                this.setMatchProcessWinners(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
                continue;
            }
            if (i == 7) {
                if (!duo2023Category.getDouble3rdPlace().booleanValue()) {
                    if (update) {
                        m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 5);
                        m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 6);
                    } else {
                        m1 = this.getMatch(matches, offset + 1);
                        m2 = this.getMatch(matches, offset + 2);
                    }
                    this.setMatchProcessLosers(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
                    continue;
                }
                match.setCompetitor1(null);
                match.setCompetitor2(null);
                match.setMatchEmpty(Boolean.valueOf(true));
                match.setNotNeeded(Boolean.valueOf(true));
                continue;
            }
            if (i != 8) continue;
            if (update) {
                m1 = this.getOrCreateMatch(matches, duo2023Category, offset + 5);
                m2 = this.getOrCreateMatch(matches, duo2023Category, offset + 6);
            } else {
                m1 = this.getMatch(matches, offset + 1);
                m2 = this.getMatch(matches, offset + 2);
            }
            this.setMatchProcessWinners(competitionRules, match, m1, matchPoints.get(m1.getFightNumber()), m2, matchPoints.get(m2.getFightNumber()));
        }
    }

    private void setMatchFlags(Match match, DuoTable table1, DuoTable table2) {
        if (table1.isFinished() && table2.isFinished()) {
            if (match.getCompetitor1() == null && match.getCompetitor2() == null) {
                match.setMatchEmpty(Boolean.valueOf(true));
                match.setNotNeeded(Boolean.valueOf(true));
            } else if (match.getCompetitor1() == null || match.getCompetitor2() == null) {
                match.setMatchEmpty(Boolean.valueOf(false));
                match.setNotNeeded(Boolean.valueOf(true));
            }
        } else {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(false));
        }
    }

    private void setMatchProcessWinners(CompetitionRules competitionRules, Match match, Match m1, Set<MatchPoint> mp1, Match m2, Set<MatchPoint> mp2) {
        boolean nn1 = false;
        boolean nn2 = false;
        if (m1 != null) {
            if (m1.getMatchEmpty().booleanValue() || m1.getNoWinner().booleanValue()) {
                match.setCompetitor1(null);
                nn1 = true;
            } else if (m1.getNotNeeded().booleanValue()) {
                if (m1.getCompetitor1() != null) {
                    match.setCompetitor1(m1.getCompetitor1());
                } else if (m1.getCompetitor2() != null) {
                    match.setCompetitor1(m1.getCompetitor2());
                } else {
                    match.setCompetitor1(null);
                }
                nn1 = match.getCompetitor1() == null;
            } else if (m1.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor1(competitionRules.getMatchWinner(m1, mp1));
                nn1 = match.getCompetitor1() == null;
            } else {
                match.setCompetitor1(null);
            }
        }
        if (m2 != null) {
            if (m2.getMatchEmpty().booleanValue() || m2.getNoWinner().booleanValue()) {
                match.setCompetitor2(null);
                nn2 = true;
            } else if (m2.getNotNeeded().booleanValue()) {
                if (m2.getCompetitor1() != null) {
                    match.setCompetitor2(m2.getCompetitor1());
                } else if (m2.getCompetitor2() != null) {
                    match.setCompetitor2(m2.getCompetitor2());
                } else {
                    match.setCompetitor2(null);
                }
                nn2 = match.getCompetitor2() == null;
            } else if (m2.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor2(competitionRules.getMatchWinner(m2, mp2));
                nn2 = match.getCompetitor2() == null;
            } else {
                match.setCompetitor2(null);
            }
        }
        if (nn1 && nn2) {
            match.setMatchEmpty(Boolean.valueOf(true));
            match.setNotNeeded(Boolean.valueOf(true));
        } else if (nn1 || nn2) {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(true));
        } else {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(false));
        }
    }

    private void setMatchProcessLosers(CompetitionRules competitionRules, Match match, Match m1, Set<MatchPoint> mp1, Match m2, Set<MatchPoint> mp2) {
        boolean nn1 = false;
        boolean nn2 = false;
        if (m1 != null) {
            if (m1.getMatchEmpty().booleanValue() || m1.getNotNeeded().booleanValue() || m1.getNoWinner().booleanValue()) {
                match.setCompetitor1(null);
                nn1 = true;
            } else if (m1.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor1(competitionRules.getMatchLoser(m1, mp1));
                nn1 = match.getCompetitor1() == null;
            } else {
                match.setCompetitor1(null);
            }
        }
        if (m2 != null) {
            if (m2.getMatchEmpty().booleanValue() || m2.getNotNeeded().booleanValue() || m2.getNoWinner().booleanValue()) {
                match.setCompetitor2(null);
                nn2 = true;
            } else if (m2.getStatus() == Match.Status.FINISHED) {
                match.setCompetitor2(competitionRules.getMatchLoser(m2, mp2));
                nn2 = match.getCompetitor2() == null;
            } else {
                match.setCompetitor2(null);
            }
        }
        if (nn1 && nn2) {
            match.setMatchEmpty(Boolean.valueOf(true));
            match.setNotNeeded(Boolean.valueOf(true));
        } else if (nn1 || nn2) {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(true));
        } else {
            match.setMatchEmpty(Boolean.valueOf(false));
            match.setNotNeeded(Boolean.valueOf(false));
        }
    }
}

