/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Set;
import org.jasypt.util.password.PasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.server.dl.dao.SemaphoreDAO;
import si.nevensrok.jtekma.server.management.SemaphoreManager;
import si.nevensrok.jtekma.services.common.Credentials;

public class SemaphoreManagerImpl
implements SemaphoreManager {
    private static final Logger log = LoggerFactory.getLogger(SemaphoreManagerImpl.class);
    private PasswordEncryptor passwordEncryptor;
    private SemaphoreDAO semaphoreDAO;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setSemaphoreDAO(SemaphoreDAO semaphoreDAO) {
        this.semaphoreDAO = semaphoreDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore createSemaphore(Semaphore semaphore) {
        semaphore.setPassword(this.passwordEncryptor.encryptPassword(semaphore.getPassword()));
        if (log.isDebugEnabled()) {
            log.debug("Creating tatami {}", (Object)semaphore);
        }
        return (Semaphore)this.semaphoreDAO.create((Pojo)semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore createSemaphoreWithPassword(Semaphore semaphore) {
        if (log.isDebugEnabled()) {
            log.debug("Creating tatami {}", (Object)semaphore);
        }
        return (Semaphore)this.semaphoreDAO.create((Pojo)semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore updateSemaphore(Semaphore semaphore) {
        if (log.isDebugEnabled()) {
            log.debug("Updating semaphore {}", (Object)semaphore);
        }
        return (Semaphore)this.semaphoreDAO.update((Pojo)semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateSemaphorePassword(Semaphore semaphore) {
        semaphore.setPassword(this.passwordEncryptor.encryptPassword(semaphore.getPassword()));
        if (log.isDebugEnabled()) {
            log.debug("Updating semaphore password {}", (Object)semaphore);
        }
        this.semaphoreDAO.updateSemaphorePassword(semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteSemaphore(Semaphore semaphore) {
        if (log.isDebugEnabled()) {
            log.debug("Deleting semaphore {}", (Object)semaphore);
        }
        this.semaphoreDAO.deleteSemaphore(semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore getById(Long semaphoreId) {
        return (Semaphore)this.semaphoreDAO.getById((Object)semaphoreId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Semaphore> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.semaphoreDAO.find(dataFilter);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore getActiveSemaphoreByName(Competition competition, String name) {
        return this.semaphoreDAO.getActiveSemaphoreByName(competition, name);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<TatamiOnSemaphore> getTatamisForSemaphore(Semaphore semaphore) {
        return this.semaphoreDAO.getTatamisForSemaphore(semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setTatamisForSemaphore(Semaphore semaphore, Set<TatamiOnSemaphore> tatamiOnSemaphores) {
        this.semaphoreDAO.setTatamisForSemaphore(semaphore, tatamiOnSemaphores);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Semaphore getSemaphoreByCredentials(Credentials credentials) {
        if (credentials.getUsername() == null || credentials.getPassword() == null) {
            return null;
        }
        Semaphore semaphore = this.semaphoreDAO.getSemaphoreForActiveCompetition(credentials.getUsername());
        if (semaphore == null) {
            return null;
        }
        if (this.passwordEncryptor.checkPassword(credentials.getPassword(), semaphore.getPassword())) {
            return semaphore;
        }
        return null;
    }
}

