/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchDetail;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.reports.ReportData;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dao.MatchDAO;
import si.nevensrok.jtekma.server.dl.dao.TatamiHistoryDAO;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class MatchManagerImpl
implements MatchManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchManagerImpl.class);
    private MatchDAO matchDAO;
    private TatamiManager tatamiManager;
    private TatamiFightsManager tatamiFightsManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;
    private CategoryManager categoryManager;
    private TatamiHistoryDAO tatamiHistoryDAO;

    public void setMatchDAO(MatchDAO matchDAO) {
        this.matchDAO = matchDAO;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setTatamiHistoryDAO(TatamiHistoryDAO tatamiHistoryDAO) {
        this.tatamiHistoryDAO = tatamiHistoryDAO;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Match createMatch(Match match) {
        LOGGER.debug("Creating match {}", (Object)match);
        return (Match)this.matchDAO.create((Pojo)match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Match> createMatches(List<Match> matches) {
        return this.matchDAO.createList(matches);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Match updateMatch(Match match) {
        LOGGER.debug("Updating match {}", (Object)match);
        return (Match)this.matchDAO.update((Pojo)match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Match getById(Long matchId) {
        return (Match)this.matchDAO.getById((Object)matchId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Match getByIdWithCompetitors(Long matchId) {
        return this.matchDAO.getByIdWithCompetitors(matchId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Match> getMatchesForCategory(Category category) {
        return this.matchDAO.getMatchesForCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Match getMatchForCategory(Category category, int matchNumber) {
        return this.matchDAO.getMatchForCategory(category, matchNumber);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchCompetitors(Match match, Competitor competitor1, Competitor competitor2) {
        this.matchDAO.setMatchCompetitors(match, competitor1, competitor2);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchStatus(Match match, Match.Status status) {
        Tatami tatami;
        this.matchDAO.setMatchStatus(match, status);
        Category category = this.categoryManager.getCategoryForMatch(match);
        if (category instanceof TreeCategory || category instanceof Duo2023Category) {
            this.categoryTreeUpdateManager.updateCategory(category);
        }
        if (status == Match.Status.FINISHED && (tatami = this.tatamiManager.getTatamiForMatch(match)) != null) {
            this.tatamiFightsManager.checkMatchFights(tatami);
        }
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchStartedAt(Match match) {
        this.matchDAO.setMatchStartedAt(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchFinishedAt(Match match) {
        Integer matchDuration = null;
        if (match.getStartedAt() != null && match.getFinishedAt() != null) {
            matchDuration = (int)((match.getFinishedAt().getTime() - match.getStartedAt().getTime()) / 1000L);
        }
        match.setMatchDuration(matchDuration);
        this.matchDAO.setMatchFinishedAt(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setFightTimeLeft(Match match) {
        this.matchDAO.setFightTimeLeft(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setHosekomiTime(Match match) {
        this.matchDAO.setHosekomiTime(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setInjuryTime(Match match) {
        this.matchDAO.setInjuryTime(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setChallenges(Match match) {
        this.matchDAO.setChallenges(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setNoWinner(Match match) {
        this.matchDAO.setNoWinner(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateMatchTreeAdvancmentData(Collection<Match> matches) {
        this.matchDAO.updateMatchTreeAdvancmentData(matches);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<MatchPoint> getMatchPointsForMatch(Match match) {
        return this.matchDAO.getMatchPointsForMatch(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Match, Set<MatchPoint>> getMatchPointsForMatches(Set<Match> matches) {
        return this.matchDAO.getMatchPointsForMatches(matches);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchPointsForMatch(Match match, Set<MatchPoint> points) {
        this.matchDAO.setMatchPointsForMatch(match, points);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<PointDetail> getMatchPointDetailsForMatch(Match match) {
        return this.matchDAO.getMatchPointDetailsForMatch(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Match, Set<PointDetail>> getMatchPointDetailsForMatches(Set<Match> matches) {
        return this.matchDAO.getMatchPointDetailsForMatches(matches);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setMatchPointDetailsForMatch(Match match, Set<PointDetail> pointDetails) {
        this.matchDAO.setMatchPointDetailsForMatch(match, pointDetails);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<ReportData<Integer, Integer>> getPointsReportForFightMatch(Match match) {
        ArrayList<ReportData<Integer, Integer>> reportDatas = new ArrayList<ReportData<Integer, Integer>>(2);
        Set<PointDetail> pointDetails = this.getMatchPointDetailsForMatch(match);
        int maxFightTime = 0;
        for (PointDetail pointDetail : pointDetails) {
            if (pointDetail.getFightTime() <= maxFightTime) continue;
            maxFightTime = pointDetail.getFightTime();
        }
        reportDatas.add(new ReportData());
        reportDatas.add(new ReportData());
        ((ReportData)reportDatas.get(0)).setLabel("Competitor1");
        ((ReportData)reportDatas.get(0)).setData(new LinkedList());
        ((ReportData)reportDatas.get(1)).setLabel("Competitor2");
        ((ReportData)reportDatas.get(1)).setData(new LinkedList());
        int competitor1points = 0;
        int competitor2points = 0;
        for (int i = 1; i <= maxFightTime; ++i) {
            for (PointDetail pointDetail : pointDetails) {
                if (pointDetail.getFightTime() != i) continue;
                int pointDiff = 0;
                if (pointDetail.getPointType() == PointType.WAZARI || pointDetail.getPointType() == PointType.POINT1) {
                    pointDiff = 1;
                } else if (pointDetail.getPointType() == PointType.IPPON1 || pointDetail.getPointType() == PointType.IPPON2 || pointDetail.getPointType() == PointType.IPPON3 || pointDetail.getPointType() == PointType.POINT2) {
                    pointDiff = 2;
                } else if (pointDetail.getPointType() == PointType.IPPON3POINTS || pointDetail.getPointType() == PointType.POINT3) {
                    pointDiff = 3;
                } else if (pointDetail.getPointType() == PointType.POINT4) {
                    pointDiff = 4;
                } else if (pointDetail.getPointType() == PointType.POINT5) {
                    pointDiff = 5;
                } else if (pointDetail.getPointType() == PointType.POINT6) {
                    pointDiff = 6;
                } else if (pointDetail.getPointType() == PointType.POINT7) {
                    pointDiff = 7;
                }
                if (pointDetail.getChangeType() == PointDetail.ChangeType.REMOVE) {
                    pointDiff = -pointDiff;
                }
                if (pointDetail.getCompetitor() == CompetitorType.COMPETITOR1) {
                    competitor1points += pointDiff;
                    continue;
                }
                if (pointDetail.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                competitor2points += pointDiff;
            }
            if (i % 10 != 0 && i != maxFightTime) continue;
            ((ReportData)reportDatas.get(0)).getData().add(new ReportData.Data((Object)i, (Object)competitor1points));
            ((ReportData)reportDatas.get(1)).getData().add(new ReportData.Data((Object)i, (Object)competitor2points));
        }
        return reportDatas;
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<ReportData<Integer, Float>> getPointsReportForDuoMatch(Match match) {
        ArrayList<ReportData<Integer, Float>> reportDatas = new ArrayList<ReportData<Integer, Float>>(2);
        Set<MatchPoint> matchPoints = this.getMatchPointsForMatch(match);
        reportDatas.add(new ReportData());
        reportDatas.add(new ReportData());
        ((ReportData)reportDatas.get(0)).setLabel("Competitor1");
        ((ReportData)reportDatas.get(0)).setData(new LinkedList());
        ((ReportData)reportDatas.get(1)).setLabel("Competitor2");
        ((ReportData)reportDatas.get(1)).setData(new LinkedList());
        for (int round = 1; round <= 5; ++round) {
            float competitor1points = 0.0f;
            float competitor2points = 0.0f;
            float c1max = 0.0f;
            float c1min = Float.MAX_VALUE;
            float c2max = 0.0f;
            float c2min = Float.MAX_VALUE;
            for (MatchPoint matchPoint : matchPoints) {
                if (matchPoint.getRound() != round) continue;
                if (matchPoint.getCompetitor() == CompetitorType.COMPETITOR1) {
                    competitor1points += matchPoint.getPoints().floatValue();
                    if (matchPoint.getPoints().floatValue() > c1max) {
                        c1max = matchPoint.getPoints().floatValue();
                    }
                    if (!(matchPoint.getPoints().floatValue() < c1min)) continue;
                    c1min = matchPoint.getPoints().floatValue();
                    continue;
                }
                if (matchPoint.getCompetitor() != CompetitorType.COMPETITOR2) continue;
                competitor2points += matchPoint.getPoints().floatValue();
                if (matchPoint.getPoints().floatValue() > c2max) {
                    c2max = matchPoint.getPoints().floatValue();
                }
                if (!(matchPoint.getPoints().floatValue() < c2min)) continue;
                c2min = matchPoint.getPoints().floatValue();
            }
            if (c1min > 100000.0f) {
                c1min = 0.0f;
            }
            if (c2min > 100000.0f) {
                c2min = 0.0f;
            }
            competitor1points -= c1max + c1min;
            competitor2points -= c2max + c2min;
            competitor1points = (float)Math.round(competitor1points * 100.0f) / 100.0f;
            competitor2points = (float)Math.round(competitor2points * 100.0f) / 100.0f;
            ((ReportData)reportDatas.get(0)).getData().add(new ReportData.Data((Object)round, (Object)Float.valueOf(competitor1points)));
            ((ReportData)reportDatas.get(1)).getData().add(new ReportData.Data((Object)round, (Object)Float.valueOf(competitor2points)));
        }
        return reportDatas;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteMatch(Match match) {
        this.tatamiFightsManager.removeMatch(match);
        this.tatamiHistoryDAO.deleteMatchFromTatamiHistory(match);
        this.matchDAO.deleteMatch(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competitor, Set<MatchDetail>> getMatchDetailsForCompetitors(Set<Competitor> competitors) {
        return this.matchDAO.getMatchDetailsForCompetitors(competitors);
    }

    @Transactional(value="jtekmaTransactionManager")
    public boolean isChallengeAvailable(Category category, Match match, Competitor competitor) {
        Match m2;
        if (category == null || category.getCategoryId() == null) {
            return false;
        }
        if (match == null || match.getMatchId() == null) {
            return false;
        }
        if (competitor == null || competitor.getCompetitorId() == null) {
            return false;
        }
        if (!(category instanceof TreeCategory)) {
            return true;
        }
        TreeCategory treeCategory = (TreeCategory)category;
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        for (Match m2 : this.getMatchesForCategory(category)) {
            matches.put(m2.getFightNumber(), m2);
        }
        if (treeCategory.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
            for (int i = 1; i <= 3; ++i) {
                m2 = (Match)matches.get(i);
                if (m2 == null || match.getMatchId().equals(m2.getMatchId()) || m2.getStatus() != Match.Status.FINISHED) continue;
                if (m2.getCompetitor1() != null && competitor.getCompetitorId().equals(m2.getCompetitor1().getCompetitorId()) && m2.getChallengesLost1() != null && m2.getChallengesLost1() > 0) {
                    return false;
                }
                if (m2.getCompetitor2() == null || !competitor.getCompetitorId().equals(m2.getCompetitor2().getCompetitorId()) || m2.getChallengesLost2() == null || m2.getChallengesLost2() <= 0) continue;
                return false;
            }
        } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
            for (int i = 1; i <= 10; ++i) {
                m2 = (Match)matches.get(i);
                if (m2 == null || match.getMatchId().equals(m2.getMatchId()) || m2.getStatus() != Match.Status.FINISHED) continue;
                if (m2.getCompetitor1() != null && competitor.getCompetitorId().equals(m2.getCompetitor1().getCompetitorId()) && m2.getChallengesLost1() != null && m2.getChallengesLost1() > 0) {
                    return false;
                }
                if (m2.getCompetitor2() == null || !competitor.getCompetitorId().equals(m2.getCompetitor2().getCompetitorId()) || m2.getChallengesLost2() == null || m2.getChallengesLost2() <= 0) continue;
                return false;
            }
        } else {
            int matchNum = match.getFightNumber();
            if (matchNum == 124 || matchNum == 123) {
                return true;
            }
            if (treeCategory.getDouble3rdPlace().booleanValue() && (matchNum == 122 || matchNum == 121)) {
                return true;
            }
            for (int i = 1; i < matchNum; ++i) {
                Match m3 = (Match)matches.get(i);
                if (m3 == null || m3.getStatus() != Match.Status.FINISHED) continue;
                if (m3.getCompetitor1() != null && competitor.getCompetitorId().equals(m3.getCompetitor1().getCompetitorId()) && m3.getChallengesLost1() != null && m3.getChallengesLost1() > 0) {
                    return false;
                }
                if (m3.getCompetitor2() == null || !competitor.getCompetitorId().equals(m3.getCompetitor2().getCompetitorId()) || m3.getChallengesLost2() == null || m3.getChallengesLost2() <= 0) continue;
                return false;
            }
        }
        return true;
    }
}

