/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.schema.competition.CompetitionData;
import si.nevensrok.jtekma.server.exporters.CompetitionExporter;
import si.nevensrok.jtekma.server.exporters.CompetitionV1Exporter;
import si.nevensrok.jtekma.server.importers.CompetitionImporter;
import si.nevensrok.jtekma.server.importers.CompetitionV1Importer;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryGroupManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitionImportManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;
import si.nevensrok.jtekma.server.management.DataExportImportManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.NextMatchUploadManager;
import si.nevensrok.jtekma.server.management.SemaphoreManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;
import si.nevensrok.jtekma.server.management.WeightCategoryOptionManager;

public class DataExportImportManagerImpl
implements DataExportImportManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataExportImportManagerImpl.class);
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private CompetitionManager competitionManager;
    private ClubManager clubManager;
    private CategoryManager categoryManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private WeightCategoryOptionManager weightCategoryOptionManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private CompetitorManager competitorManager;
    private MatchManager matchManager;
    private DuoPresentationManager duoPresentationManager;
    private TatamiManager tatamiManager;
    private SemaphoreManager semaphoreManager;
    private TatamiFightsManager tatamiFightsManager;
    private CompetitionImportManager competitionImportManager;
    private TaskExecutor taskExecutor;
    private NextMatchUploadManager nextMatchUploadManager;
    private CategoryGroupManager categoryGroupManager;
    private TatamiHistoryManager tatamiHistoryManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setWeightCategoryOptionManager(WeightCategoryOptionManager weightCategoryOptionManager) {
        this.weightCategoryOptionManager = weightCategoryOptionManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setCompetitorManager(CompetitorManager competitorManager) {
        this.competitorManager = competitorManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setCompetitionImportManager(CompetitionImportManager competitionImportManager) {
        this.competitionImportManager = competitionImportManager;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setNextMatchUploadManager(NextMatchUploadManager nextMatchUploadManager) {
        this.nextMatchUploadManager = nextMatchUploadManager;
    }

    public void setCategoryGroupManager(CategoryGroupManager categoryGroupManager) {
        this.categoryGroupManager = categoryGroupManager;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public byte[] exportCompetition(Competition competition) {
        try {
            CompetitionV1Exporter competitionExporter = new CompetitionV1Exporter();
            competitionExporter.setCompetitionId(competition.getCompetitionId());
            competitionExporter.setCompetitionManager(this.competitionManager);
            competitionExporter.setCategoryManager(this.categoryManager);
            competitionExporter.setClubManager(this.clubManager);
            competitionExporter.setAgeCategoryOptionManager(this.ageCategoryOptionManager);
            competitionExporter.setWeightCategoryOptionManager(this.weightCategoryOptionManager);
            competitionExporter.setTreeAdvancmentManager(this.treeAdvancmentManager);
            competitionExporter.setCompetitorManager(this.competitorManager);
            competitionExporter.setMatchManager(this.matchManager);
            competitionExporter.setDuoPresentationManager(this.duoPresentationManager);
            competitionExporter.setTatamiManager(this.tatamiManager);
            competitionExporter.setSemaphoreManager(this.semaphoreManager);
            competitionExporter.setNextMatchUploadManager(this.nextMatchUploadManager);
            competitionExporter.setCategoryGroupManager(this.categoryGroupManager);
            competitionExporter.setTatamiHistoryManager(this.tatamiHistoryManager);
            CompetitionData competitionData = ((CompetitionExporter)competitionExporter).generateCompetitionData();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            GZIPOutputStream outputStream = new GZIPOutputStream(buffer);
            this.marshaller.marshal((Object)competitionData, (Result)new StreamResult(outputStream));
            ((OutputStream)outputStream).close();
            return buffer.toByteArray();
        }
        catch (Exception e) {
            LOGGER.error("Error while exporting competition", (Throwable)e);
            return null;
        }
    }

    public void importCompetition(final byte[] data) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(data));
                        CompetitionData competitionData = (CompetitionData)DataExportImportManagerImpl.this.unmarshaller.unmarshal((Source)new StreamSource(inputStream));
                        CompetitionV1Importer competitionImporter = new CompetitionV1Importer();
                        competitionImporter.setCompetitionManager(DataExportImportManagerImpl.this.competitionManager);
                        competitionImporter.setCategoryManager(DataExportImportManagerImpl.this.categoryManager);
                        competitionImporter.setClubManager(DataExportImportManagerImpl.this.clubManager);
                        competitionImporter.setAgeCategoryOptionManager(DataExportImportManagerImpl.this.ageCategoryOptionManager);
                        competitionImporter.setWeightCategoryOptionManager(DataExportImportManagerImpl.this.weightCategoryOptionManager);
                        competitionImporter.setTreeAdvancmentManager(DataExportImportManagerImpl.this.treeAdvancmentManager);
                        competitionImporter.setCompetitorManager(DataExportImportManagerImpl.this.competitorManager);
                        competitionImporter.setMatchManager(DataExportImportManagerImpl.this.matchManager);
                        competitionImporter.setDuoPresentationManager(DataExportImportManagerImpl.this.duoPresentationManager);
                        competitionImporter.setTatamiManager(DataExportImportManagerImpl.this.tatamiManager);
                        competitionImporter.setSemaphoreManager(DataExportImportManagerImpl.this.semaphoreManager);
                        competitionImporter.setTatamiFightsManager(DataExportImportManagerImpl.this.tatamiFightsManager);
                        competitionImporter.setCompetitionImportManager(DataExportImportManagerImpl.this.competitionImportManager);
                        competitionImporter.setNextMatchUploadManager(DataExportImportManagerImpl.this.nextMatchUploadManager);
                        competitionImporter.setCategoryGroupManager(DataExportImportManagerImpl.this.categoryGroupManager);
                        competitionImporter.setTatamiHistoryManager(DataExportImportManagerImpl.this.tatamiHistoryManager);
                        competitionImporter.setCategoryTreeUpdateManager(DataExportImportManagerImpl.this.categoryTreeUpdateManager);
                        ((CompetitionImporter)competitionImporter).importCompetition(competitionData);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while importing competition", (Throwable)e);
                    }
                }
            };
            this.taskExecutor.execute(runnable);
        }
        catch (Exception e) {
            LOGGER.error("Error starting competition import task", (Throwable)e);
        }
    }
}

