/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.htmlgenerator;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.server.htmlgenerator.NextFightHtmlGenerator;

public class NextFightHtmlGeneratorImpl
implements NextFightHtmlGenerator {
    private TextRenderer textRenderer;

    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    @Override
    public String generateHtml(String templatePage, Locale locale, List<TatamiFightOrder> tatamiFightOrders) {
        LinkedList<Tatami> tatamis = new LinkedList<Tatami>();
        LinkedHashMap<Integer, LinkedHashMap<Long, FightOrder>> fightOrders = new LinkedHashMap<Integer, LinkedHashMap<Long, FightOrder>>();
        int totalRows = 0;
        for (TatamiFightOrder tatamiFightOrder : tatamiFightOrders) {
            tatamis.add(tatamiFightOrder.getTatami());
            int currentRow = 0;
            for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                LinkedHashMap<Long, FightOrder> fightOrdersForRow;
                if (++currentRow > totalRows) {
                    totalRows = currentRow;
                }
                if ((fightOrdersForRow = (LinkedHashMap<Long, FightOrder>)fightOrders.get(currentRow)) == null) {
                    fightOrdersForRow = new LinkedHashMap<Long, FightOrder>();
                    fightOrders.put(currentRow, fightOrdersForRow);
                }
                fightOrdersForRow.put(tatamiFightOrder.getTatami().getTatamiId(), fightOrder);
            }
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("tatamis", tatamis);
        data.put("fightOrders", fightOrders);
        data.put("totalRows", totalRows);
        String html = this.textRenderer.renderText(templatePage, data, locale);
        return html;
    }
}

